/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.layout.admin.web.internal.handler.LayoutExceptionRequestHandler;
import com.liferay.layout.admin.web.internal.portlet.action.ActionUtil;
import com.liferay.layout.admin.web.internal.portlet.action.BaseAddLayoutMVCActionCommand;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/add_simple_layout"}, service={MVCActionCommand.class})
public class AddSimpleLayoutMVCActionCommand
extends BaseAddLayoutMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(AddSimpleLayoutMVCActionCommand.class);
    @Reference
    private ActionUtil _actionUtil;
    @Reference
    private LayoutExceptionRequestHandler _layoutExceptionRequestHandler;
    @Reference
    private LayoutService _layoutService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentLayoutId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            Layout layout = this._layoutService.addLayout(groupId, privateLayout, parentLayoutId, nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), type, typeSettingsProperties.toString(), false, new HashMap(), serviceContext);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
            this._layoutService.updateLayout(groupId, privateLayout, layout.getLayoutId(), layout.getTypeSettings());
            this._actionUtil.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layout.getTypeSettingsProperties());
            SessionMessages.add((PortletRequest)actionRequest, (String)"layoutAdded", (Object)layout);
            String redirectURL = this.getRedirectURL(actionRequest, actionResponse, layout);
            if (Objects.equals(type, "content")) {
                redirectURL = this.getContentRedirectURL(actionResponse, layout);
            }
            jsonObject.put("redirectURL", redirectURL);
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            SessionErrors.add((PortletRequest)actionRequest, (String)"layoutNameInvalid");
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            this._layoutExceptionRequestHandler.handlePortalException(actionRequest, actionResponse, pe);
        }
    }
}

