/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.admin.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/copy_layout"}, service={MVCActionCommand.class})
public class CopyLayoutMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(CopyLayoutMVCActionCommand.class);
    @Reference
    private ActionUtil _actionUtil;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"layoutId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(themeDisplay.getLocale(), name);
        if (!Objects.equals(themeDisplay.getLocale(), LocaleUtil.getSiteDefault())) {
            nameMap.put(LocaleUtil.getSiteDefault(), name);
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            Layout copyLayout = this._layoutLocalService.fetchLayout(groupId, privateLayout, layoutId);
            LayoutTypePortlet copyLayoutTypePortlet = (LayoutTypePortlet)copyLayout.getLayoutType();
            UnicodeProperties copyTypeSettingsProperties = copyLayout.getTypeSettingsProperties();
            copyTypeSettingsProperties.putAll((Map)typeSettingsProperties);
            Layout layout = this._layoutService.addLayout(groupId, privateLayout, copyLayout.getParentLayoutId(), nameMap, new HashMap(), new HashMap(), copyLayout.getKeywordsMap(), copyLayout.getRobotsMap(), copyLayout.getType(), typeSettingsProperties.toString(), false, new HashMap(), serviceContext);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), copyLayoutTypePortlet.getLayoutTemplateId());
            this._layoutService.updateLayout(groupId, privateLayout, layout.getLayoutId(), layout.getTypeSettings());
            com.liferay.portlet.sites.action.ActionUtil.copyPreferences((PortletRequest)actionRequest, (Layout)layout, (Layout)copyLayout);
            SitesUtil.copyLookAndFeel((Layout)layout, (Layout)copyLayout);
            long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
            long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
            this._actionUtil.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layout.getTypeSettingsProperties());
            List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(copyLayout.getGroupId(), this._portal.getClassNameId(Layout.class), copyLayout.getPlid());
            if (ListUtil.isNotEmpty((List)fragmentEntryLinks)) {
                for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                    this._copyFragmentEntryLink(layout.getPlid(), fragmentEntryLink, serviceContext);
                }
            }
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
            PortletURL redirectURL = liferayPortletResponse.createRenderURL();
            jsonObject.put("redirectURL", redirectURL.toString());
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            jsonObject.put("error", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"an-unexpected-error-occurred"));
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
    }

    private void _copyFragmentEntryLink(long newPlid, FragmentEntryLink fragmentEntryLink, ServiceContext serviceContext) throws PortalException {
        FragmentEntryLink newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, fragmentEntryLink.getFragmentEntryId(), this._portal.getClassNameId(Layout.class), newPlid, fragmentEntryLink.getCss(), fragmentEntryLink.getHtml(), fragmentEntryLink.getJs(), fragmentEntryLink.getEditableValues(), fragmentEntryLink.getPosition(), serviceContext);
        List portletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
        for (String portletId : portletIds) {
            long defaultPlid = this._portal.getControlPanelPlid(serviceContext.getCompanyId());
            PortletPreferences portletPreferences = this._portletPreferencesLocalService.fetchPreferences(serviceContext.getCompanyId(), 0L, 3, defaultPlid, portletId);
            if (portletPreferences == null) continue;
            String newPortletId = StringUtil.replace((String)portletId, (String)fragmentEntryLink.getNamespace(), (String)newFragmentEntryLink.getNamespace());
            this._portletPreferencesLocalService.addPortletPreferences(serviceContext.getCompanyId(), 0L, 3, defaultPlid, newPortletId, null, PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences));
        }
    }
}

