/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.upgrade.v_1_0_1;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.portlet.PortletPreferences;

public class UpgradeLayoutType
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.journal.model.JournalArticle";
    private static final String _PORTLET_ID_JOURNAL_CONTENT = "com_liferay_journal_content_web_portlet_JournalContentPortlet";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeLayoutType.class);
    private final JournalArticleResourceLocalService _journalArticleResourceLocalService;

    public UpgradeLayoutType(JournalArticleResourceLocalService journalArticleResourceLocalService) {
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
    }

    protected void addPortletPreferences(long companyId, long groupId, long plid, String portletId, String journalArticleId) throws Exception {
        String portletPreferences = this.getPortletPreferences(groupId, journalArticleId);
        PortletPreferencesLocalServiceUtil.addPortletPreferences((long)companyId, (long)0L, (int)3, (long)plid, (String)portletId, null, (String)portletPreferences);
    }

    protected void doUpgrade() throws Exception {
        this.updateLayouts();
    }

    protected long getAssetEntryId(long resourcePrimKey) throws Exception {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)_CLASS_NAME, (long)resourcePrimKey);
        if (assetEntry == null) {
            throw new UpgradeException("Unable to find asset entry for a journal article with classPK " + resourcePrimKey);
        }
        return assetEntry.getEntryId();
    }

    protected String getJournalArticleId(String typeSettings) throws Exception {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        return typeSettingsProperties.getProperty("article-id");
    }

    protected String getPortletId() {
        return PortletIdCodec.encode((String)_PORTLET_ID_JOURNAL_CONTENT);
    }

    protected String getPortletPreferences(long groupId, String journalArticleId) throws Exception {
        if (Validator.isNull((String)journalArticleId)) {
            return null;
        }
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        portletPreferences.setValue("articleId", journalArticleId);
        portletPreferences.setValue("groupId", String.valueOf(groupId));
        JournalArticleResource journalArticleResource = this._journalArticleResourceLocalService.fetchArticleResource(groupId, journalArticleId);
        if (journalArticleResource == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to locate journal article ", journalArticleId, " in group ", groupId}));
            }
        } else {
            long assetEntryId = this.getAssetEntryId(journalArticleResource.getResourcePrimKey());
            portletPreferences.setValue("assetEntryId", String.valueOf(assetEntryId));
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected String getTypeSettings(String portletId) {
        UnicodeProperties newTypeSettings = new UnicodeProperties(true);
        newTypeSettings.put("column-1", portletId);
        newTypeSettings.put("layout-template-id", "1_column");
        return newTypeSettings.toString();
    }

    protected void updateLayout(long plid, String portletId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ?, type_ = ? where plid = ?");){
            ps.setString(1, this.getTypeSettings(portletId));
            ps.setString(2, "portlet");
            ps.setLong(3, plid);
            ps.executeUpdate();
        }
    }

    protected void updateLayouts() throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select plid, groupId, companyId, typeSettings from Layout where type_ = ?");){
            ps.setString(1, "article");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long plid = rs.getLong("plid");
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    String typeSettings = rs.getString("typeSettings");
                    String portletId = this.getPortletId();
                    String journalArticleId = this.getJournalArticleId(typeSettings);
                    this.addPortletPreferences(companyId, groupId, plid, portletId, journalArticleId);
                    this.updateLayout(plid, portletId);
                }
            }
        }
    }
}

