/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.upgrade.v_1_0_2;

import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeLayoutSetTypeSettings
extends UpgradeProcess {
    private final GroupLocalService _groupLocalService;
    private final LayoutSetLocalService _layoutSetLocalService;

    public UpgradeLayoutSetTypeSettings(GroupLocalService groupLocalService, LayoutSetLocalService layoutSetLocalService) {
        this._groupLocalService = groupLocalService;
        this._layoutSetLocalService = layoutSetLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.updateRobots();
    }

    protected void updateLayoutSetTypeSettings(String key, String property, long groupId, boolean privateLayout) throws Exception {
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        UnicodeProperties typeSettings = layoutSet.getSettingsProperties();
        typeSettings.setProperty(key, property);
        this._layoutSetLocalService.updateSettings(groupId, privateLayout, typeSettings.toString());
    }

    protected void updateRobots() throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId, typeSettings from Group_ where typeSettings like '%robots.txt%'");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String publicRobots;
                long groupId = rs.getLong("groupId");
                String typeSettings = rs.getString("typeSettings");
                UnicodeProperties typeSettingsProperties = new UnicodeProperties();
                typeSettingsProperties.load(typeSettings);
                String privateRobots = typeSettingsProperties.getProperty("true-robots.txt");
                if (privateRobots != null) {
                    this.updateLayoutSetTypeSettings("true-robots.txt", privateRobots, groupId, true);
                    typeSettingsProperties.remove((Object)"true-robots.txt");
                }
                if ((publicRobots = typeSettingsProperties.getProperty("false-robots.txt")) != null) {
                    this.updateLayoutSetTypeSettings("false-robots.txt", publicRobots, groupId, false);
                    typeSettingsProperties.remove((Object)"false-robots.txt");
                }
                this._groupLocalService.updateGroup(groupId, typeSettingsProperties.toString());
            }
        }
    }
}

