Liferay.Loader.define("layout-admin-web@2.0.21/js/fragments_editor/dialogs/SelectMappingDialog.es", ['exports', 'metal-state/src/all/state', 'frontend-js-web/liferay/PortletBase.es', 'metal-soy/src/Soy', './SelectMappingDialog.soy'], function (exports, _state, _PortletBase2, _Soy, _SelectMappingDialog) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.SelectMappingDialog = undefined;

	var _PortletBase3 = _interopRequireDefault(_PortletBase2);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _SelectMappingDialog2 = _interopRequireDefault(_SelectMappingDialog);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * List of editable types and their compatibilities
  * with the corresponding mappeable types
  * @review
  * @see DDMStructureClassType.java for compatible types
  * @type {!object}
  */

	var COMPATIBLE_TYPES = {
		html: ['ddm-date', 'ddm-decimal', 'ddm-integer', 'ddm-number', 'ddm-text-html', 'text'],

		image: ['ddm-image', 'image'],

		'rich-text': ['ddm-date', 'ddm-decimal', 'ddm-integer', 'ddm-number', 'ddm-text-html', 'text'],

		text: ['ddm-date', 'ddm-decimal', 'ddm-integer', 'ddm-number', 'text']
	};

	/**
  * SelectMappingDialog
  */

	var SelectMappingDialog = function (_PortletBase) {
		_inherits(SelectMappingDialog, _PortletBase);

		function SelectMappingDialog() {
			_classCallCheck(this, SelectMappingDialog);

			return _possibleConstructorReturn(this, (SelectMappingDialog.__proto__ || Object.getPrototypeOf(SelectMappingDialog)).apply(this, arguments));
		}

		_createClass(SelectMappingDialog, [{
			key: 'prepareStateForRender',
			value: function prepareStateForRender(state) {
				var editableType = state.editableType;

				var mappeableFields = state._mappeableFields ? state._mappeableFields.map(function (mappeableField) {
					return {
						enabled: COMPATIBLE_TYPES[editableType] && COMPATIBLE_TYPES[editableType].indexOf(mappeableField.type) !== -1,
						key: mappeableField.key,
						label: mappeableField.label
					};
				}) : null;

				return _extends({}, state, { _mappeableFields: mappeableFields });
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				if (this.visible && !this._loadingMappeableFields && !this._mappeableFields) {
					this._loadMappeableFields();
				}
			}
		}, {
			key: '_emitMappeableFieldSelected',
			value: function _emitMappeableFieldSelected() {
				var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

				this.emit('mappeableFieldSelected', {
					editableId: this.editableId,
					fragmentEntryLinkId: this.fragmentEntryLinkId,
					key: key
				});

				this.visible = false;
			}
		}, {
			key: '_handleCancelButtonClick',
			value: function _handleCancelButtonClick() {
				this.visible = false;
			}
		}, {
			key: '_handleUnmapButtonClick',
			value: function _handleUnmapButtonClick() {
				this._emitMappeableFieldSelected('');
			}
		}, {
			key: '_handleMappeableFieldLinkClick',
			value: function _handleMappeableFieldLinkClick(event) {
				this._emitMappeableFieldSelected(event.delegateTarget.dataset.key);
			}
		}, {
			key: '_handleVisibleChanged',
			value: function _handleVisibleChanged(change) {
				if (this.visible !== change.newVal) {
					this.visible = change.newVal;
				}
			}
		}, {
			key: '_loadMappeableFields',
			value: function _loadMappeableFields() {
				var _this2 = this;

				var classNameId = this.selectedMappingTypes.type ? this.selectedMappingTypes.type.id : '';

				var classTypeId = this.selectedMappingTypes.subtype ? this.selectedMappingTypes.subtype.id : '';

				this._loadingMappeableFields = true;
				this._mappeableFields = null;

				return this.fetch(this.mappingFieldsURL, {
					classNameId: classNameId,
					classTypeId: classTypeId
				}).then(function (response) {
					return response.json();
				}).then(function (responseContent) {
					_this2._loadingMappeableFields = false;
					_this2._mappeableFields = responseContent;
				});
			}
		}]);

		return SelectMappingDialog;
	}(_PortletBase3.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	SelectMappingDialog.STATE = {

		/**
   * EditableId of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {string}
   */

		editableId: _state.Config.string().value(''),

		/**
   * Editable type that is being mapped.
   * This should match the corresponding mappeableField type in order
   * to be available.
   * @default ''
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {string}
   */

		editableType: _state.Config.string().value(''),

		/**
   * FragmentEntryLinkId of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {string}
   */

		fragmentEntryLinkId: _state.Config.string().value(''),

		/**
   * Mapped field ID of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf SelectMappingDialog
   * @private
   * @review
   * @type {string}
   */

		mappedFieldId: _state.Config.string().value(''),

		/**
   * URL for getting the list of mapping fields
   * @default undefined
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {!string}
   */

		mappingFieldsURL: _state.Config.string().required(),

		/**
   * Selected mapping types
   * @default {}
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {{
   *   subtype: {
   *   	id: !string,
   *   	label: !string
   *   },
   *   type: {
   *   	id: !string,
   *   	label: !string
   *   }
   * }}
   */

		selectedMappingTypes: _state.Config.shapeOf({
			subtype: _state.Config.shapeOf({
				id: _state.Config.string().required(),
				label: _state.Config.string().required()
			}),
			type: _state.Config.shapeOf({
				id: _state.Config.string().required(),
				label: _state.Config.string().required()
			})
		}).value({}),

		/**
   * Path of the available icons.
   * @default undefined
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {!string}
   */

		spritemap: _state.Config.string().required(),

		/**
   * Flag indicating if the SelectMappingDialog should be shown
   * @default false
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @type {boolean}
   */

		visible: _state.Config.bool().value(false),

		/**
   * Flag indicating if mappeable fields are being loaded
   * @default false
   * @instance
   * @memberOf SelectMappingDialog
   * @private
   * @review
   * @type {boolean}
   */

		_loadingMappeableFields: _state.Config.bool().value(false),

		/**
   * List of mappeable fields being shown as options
   * @default null
   * @instance
   * @memberOf SelectMappingDialog
   * @review
   * @private
   * @type {null|Array<{
   *   key: !string,
   *   label: !string
   * }>}
   */

		_mappeableFields: _state.Config.arrayOf(_state.Config.shapeOf({
			key: _state.Config.string().required(),
			label: _state.Config.string().required(),
			type: _state.Config.string().required()
		})).value(null)

	};

	_Soy2.default.register(SelectMappingDialog, _SelectMappingDialog2.default);

	exports.SelectMappingDialog = SelectMappingDialog;
	exports.default = SelectMappingDialog;
});
//# sourceMappingURL=SelectMappingDialog.es.js.map
