Liferay.Loader.define("layout-admin-web@2.0.21/js/fragments_editor/fragment_entry_link/FragmentEntryLink.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-state/src/all/state', 'metal-dom/src/all/dom', 'metal/src/metal', './FragmentEditableField.es', './FragmentEntryLink.soy'], function (exports, _component, _Soy, _state, _dom, _metal, _FragmentEditableField, _FragmentEntryLink) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentEntryLink = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentEditableField2 = _interopRequireDefault(_FragmentEditableField);

	var _FragmentEntryLink2 = _interopRequireDefault(_FragmentEntryLink);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}

			return arr2;
		} else {
			return Array.from(arr);
		}
	}

	function _defineProperty(obj, key, value) {
		if (key in obj) {
			Object.defineProperty(obj, key, {
				value: value,
				enumerable: true,
				configurable: true,
				writable: true
			});
		} else {
			obj[key] = value;
		}

		return obj;
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ARROW_DOWN_KEYCODE = 40;

	var ARROW_UP_KEYCODE = 38;

	var EDITABLE_FRAGMENT_ENTRY_PROCESSOR = 'com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor';

	/**
  * FragmentEntryLink
  * @review
  */

	var FragmentEntryLink = function (_Component) {
		_inherits(FragmentEntryLink, _Component);

		function FragmentEntryLink() {
			_classCallCheck(this, FragmentEntryLink);

			return _possibleConstructorReturn(this, (FragmentEntryLink.__proto__ || Object.getPrototypeOf(FragmentEntryLink)).apply(this, arguments));
		}

		_createClass(FragmentEntryLink, [{
			key: 'created',
			value: function created() {
				this._handleEditableChanged = this._handleEditableChanged.bind(this);
				this._handleMapButtonClick = this._handleMapButtonClick.bind(this);
				this._updateEditableStatus = this._updateEditableStatus.bind(this);
			}
		}, {
			key: 'disposed',
			value: function disposed() {
				this._destroyEditables();
			}
		}, {
			key: 'prepareStateForRender',
			value: function prepareStateForRender(state) {
				return _extends({}, state, {
					content: this.content ? _Soy2.default.toIncDom(this.content) : null
				});
			}
		}, {
			key: 'syncContent',
			value: function syncContent(newContent) {
				if (newContent) {
					this._renderContent(newContent);
				}
			}
		}, {
			key: 'syncEditableValues',
			value: function syncEditableValues(newEditableValues) {
				if (this._editables) {
					this._editables.forEach(function (editable) {
						var editableValues = newEditableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR] && newEditableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.editableId] ? newEditableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.editableId] : { defaultValue: editable.content };

						editable.editableValues = editableValues;
					});
				}
			}
		}, {
			key: 'syncLanguageId',
			value: function syncLanguageId() {
				if (this.content) {
					this._renderContent(this.content);
				}
			}
		}, {
			key: 'getEditableValue',
			value: function getEditableValue(editableId) {
				return this.getEditableValues()[editableId];
			}
		}, {
			key: 'getEditableValues',
			value: function getEditableValues() {
				return this.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR];
			}
		}, {
			key: 'setEditableValue',
			value: function setEditableValue(editableId, content) {
				var editableValues = this.getEditableValues();

				var editableValue = this.getEditableValue(editableId);

				editableValues[editableId] = _metal.object.mixin({}, editableValue, content);

				this._update(this.languageId, this.defaultLanguageId, [this._updateEditableStatus]);

				return _defineProperty({}, EDITABLE_FRAGMENT_ENTRY_PROCESSOR, editableValues);
			}
		}, {
			key: '_createEditables',
			value: function _createEditables() {
				var _this2 = this;

				this._destroyEditables();

				this._editables = [].concat(_toConsumableArray(this.refs.content.querySelectorAll('lfr-editable'))).map(function (editable) {
					var editableValues = _this2.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR] && _this2.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.id] ? _this2.editableValues[EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.id] : { defaultValue: editable.innerHTML };

					var defaultEditorConfiguration = _this2.defaultEditorConfigurations[editable.getAttribute('type')] || _this2.defaultEditorConfigurations.text;

					return new _FragmentEditableField2.default({
						content: editable.innerHTML,
						defaultLanguageId: _this2.defaultLanguageId,
						editableId: editable.id,
						editableValues: editableValues,
						element: editable,

						events: {
							editableChanged: _this2._handleEditableChanged,
							mapButtonClicked: _this2._handleMapButtonClick
						},

						fragmentEntryLinkId: _this2.fragmentEntryLinkId,
						languageId: _this2.languageId,
						portletNamespace: _this2.portletNamespace,

						processorsOptions: {
							defaultEditorConfiguration: defaultEditorConfiguration,
							imageSelectorURL: _this2.imageSelectorURL
						},

						showMapping: _this2.showMapping,
						type: editable.getAttribute('type')
					});
				});
			}
		}, {
			key: '_destroyEditables',
			value: function _destroyEditables() {
				if (this._editables) {
					this._editables.forEach(function (editable) {
						return editable.dispose();
					});

					this._editables = [];
				}
			}
		}, {
			key: '_emitMoveEvent',
			value: function _emitMoveEvent(direction) {
				this.emit('move', {
					direction: direction,
					fragmentEntryLinkId: this.fragmentEntryLinkId
				});
			}
		}, {
			key: '_handleEditableChanged',
			value: function _handleEditableChanged(event) {
				this.emit('editableChanged', {
					editableId: event.editableId,
					fragmentEntryLinkId: this.fragmentEntryLinkId,
					value: event.value
				});
			}
		}, {
			key: '_handleFragmentKeyUp',
			value: function _handleFragmentKeyUp(event) {
				if (document.activeElement === this.refs.fragmentEntryLinkWrapper) {
					switch (event.which) {
						case ARROW_DOWN_KEYCODE:
							this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.DOWN);
							break;
						case ARROW_UP_KEYCODE:
							this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.UP);
							break;
					}
				}
			}
		}, {
			key: '_handleFragmentMoveDownButtonClick',
			value: function _handleFragmentMoveDownButtonClick() {
				this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.DOWN);
			}
		}, {
			key: '_handleFragmentMoveUpButtonClick',
			value: function _handleFragmentMoveUpButtonClick() {
				this._emitMoveEvent(FragmentEntryLink.MOVE_DIRECTIONS.UP);
			}
		}, {
			key: '_handleFragmentRemoveButtonClick',
			value: function _handleFragmentRemoveButtonClick() {
				this.emit('remove', {
					fragmentEntryLinkId: this.fragmentEntryLinkId
				});
			}
		}, {
			key: '_handleMapButtonClick',
			value: function _handleMapButtonClick(event) {
				this.emit('mappeableFieldClicked', {
					editableId: event.editableId,
					editableType: event.editableType,
					fragmentEntryLinkId: this.fragmentEntryLinkId,
					mappedFieldId: event.mappedFieldId
				});
			}
		}, {
			key: '_renderContent',
			value: function _renderContent(content) {
				var _this3 = this;

				if (this.refs.content) {
					AUI().use('aui-parse-content', function (A) {
						var contentNode = A.one(_this3.refs.content);
						contentNode.plug(A.Plugin.ParseContent);
						contentNode.setContent(content);

						_this3._createEditables();

						_this3._update(_this3.languageId, _this3.defaultLanguageId, [_this3._updateEditableStatus]);
					});
				}
			}
		}, {
			key: '_update',
			value: function _update(languageId, defaultLanguageId, updateFunctions) {
				var editableValues = this.getEditableValues();

				Object.keys(editableValues).forEach(function (editableId) {
					var editableValue = editableValues[editableId];

					var defaultValue = editableValue[defaultLanguageId] || editableValue.defaultValue;
					var mappedField = editableValue.mappedField || '';
					var value = editableValue[languageId];

					updateFunctions.forEach(function (updateFunction) {
						return updateFunction(editableId, value, defaultValue, mappedField);
					});
				});
			}
		}, {
			key: '_updateEditableStatus',
			value: function _updateEditableStatus(editableId, value, defaultValue, mappedField) {
				var element = this.element.querySelector('lfr-editable[id="' + editableId + '"]');

				if (element) {
					(0, _dom.removeClasses)(element, 'mapped', 'translated', 'unmapped', 'untranslated');

					var mapped = !!mappedField;
					var translated = !mappedField && !!value;

					(0, _dom.addClasses)(element, mapped ? 'mapped' : 'unmapped');
					(0, _dom.addClasses)(element, translated ? 'translated' : 'untranslated');
				}
			}
		}]);

		return FragmentEntryLink;
	}(_component2.default);

	/**
  * Directions where a fragment can be moved to
  * @review
  * @static
  * @type {!object}
  */

	FragmentEntryLink.MOVE_DIRECTIONS = {
		DOWN: 1,
		UP: -1
	};

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentEntryLink.STATE = {

		/**
   * Fragment content to be rendered
   * @default ''
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {string}
   */

		content: _state.Config.any().setter(function (content) {
			return !(0, _metal.isFunction)(content) && (0, _metal.isObject)(content) ? content.value.content : content;
		}).value(''),

		/**
   * Default configurations for AlloyEditor instances.
   * @default {}
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {object}
   */

		defaultEditorConfigurations: _state.Config.object().value({}),

		/**
   * Default language id.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		defaultLanguageId: _state.Config.string().required(),

		/**
   * Editable values that should be used instead of the default ones
   * inside editable fields.
   * @default undefined
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {!Object}
   */

		editableValues: _state.Config.object().required(),

		/**
   * FragmentEntryLink id
   * @default undefined
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {!string}
   */

		fragmentEntryLinkId: _state.Config.string().required(),

		/**
   * Image selector url
   * @default undefined
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {!string}
   */

		imageSelectorURL: _state.Config.string().required(),

		/**
   * Currently selected language id.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		languageId: _state.Config.string().required(),

		/**
   * Fragment name
   * @default ''
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {string}
   */

		name: _state.Config.string().value(''),

		/**
   * Selected mapping type label
   * @default {}
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {{
   *   subtype: {
   *   	id: !string,
   *   	label: !string
   *   },
   *   type: {
   *   	id: !string,
   *   	label: !string
   *   }
   * }}
   */

		selectedMappingTypes: _state.Config.shapeOf({
			subtype: _state.Config.shapeOf({
				id: _state.Config.string().required(),
				label: _state.Config.string().required()
			}),
			type: _state.Config.shapeOf({
				id: _state.Config.string().required(),
				label: _state.Config.string().required()
			})
		}).value({}),

		/**
   * Shows FragmentEntryLink control toolbar
   * @default true
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {!bool}
   */

		showControlBar: _state.Config.bool().value(true),

		/**
   * If true, asset mapping is enabled
   * @default false
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {bool}
   */

		showMapping: _state.Config.bool().value(false),

		/**
   * Portlet namespace needed for prefixing Alloy Editor instances
   * @default undefined
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Fragment spritemap
   * @default undefined
   * @instance
   * @memberOf FragmentEntryLink
   * @review
   * @type {!string}
   */

		spritemap: _state.Config.string().required()
	};

	_Soy2.default.register(FragmentEntryLink, _FragmentEntryLink2.default);

	exports.FragmentEntryLink = FragmentEntryLink;
	exports.default = FragmentEntryLink;
});
//# sourceMappingURL=FragmentEntryLink.es.js.map
