Liferay.Loader.define("layout-admin-web@2.0.21/js/fragments_editor/fragment_entry_link/FragmentEntryLinkList.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-soy/src/Soy', './FragmentEntryLinkList.soy', './FragmentEntryLink.es'], function (exports, _component, _state, _Soy, _FragmentEntryLinkList) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentEntryLinkList = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentEntryLinkList2 = _interopRequireDefault(_FragmentEntryLinkList);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var FragmentEntryLinkList = function (_Component) {
		_inherits(FragmentEntryLinkList, _Component);

		function FragmentEntryLinkList() {
			_classCallCheck(this, FragmentEntryLinkList);

			return _possibleConstructorReturn(this, (FragmentEntryLinkList.__proto__ || Object.getPrototypeOf(FragmentEntryLinkList)).apply(this, arguments));
		}

		_createClass(FragmentEntryLinkList, [{
			key: 'focusFragmentEntryLink',
			value: function focusFragmentEntryLink(fragmentEntryLinkId) {
				var _this2 = this;

				requestAnimationFrame(function () {
					var index = _this2.fragmentEntryLinks.indexOf(_this2.fragmentEntryLinks.find(function (fragmentEntryLink) {
						return fragmentEntryLink.fragmentEntryLinkId === fragmentEntryLinkId;
					}));

					var fragmentEntryLinkElement = _this2.refs.fragmentEntryLinks.querySelectorAll('.fragment-entry-link-wrapper')[index];

					if (fragmentEntryLinkElement) {
						fragmentEntryLinkElement.focus();
						fragmentEntryLinkElement.scrollIntoView();
					}
				});
			}
		}, {
			key: '_handleEditableChanged',
			value: function _handleEditableChanged(event) {
				this.emit('editableChanged', event);
			}
		}, {
			key: '_handleFragmentMove',
			value: function _handleFragmentMove(event) {
				this.emit('move', event);
			}
		}, {
			key: '_handleFragmentRemove',
			value: function _handleFragmentRemove(event) {
				this.emit('remove', event);
			}
		}, {
			key: '_handleMappeableFieldClicked',
			value: function _handleMappeableFieldClicked(event) {
				this.emit('mappeableFieldClicked', event);
			}
		}]);

		return FragmentEntryLinkList;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentEntryLinkList.STATE = {

		/**
   * List of fragment instances being used, the order
   * of the elements in this array defines their position.
   * @default []
   * @instance
   * @memberOf FragmentEntryLinkList
   * @review
   * @type {Array<{
   *   config: Object,
   *   content: string,
   *   editableValues: Object,
   *   fragmentEntryId: !string,
   *   fragmentEntryLinkId: !string,
   *   name: !string,
   *   position: !number
   * }>}
   */

		fragmentEntryLinks: _state.Config.arrayOf(_state.Config.shapeOf({
			config: _state.Config.object().value({}),
			content: _state.Config.any().value(''),
			editableValues: _state.Config.object().value({}),
			fragmentEntryId: _state.Config.string().required(),
			fragmentEntryLinkId: _state.Config.string().required(),
			name: _state.Config.string().required(),
			position: _state.Config.number().required()
		})).value([])
	};

	_Soy2.default.register(FragmentEntryLinkList, _FragmentEntryLinkList2.default);

	exports.FragmentEntryLinkList = FragmentEntryLinkList;
	exports.default = FragmentEntryLinkList;
});
//# sourceMappingURL=FragmentEntryLinkList.es.js.map
