Liferay.Loader.define("layout-admin-web@2.0.21/js/fragments_editor/fragment_processors/EditableImageFragmentProcessor.es", ['exports'], function (exports) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	/**
  * Possible types that can be returned by the image selector
  */

	var RETURN_TYPES = {
		fileEntryItemSelector: 'com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType',
		url: 'URL'
	};

	/**
  * Handle item selector image changes and propagate them with an
  * "editableChanged" event.
  * @param {Event} changeEvent
  * @param {HTMLElement} editableElement
  * @param {string} fragmentEntryLinkId
  * @param {function} changedCallback
  * @private
  */

	function _handleImageEditorChange(changeEvent, editableElement, fragmentEntryLinkId, changedCallback) {
		var imageElement = editableElement.querySelector('img');
		var selectedItem = changeEvent.newVal;

		if (imageElement && selectedItem) {
			var returnType = selectedItem.returnType;
			var url = '';

			if (returnType === RETURN_TYPES.url) {
				url = selectedItem.value;
			} else if (returnType === RETURN_TYPES.fileEntryItemSelector) {
				url = JSON.parse(selectedItem.value).url;
			}

			imageElement.src = url;

			changedCallback(url);
		}
	}

	/**
  * Do nothing, as LiferayItemSelectorDialog is automatically
  * destroyed on hide.
  * @review
  */

	function destroy() {}

	/**
  * Show the image selector dialog and calls the given callback when an
  * image is selected.
  * @param {HTMLElement} editableElement
  * @param {string} fragmentEntryLinkId
  * @param {string} portletNamespace
  * @param {{imageSelectorURL: string}} options
  * @param {function} changedCallback
  * @param {function} destroyedCallback
  * @review
  */

	function init(editableElement, fragmentEntryLinkId, portletNamespace, options, changedCallback, destroyedCallback) {
		var eventName = portletNamespace + 'selectImage';
		var title = Liferay.Language.get('select');
		var imageSelectorURL = options.imageSelectorURL;


		AUI().use('liferay-item-selector-dialog', function (A) {
			var itemSelectorDialog = new A.LiferayItemSelectorDialog({
				eventName: eventName,
				on: {
					selectedItemChange: function selectedItemChange(changeEvent) {
						_handleImageEditorChange(changeEvent, editableElement, fragmentEntryLinkId, changedCallback);
					},

					visibleChange: function visibleChange(change) {
						if (change.newVal === false) {
							destroyedCallback();
						}
					}
				},
				title: title,
				url: imageSelectorURL
			});

			itemSelectorDialog.open();
		});
	}

	exports.destroy = destroy;
	exports.init = init;
	exports.default = {
		destroy: destroy,
		init: init
	};
});
//# sourceMappingURL=EditableImageFragmentProcessor.es.js.map
