Liferay.Loader.define("layout-admin-web@2.0.21/js/miller_columns/Layout.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-soy/src/Soy', './Layout.soy', './LayoutBreadcrumbs.es', './LayoutColumn.es'], function (exports, _component, _state, _Soy, _Layout) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Layout = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _Layout2 = _interopRequireDefault(_Layout);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var Layout = function (_Component) {
		_inherits(Layout, _Component);

		function Layout() {
			_classCallCheck(this, Layout);

			return _possibleConstructorReturn(this, (Layout.__proto__ || Object.getPrototypeOf(Layout)).apply(this, arguments));
		}

		_createClass(Layout, [{
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				var A = new AUI();

				A.use('liferay-search-container', 'liferay-search-container-select', function (A) {
					var plugins = [];

					plugins.push({
						cfg: {
							rowSelector: '.layout-column'
						},
						fn: A.Plugin.SearchContainerSelect
					});

					var searchContainer = new Liferay.SearchContainer({
						contentBox: A.one(_this2.refs.layout),
						id: _this2.getInitialConfig().portletNamespace + _this2.getInitialConfig().searchContainerId,
						plugins: plugins
					});

					_this2.searchContainer_ = searchContainer;
				});
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				var _this3 = this;

				requestAnimationFrame(function () {
					_this3.refs.layoutColumns.scrollLeft = _this3.refs.layoutColumns.scrollWidth;
				});
			}
		}]);

		return Layout;
	}(_component2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	Layout.STATE = {

		/**
   * Breadcrumb Entries
   * @instance
   * @memberof Layout
   * @type {!Array}
   */

		breadcrumbEntries: _state.Config.arrayOf(_state.Config.shapeOf({
			title: _state.Config.string().required(),
			url: _state.Config.string().required()
		})).required(),

		/**
   * Layout blocks
   * @instance
   * @memberof Layout
   * @type {!Array}
   */

		layoutColumns: _state.Config.arrayOf(_state.Config.arrayOf(_state.Config.shapeOf({
			actionURLs: _state.Config.object().required(),
			active: _state.Config.bool().required(),
			hasChild: _state.Config.bool().required(),
			homePage: _state.Config.bool().required(),
			homePageTitle: _state.Config.string().required(),
			plid: _state.Config.string().required(),
			title: _state.Config.string().required(),
			url: _state.Config.string().required()
		}))).required(),

		/**
   * URL for using icons
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		pathThemeImages: _state.Config.string().required(),

		/**
   * Namespace of portlet to prefix parameters names
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Site navigation menu names, to add layouts by default
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		siteNavigationMenuNames: _state.Config.string().required()

	};

	_Soy2.default.register(Layout, _Layout2.default);

	exports.Layout = Layout;
	exports.default = Layout;
});
//# sourceMappingURL=Layout.es.js.map
