Liferay.Loader.define("layout-admin-web@2.0.21/js/miller_columns/LayoutColumn.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-soy/src/Soy', 'frontend-js-web/liferay/modal/commands/OpenSimpleInputModal.es', './LayoutColumn.soy'], function (exports, _component, _state, _Soy, _OpenSimpleInputModal, _LayoutColumn) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.LayoutColumn = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _OpenSimpleInputModal2 = _interopRequireDefault(_OpenSimpleInputModal);

	var _LayoutColumn2 = _interopRequireDefault(_LayoutColumn);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var LayoutColumn = function (_Component) {
		_inherits(LayoutColumn, _Component);

		function LayoutColumn() {
			_classCallCheck(this, LayoutColumn);

			return _possibleConstructorReturn(this, (LayoutColumn.__proto__ || Object.getPrototypeOf(LayoutColumn)).apply(this, arguments));
		}

		_createClass(LayoutColumn, [{
			key: '_handleCopyLayoutClick',
			value: function _handleCopyLayoutClick(event) {
				event.preventDefault();

				var config = {
					dialogTitle: Liferay.Language.get('copy-page'),
					formSubmitURL: event.delegateTarget.href,
					mainFieldLabel: Liferay.Language.get('name'),
					mainFieldName: 'name',
					namespace: this.portletNamespace,
					spritemap: this.pathThemeImages + '/lexicon/icons.svg'
				};

				if (this.siteNavigationMenuNames !== '') {
					config.checkboxFieldLabel = _.sub(Liferay.Language.get('add-this-page-to-the-following-menus-x'), this.siteNavigationMenuNames);
					config.checkboxFieldName = 'TypeSettingsProperties--addToAutoMenus--';
					config.checkboxFieldValue = true;
				}

				new _OpenSimpleInputModal2.default(config);
			}
		}, {
			key: '_handleMarkAsHomePageLayoutClick',
			value: function _handleMarkAsHomePageLayoutClick(event) {
				var confirmMessage = _.sub(Liferay.Language.get('do-you-want-to-replace-x-for-x-as-the-home-page'), event.delegateTarget.dataset.homePageTitle, event.delegateTarget.dataset.title);

				if (!confirm(confirmMessage)) {
					event.preventDefault();
				}
			}
		}, {
			key: '_handlePermissionLinkClick',
			value: function _handlePermissionLinkClick(event) {
				Liferay.Util.openInDialog(event, {
					dialog: {
						destroyOnHide: true
					},
					dialogIframe: {
						bodyCssClass: 'dialog-with-footer'
					},
					uri: event.delegateTarget.href
				});
			}
		}, {
			key: '_handleDeleteItemClick',
			value: function _handleDeleteItemClick(event) {
				if (!confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'))) {
					event.preventDefault();
				}
			}
		}]);

		return LayoutColumn;
	}(_component2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	LayoutColumn.STATE = {

		/**
   * List of layouts in the current column
   * @default undefined
   * @instance
   * @memberof LayoutColumn
   * @type {!Array}
   */

		layoutColumn: _state.Config.arrayOf(_state.Config.shapeOf({
			actionURLs: _state.Config.object().required(),
			active: _state.Config.bool().required(),
			description: _state.Config.string().required(),
			hasChild: _state.Config.bool().required(),
			homePage: _state.Config.bool().required(),
			homePageTitle: _state.Config.string().required(),
			plid: _state.Config.string().required(),
			title: _state.Config.string().required(),
			url: _state.Config.string().required()
		})).required(),

		/**
   * URL for using icons
   * @default undefined
   * @instance
   * @memberof LayoutColumn
   * @type {!string}
   */

		pathThemeImages: _state.Config.string().required(),

		/**
   * Namespace of portlet to prefix parameters names
   * @default undefined
   * @instance
   * @memberof LayoutColumn
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Site navigation menu names, to add layouts by default
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		siteNavigationMenuNames: _state.Config.string().required()

	};

	_Soy2.default.register(LayoutColumn, _LayoutColumn2.default);

	exports.LayoutColumn = LayoutColumn;
	exports.default = LayoutColumn;
});
//# sourceMappingURL=LayoutColumn.es.js.map
