Liferay.Loader.define("layout-admin-web@3.0.93/js/modal/DisplayPageModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/modal', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './DisplayPageModalForm.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.DisplayPageModal = void 0;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _DisplayPageModalForm = _interopRequireDefault(require("./DisplayPageModalForm.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var DisplayPageModal = function DisplayPageModal(props) {
    var formSubmitURL = props.formSubmitURL,
        onClose = props.onClose;
    var form = (0, _react.useRef)();

    var _useState = (0, _react.useState)(null),
        _useState2 = _slicedToArray(_useState, 2),
        error = _useState2[0],
        setError = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        loading = _useState4[0],
        setLoading = _useState4[1];

    var _useModal = (0, _modal.useModal)({
      onClose: onClose
    }),
        observer = _useModal.observer;

    var validateForm = (0, _react.useCallback)(function (form) {
      var elements = form.elements;
      var error = {};
      var errorMessage = Liferay.Language.get('this-field-is-required');
      var nameField = elements["".concat(props.namespace, "name")];

      if (!nameField.value) {
        error.name = errorMessage;
      }

      var classNameIdField = elements["".concat(props.namespace, "classNameId")];

      if (classNameIdField.selectedIndex === 0) {
        error.classNameId = errorMessage;
      }

      var classTypeIdField = elements["".concat(props.namespace, "classTypeId")];

      if (classTypeIdField && classTypeIdField.selectedIndex === 0) {
        error.classTypeId = errorMessage;
      }

      return error;
    }, [props.namespace]);
    var handleSubmit = (0, _react.useCallback)(function (event) {
      event.preventDefault();
      var error = validateForm(form.current);

      if (Object.keys(error).length !== 0) {
        setError(error);
        return;
      }

      setLoading(true);
      (0, _frontendJsWeb.fetch)(formSubmitURL, {
        body: new FormData(form.current),
        method: 'POST'
      }).then(function (response) {
        return response.json();
      }).then(function (responseContent) {
        if (responseContent.error) {
          setLoading(false);
          setError(responseContent.error);
        } else if (responseContent.redirectURL) {
          (0, _frontendJsWeb.navigate)(responseContent.redirectURL, {
            beforeScreenFlip: onClose
          });
        }
      })["catch"](function () {
        return setError({
          other: Liferay.Language.get('an-unexpected-error-occurred-while-creating-the-display-page')
        });
      });
    }, [formSubmitURL, onClose, validateForm]);
    var visible = observer.mutation;
    return _react["default"].createElement(_modal["default"], {
      observer: observer,
      size: "md"
    }, _react["default"].createElement(_modal["default"].Header, null, props.title), _react["default"].createElement(_modal["default"].Body, null, error && error.other && _react["default"].createElement(_alert["default"], {
      displayType: "danger",
      onClose: function onClose() {},
      title: Liferay.Language.get('error')
    }, error.other), visible && _react["default"].createElement(_DisplayPageModalForm["default"], {
      displayPageName: props.displayPageName,
      error: error,
      mappingTypes: props.mappingTypes,
      namespace: props.namespace,
      onSubmit: handleSubmit,
      ref: form
    })), _react["default"].createElement(_modal["default"].Footer, {
      last: _react["default"].createElement(_button["default"].Group, {
        spaced: true
      }, _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: onClose
      }, Liferay.Language.get('cancel')), _react["default"].createElement(_button["default"], {
        displayType: "primary",
        onClick: handleSubmit
      }, loading && _react["default"].createElement("span", {
        className: "inline-item inline-item-before"
      }, _react["default"].createElement("span", {
        "aria-hidden": "true",
        className: "loading-animation"
      })), Liferay.Language.get('save')))
    }));
  };

  exports.DisplayPageModal = DisplayPageModal;
  var _default = DisplayPageModal;
  exports["default"] = _default;
  //# sourceMappingURL=DisplayPageModal.es.js.map
});
//# sourceMappingURL=DisplayPageModal.es.js.map