/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.util.FragmentEntryRenderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.batch.BatchIndexingHelper;
import com.liferay.staging.StagingGroupHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class LayoutIndexer
extends BaseIndexer<Layout> {
    public static final String CLASS_NAME = Layout.class.getName();
    private static final String[] _ESCAPE_SAFE_HIGHLIGHTS = new String[]{"[@HIGHLIGHT1@]", "[@HIGHLIGHT2@]"};
    private static final String[] _HIGHLIGHT_TAGS = new String[]{"<liferay-hl>", "</liferay-hl>"};
    private static final Log _log = LogFactoryUtil.getLog(LayoutIndexer.class);
    @Reference
    private BatchIndexingHelper _batchIndexingHelper;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    public LayoutIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "defaultLanguageId", "groupId", "modified", "scopeGroupId", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        this.setSelectAllLocales(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(entryClassPK);
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (boolean)true, (String)"VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Object[] types = GetterUtil.getStringValues((Object)searchContext.getAttribute("type"), (String[])new String[]{"content"});
        if (ArrayUtil.isNotEmpty((Object[])types)) {
            TermsFilter typeTermsFilter = new TermsFilter("type");
            typeTermsFilter.addValues((String[])types);
            contextBooleanFilter.add((Filter)typeTermsFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
    }

    protected void doDelete(Layout layout) throws Exception {
        this.deleteDocument(layout.getCompanyId(), layout.getPlid());
    }

    protected Document doGetDocument(Layout layout) throws Exception {
        String[] languageIds;
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)layout);
        document.addUID(CLASS_NAME, layout.getPlid());
        document.addText("defaultLanguageId", layout.getDefaultLanguageId());
        document.addLocalizedText("name", layout.getNameMap());
        document.addText("privateLayout", String.valueOf(layout.isPrivateLayout()));
        document.addText("type", layout.getType());
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid());
        for (String languageId : layout.getAvailableLanguageIds()) {
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), layout.getName(LocaleUtil.fromLanguageId((String)languageId)));
        }
        if (fragmentEntryLinks == null || fragmentEntryLinks.isEmpty()) {
            return document;
        }
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && serviceContext.getRequest() != null) {
            request = serviceContext.getRequest();
            response = serviceContext.getResponse();
        }
        for (String languageId : languageIds = LocaleUtil.toLanguageIds((Collection)LanguageUtil.getAvailableLocales((long)layout.getGroupId()))) {
            String content = "";
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            if (request == null || response == null) {
                content = this._getStagedContent(layout, locale);
            } else {
                StringBundler sb = new StringBundler(fragmentEntryLinks.size());
                for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                    sb.append(FragmentEntryRenderUtil.renderFragmentEntryLink((FragmentEntryLink)fragmentEntryLink, (String)"VIEW", new HashMap(), (HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale));
                }
                content = sb.toString();
            }
            if (Validator.isNull((String)content)) continue;
            document.addText(LocalizationUtil.getLocalizedName((String)"content", (String)languageId), content);
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)document.get("defaultLanguageId"));
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)"name");
        if (Validator.isNull((Object)document.getField(localizedFieldName))) {
            locale = defaultLocale;
        }
        String name = document.get(locale, "snippet_title", "title");
        String content = document.get(locale, "content");
        content = StringUtil.replace((String)content, (String[])_HIGHLIGHT_TAGS, (String[])_ESCAPE_SAFE_HIGHLIGHTS);
        content = HtmlUtil.extractText((String)content);
        content = StringUtil.replace((String)content, (String[])_ESCAPE_SAFE_HIGHLIGHTS, (String[])_HIGHLIGHT_TAGS);
        snippet = document.get(locale, "snippet_content");
        HashSet highlights = new HashSet();
        HighlightUtil.addSnippet((Document)document, highlights, (String)snippet, (String)"temp");
        content = HighlightUtil.highlight((String)content, (String[])ArrayUtil.toStringArray(highlights), (String)"<liferay-hl>", (String)"</liferay-hl>");
        Summary summary = new Summary(locale, name, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(Layout layout) throws Exception {
        Document document = this.getDocument(layout);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), layout.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(classPK);
        this.doReindex(layout);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexLayouts(companyId);
    }

    private String _getStagedContent(Layout layout, Locale locale) throws PortalException {
        Group group = this._groupLocalService.getGroup(layout.getGroupId());
        Group stagingGroup = null;
        stagingGroup = ExportImportThreadLocal.isInitialLayoutStagingInProcess() ? this._stagingGroupHelper.fetchLiveGroup(group) : (!group.isStaged() || group.isStagingGroup() ? group : group.getStagingGroup());
        Layout stagingLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getUuid(), stagingGroup.getGroupId(), layout.isPrivateLayout());
        SearchContext searchContext = new SearchContext();
        BooleanClause booleanClause = BooleanClauseFactoryUtil.create((String)"entryClassPK", (String)String.valueOf(stagingLayout.getPlid()), (String)BooleanClauseOccur.MUST.getName());
        searchContext.setBooleanClauses(new BooleanClause[]{booleanClause});
        if (CompanyThreadLocal.getCompanyId() == 0L || ExportImportThreadLocal.isStagingInProcess()) {
            searchContext.setCompanyId(stagingLayout.getCompanyId());
        }
        searchContext.setGroupIds(new long[]{stagingGroup.getGroupId()});
        searchContext.setEntryClassNames(new String[]{Layout.class.getName()});
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(searchContext);
        Document[] documents = hits.getDocs();
        if (documents.length != 1) {
            return "";
        }
        Document document = documents[0];
        return document.get(Field.getLocalizedName((Locale)locale, (String)"content"));
    }

    private void _reindexLayouts(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._layoutLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setInterval(this._batchIndexingHelper.getBulkSize(Layout.class.getName()));
        indexableActionableDynamicQuery.setPerformActionMethod(layout -> {
            block2: {
                try {
                    Document document = this.getDocument(layout);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index layout " + layout.getPlid()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

