/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search.spi.model.index.contributor;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.layout.internal.search.util.LayoutPageTemplateStructureRenderUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.staging.StagingGroupHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Layout"}, service={ModelDocumentContributor.class})
public class LayoutModelDocumentContributor
implements ModelDocumentContributor<Layout> {
    public static final String CLASS_NAME = Layout.class.getName();
    @Reference
    private FragmentRendererController _fragmentRendererController;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    public void contribute(Document document, Layout layout) {
        if (layout.isSystem() || layout.getStatus() != 0) {
            return;
        }
        document.addText("defaultLanguageId", layout.getDefaultLanguageId());
        document.addLocalizedText("name", layout.getNameMap());
        document.addText("privateLayout", String.valueOf(layout.isPrivateLayout()));
        document.addText("type", layout.getType());
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid());
        for (String languageId : layout.getAvailableLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            document.addText(Field.getLocalizedName((Locale)locale, (String)"title"), layout.getName(locale));
        }
        if (layoutPageTemplateStructure == null) {
            return;
        }
        HttpServletRequest httpServletRequest = null;
        HttpServletResponse httpServletResponse = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && serviceContext.getRequest() != null) {
            httpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)serviceContext.getRequest(), (String)("p_l_id=" + layout.getPlid()), (boolean)false);
            httpServletResponse = serviceContext.getResponse();
        }
        long[] segmentsExperienceIds = new long[]{0L};
        Set locales = LanguageUtil.getAvailableLocales((long)layout.getGroupId());
        for (Locale locale : locales) {
            try {
                String content = "";
                content = httpServletRequest == null || httpServletResponse == null ? this._getStagedContent(layout, locale) : LayoutPageTemplateStructureRenderUtil.renderLayoutContent(this._fragmentRendererController, httpServletRequest, httpServletResponse, layoutPageTemplateStructure, "VIEW", new HashMap<String, Object>(), locale, segmentsExperienceIds);
                if (Validator.isNull((String)content)) continue;
                document.addText(Field.getLocalizedName((Locale)locale, (String)"content"), content);
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
        }
    }

    private String _getStagedContent(Layout layout, Locale locale) throws PortalException {
        Group group = this._groupLocalService.getGroup(layout.getGroupId());
        Group stagingGroup = null;
        stagingGroup = ExportImportThreadLocal.isInitialLayoutStagingInProcess() ? this._stagingGroupHelper.fetchLiveGroup(group) : (!group.isStaged() || group.isStagingGroup() ? group : group.getStagingGroup());
        Layout stagingLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getUuid(), stagingGroup.getGroupId(), layout.isPrivateLayout());
        SearchContext searchContext = new SearchContext();
        BooleanClause booleanClause = BooleanClauseFactoryUtil.create((String)"entryClassPK", (String)String.valueOf(stagingLayout.getPlid()), (String)BooleanClauseOccur.MUST.getName());
        searchContext.setBooleanClauses(new BooleanClause[]{booleanClause});
        searchContext.setCompanyId(stagingGroup.getCompanyId());
        searchContext.setGroupIds(new long[]{stagingGroup.getGroupId()});
        searchContext.setEntryClassNames(new String[]{Layout.class.getName()});
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(searchContext);
        Document[] documents = hits.getDocs();
        if (documents.length != 1) {
            return "";
        }
        Document document = documents[0];
        return document.get(Field.getLocalizedName((Locale)locale, (String)"content"));
    }
}

