/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.crawler;

import com.liferay.layout.crawler.LayoutCrawler;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutCrawler.class})
public class LayoutCrawlerImpl
implements LayoutCrawler {
    private static final String _USER_AGENT = "Liferay Page Crawler";
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Portal _portal;

    public String getLayoutContent(Layout layout, Locale locale) throws Exception {
        InetAddress inetAddress = this._portal.getPortalServerInetAddress(this._isHttpsEnabled());
        if (inetAddress == null) {
            return "";
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = httpClientBuilder.setUserAgent(_USER_AGENT).build();
        ThemeDisplay themeDisplay = new ThemeDisplay();
        Company company = this._companyLocalService.getCompany(layout.getCompanyId());
        themeDisplay.setCompany(company);
        themeDisplay.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        themeDisplay.setLayout(layout);
        themeDisplay.setLayoutSet(layout.getLayoutSet());
        themeDisplay.setLocale(locale);
        themeDisplay.setScopeGroupId(layout.getGroupId());
        themeDisplay.setServerName(inetAddress.getHostName());
        themeDisplay.setServerPort(this._portal.getPortalServerPort(this._isHttpsEnabled()));
        themeDisplay.setSiteGroupId(layout.getGroupId());
        HttpGet httpGet = new HttpGet(this._portal.getLayoutFullURL(layout, themeDisplay));
        httpGet.setHeader("Host", company.getVirtualHostname());
        HttpClientContext httpClientContext = new HttpClientContext();
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicClientCookie basicClientCookie = new BasicClientCookie("GUEST_LANGUAGE_ID", LocaleUtil.toLanguageId((Locale)locale));
        basicClientCookie.setDomain(inetAddress.getHostName());
        cookieStore.addCookie((Cookie)basicClientCookie);
        httpClientContext.setCookieStore((CookieStore)cookieStore);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpClientContext);
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() == 200) {
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        return "";
    }

    private boolean _isHttpsEnabled() {
        return Objects.equals("https", PropsUtil.get((String)"portal.instance.protocol")) || Objects.equals("https", PropsUtil.get((String)"web.server.protocol"));
    }
}

