/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search.spi.model.result.contributor;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.HashSet;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Layout"}, service={ModelSummaryContributor.class})
public class LayoutModelSummaryContributor
implements ModelSummaryContributor {
    private static final String[] _ESCAPE_SAFE_HIGHLIGHTS = new String[]{"[@HIGHLIGHT1@]", "[@HIGHLIGHT2@]"};
    private static final String[] _HIGHLIGHT_TAGS = new String[]{"<liferay-hl>", "</liferay-hl>"};
    @Reference
    private Html _html;

    public Summary getSummary(Document document, Locale locale, String snippet) {
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)"name");
        if (Validator.isNull((Object)document.getField(localizedFieldName))) {
            locale = LocaleUtil.fromLanguageId((String)document.get("defaultLanguageId"));
        }
        String name = document.get(locale, "snippet_title", "title");
        String content = document.get(locale, "content");
        content = StringUtil.replace((String)content, (String[])_HIGHLIGHT_TAGS, (String[])_ESCAPE_SAFE_HIGHLIGHTS);
        content = this._html.extractText(content);
        content = StringUtil.replace((String)content, (String[])_ESCAPE_SAFE_HIGHLIGHTS, (String[])_HIGHLIGHT_TAGS);
        snippet = document.get(locale, "snippet_content");
        HashSet highlights = new HashSet();
        HighlightUtil.addSnippet((Document)document, highlights, (String)snippet, (String)"temp");
        content = HighlightUtil.highlight((String)content, (String[])ArrayUtil.toStringArray(highlights), (String)"<liferay-hl>", (String)"</liferay-hl>");
        Summary summary = new Summary(locale, name, content);
        summary.setMaxContentLength(200);
        return summary;
    }
}

