/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.layout.admin.kernel.util.Sitemap;
import com.liferay.layout.admin.kernel.util.SitemapURLProvider;
import com.liferay.layout.admin.kernel.util.SitemapURLProviderRegistryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PropsValues;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Sitemap.class})
public class SitemapImpl
implements Sitemap {
    private static final byte[] _ATTRIBUTE_XHTML = " xmlns:xhtml=\"http://www.w3.org/1999/xhtml\"".getBytes();
    private static final byte[] _ATTRIBUTE_XMLNS = " xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"".getBytes();
    private static final int _MAXIMUM_SIZE = 0x3200000;
    private static final Log _log = LogFactoryUtil.getLog((String)SitemapImpl.class.getName());
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SAXReader _saxReader;

    public void addURLElement(Element element, String url, UnicodeProperties typeSettingsUnicodeProperties, Date modifiedDate, String canonicalURL, Map<Locale, String> alternateURLs) {
        Element urlElement = element.addElement("url");
        Element locElement = urlElement.addElement("loc");
        locElement.addText(this.encodeXML(url));
        if (modifiedDate != null) {
            Element modifiedDateElement = urlElement.addElement("lastmod");
            DateFormat dateFormat = DateUtil.getISO8601Format();
            modifiedDateElement.addText(dateFormat.format(modifiedDate));
        }
        if (typeSettingsUnicodeProperties == null) {
            if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY)) {
                Element changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY);
            }
            if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY)) {
                Element priorityElement = urlElement.addElement("priority");
                priorityElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY);
            }
        } else {
            Element priorityElement;
            String changefreq = typeSettingsUnicodeProperties.getProperty("sitemap-changefreq");
            if (Validator.isNotNull((String)changefreq)) {
                Element element2 = urlElement.addElement("changefreq");
                element2.addText(changefreq);
            } else if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY)) {
                Element element3 = urlElement.addElement("changefreq");
                element3.addText(PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY);
            }
            String string = typeSettingsUnicodeProperties.getProperty("sitemap-priority");
            if (Validator.isNotNull((String)string)) {
                priorityElement = urlElement.addElement("priority");
                priorityElement.addText(string);
            } else if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY)) {
                priorityElement = urlElement.addElement("priority");
                priorityElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY);
            }
        }
        if (alternateURLs != null) {
            for (Map.Entry entry : alternateURLs.entrySet()) {
                Locale locale = (Locale)entry.getKey();
                String href = (String)entry.getValue();
                Element alternateURLElement = urlElement.addElement("xhtml:link", "http://www.w3.org/1999/xhtml");
                alternateURLElement.addAttribute("href", href);
                alternateURLElement.addAttribute("hreflang", LocaleUtil.toW3cLanguageId((Locale)locale));
                alternateURLElement.addAttribute("rel", "alternate");
            }
            Element alternateURLElement = urlElement.addElement("xhtml:link", "http://www.w3.org/1999/xhtml");
            alternateURLElement.addAttribute("rel", "alternate");
            alternateURLElement.addAttribute("hreflang", "x-default");
            alternateURLElement.addAttribute("href", canonicalURL);
        }
        this._removeOldestElement(element, urlElement);
    }

    public String encodeXML(String input) {
        return StringUtil.replace((String)input, (char[])new char[]{'&', '<', '>', '\'', '\"'}, (String[])new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"});
    }

    public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        return this._portal.getAlternateURLs(canonicalURL, themeDisplay, layout);
    }

    public String getSitemap(long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getSitemap(null, groupId, privateLayout, themeDisplay);
    }

    public String getSitemap(String layoutUuid, long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException {
        if (Validator.isNull((String)layoutUuid) && PropsValues.XML_SITEMAP_INDEX_ENABLED) {
            return this._getIndexSitemap(groupId, privateLayout, themeDisplay);
        }
        return this._getSitemap(layoutUuid, groupId, privateLayout, themeDisplay);
    }

    protected void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        if (layoutSet.isPrivateLayout()) {
            return;
        }
        String portalURL = themeDisplay.getPortalURL();
        Map layoutTypeControllers = LayoutTypeControllerTracker.getLayoutTypeControllers();
        for (Map.Entry entry : layoutTypeControllers.entrySet()) {
            LayoutTypeController layoutTypeController = (LayoutTypeController)entry.getValue();
            if (!layoutTypeController.isSitemapable()) continue;
            List layouts = this._layoutLocalService.getAllLayouts(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), (String)entry.getKey());
            for (Layout layout : layouts) {
                UnicodeProperties typeSettingsUnicodeProperties;
                boolean sitemapInclude;
                if (layout.isSystem() && !layout.isTypeAssetDisplay() || !(sitemapInclude = GetterUtil.getBoolean((String)(typeSettingsUnicodeProperties = layout.getTypeSettingsProperties()).getProperty("sitemap-include"), (boolean)true))) continue;
                Element sitemapElement = element.addElement("sitemap");
                Element locationElement = sitemapElement.addElement("loc");
                locationElement.addText(StringBundler.concat((Object[])new Object[]{portalURL, this._portal.getPathContext(), "/sitemap.xml?p_l_id=", layout.getPlid(), "&layoutUuid=", layout.getUuid(), "&groupId=", layoutSet.getGroupId(), "&privateLayout=", layout.isPrivateLayout()}));
                this._removeOldestElement(element, sitemapElement);
            }
        }
    }

    private String _getIndexSitemap(long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException {
        Document document = this._saxReader.createDocument();
        document.setXMLEncoding("UTF-8");
        Element rootElement = document.addElement("sitemapindex", "http://www.sitemaps.org/schemas/sitemap/0.9");
        rootElement.addAttribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        this._initEntriesAndSize(rootElement);
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        this.visitLayoutSet(rootElement, layoutSet, themeDisplay);
        this._removeEntriesAndSize(rootElement);
        return document.asXML();
    }

    private String _getSitemap(String layoutUuid, long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException {
        Document document = this._saxReader.createDocument();
        document.setXMLEncoding("UTF-8");
        Element rootElement = document.addElement("urlset", "http://www.sitemaps.org/schemas/sitemap/0.9");
        rootElement.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.addAttribute("xsi:schemaLocation", "http://www.w3.org/1999/xhtml http://www.w3.org/2002/08/xhtml/xhtml1-strict.xsd");
        rootElement.addAttribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        this._initEntriesAndSize(rootElement);
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        List sitemapURLProviders = SitemapURLProviderRegistryUtil.getSitemapURLProviders();
        for (SitemapURLProvider sitemapURLProvider : sitemapURLProviders) {
            if (Validator.isNull((String)layoutUuid)) {
                sitemapURLProvider.visitLayoutSet(rootElement, layoutSet, themeDisplay);
                continue;
            }
            sitemapURLProvider.visitLayout(rootElement, layoutUuid, layoutSet, themeDisplay);
        }
        if (!rootElement.hasContent()) {
            return "";
        }
        this._removeEntriesAndSize(rootElement);
        return document.asXML();
    }

    private int _getSize(Element element) {
        String string = element.asXML();
        byte[] bytes = string.getBytes();
        int offset = 0;
        String name = element.getName();
        if (name.equals("url")) {
            Set availableLocales = LanguageUtil.getAvailableLocales();
            int availableLocalesSize = availableLocales.size();
            offset = (availableLocalesSize + 1) * _ATTRIBUTE_XHTML.length;
            offset += _ATTRIBUTE_XMLNS.length;
        }
        return bytes.length - offset;
    }

    private void _initEntriesAndSize(Element rootElement) {
        rootElement.addAttribute("entries", "0");
        int size = this._getSize(rootElement);
        rootElement.addAttribute("size", String.valueOf(size));
    }

    private void _removeEntriesAndSize(Element rootElement) {
        Attribute entriesAttribute = rootElement.attribute("entries");
        Attribute sizeAttribute = rootElement.attribute("size");
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(4);
            sb.append("Created site map with ");
            if (entriesAttribute != null) {
                sb.append(entriesAttribute.getValue());
            } else {
                sb.append("no");
            }
            sb.append(" entries and size ");
            if (sizeAttribute != null) {
                int size = GetterUtil.getInteger((String)sizeAttribute.getValue());
                sb.append(TextFormatter.formatStorageSize((int)size, (Locale)LocaleUtil.fromLanguageId((String)"en_US")));
            } else {
                sb.append("0");
            }
            _log.debug((Object)sb.toString());
        }
        if (entriesAttribute != null) {
            rootElement.remove(entriesAttribute);
        }
        if (sizeAttribute != null) {
            rootElement.remove(sizeAttribute);
        }
    }

    private void _removeOldestElement(Element rootElement, Element newElement) {
        int entries = GetterUtil.getInteger((String)rootElement.attributeValue("entries"));
        int size = GetterUtil.getInteger((String)rootElement.attributeValue("size"));
        ++entries;
        size += this._getSize(newElement);
        while (entries > 50000 || size >= 0x3200000) {
            Element oldestUrlElement = rootElement.element(newElement.getName());
            --entries;
            size -= this._getSize(oldestUrlElement);
            rootElement.remove(oldestUrlElement);
        }
        rootElement.addAttribute("entries", String.valueOf(entries));
        rootElement.addAttribute("size", String.valueOf(size));
    }
}

