/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.internal.template.util;

import com.liferay.layout.util.template.LayoutConverter;
import com.liferay.layout.util.template.LayoutConverterRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Eudaldo Alonso
 */
@Component(service = LayoutConverterRegistry.class)
public class LayoutConverterRegistryImpl implements LayoutConverterRegistry {

	@Override
	public LayoutConverter getLayoutConverter(String layoutTemplateId) {
		LayoutConverter layoutConverter = _serviceTrackerMap.getService(
			layoutTemplateId);

		if (layoutConverter == null) {
			layoutConverter = _defaultLayoutConverter;
		}

		return layoutConverter;
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, LayoutConverter.class, "layout.template.id");
	}

	@Reference(target = "(layout.template.id=default)")
	private LayoutConverter _defaultLayoutConverter;

	private ServiceTrackerMap<String, LayoutConverter> _serviceTrackerMap;

}