/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.action.provider;

import com.liferay.application.list.GroupProvider;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.ActionURLBuilder;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.portlet.ActionURL;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutActionProvider {
    private String _backURL;
    private Long _groupId;
    private final GroupProvider _groupProvider;
    private final HttpServletRequest _httpServletRequest;
    private final Language _language;
    private String _pageTypeSelectedOption;
    private String _redirect;
    private final SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    private final ThemeDisplay _themeDisplay;

    public LayoutActionProvider(GroupProvider groupProvider, HttpServletRequest httpServletRequest, Language language, SiteNavigationMenuLocalService siteNavigationMenuLocalService) {
        this._groupProvider = groupProvider;
        this._httpServletRequest = httpServletRequest;
        this._language = language;
        this._siteNavigationMenuLocalService = siteNavigationMenuLocalService;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public JSONArray getActionsJSONArray(Layout layout, Layout afterDeleteSelectedLayout) throws Exception {
        JSONArray itemsJSONArray = JSONFactoryUtil.createJSONArray();
        if (this._isShowPreviewDraftAction(layout)) {
            itemsJSONArray.put(JSONUtil.put((String)"href", (Object)PortalUtil.getLayoutFriendlyURL((Layout)layout.fetchDraftLayout(), (ThemeDisplay)this._themeDisplay)).put("id", "preview-draft").put("label", this._language.get(this._themeDisplay.getLocale(), "preview-draft")).put("symbolRight", "shortcut").put("target", "_blank").put("type", "item"));
        }
        HashMap valuesMap = HashMapBuilder.put((Object)"collectionPK", (Object)layout.getTypeSettingsProperty("collectionPK")).put((Object)"collectionType", (Object)layout.getTypeSettingsProperty("collectionType")).put((Object)"plid", (Object)String.valueOf(layout.getPlid())).build();
        if (!layout.isTypeCollection() && Validator.isNotNull((String)this._getAddChildURLTemplate())) {
            itemsJSONArray.put(JSONUtil.put((String)"href", (Object)StringUtil.replace((String)this._getAddChildURLTemplate(), (String)"{", (String)"}", (Map)valuesMap)).put("id", "add-child-page").put("label", this._language.get(this._themeDisplay.getLocale(), "add-child-page")).put("type", "item"));
        }
        if (!layout.isTypeCollection() && Validator.isNotNull((String)this._getAddChildCollectionURLTemplate())) {
            itemsJSONArray.put(JSONUtil.put((String)"href", (Object)StringUtil.replace((String)this._getAddChildCollectionURLTemplate(), (String)"{", (String)"}", (Map)valuesMap)).put("id", "add-child-collection-page").put("label", this._language.get(this._themeDisplay.getLocale(), "add-child-collection-page")).put("type", "item"));
        }
        itemsJSONArray.put(JSONUtil.put((String)"type", (Object)"divider")).put(JSONUtil.put((String)"data", (Object)JSONUtil.put((String)"id", (Object)"copy-page").put("modalTitle", this._language.get(this._themeDisplay.getLocale(), "copy-page")).put("url", this._getCopyLayoutRenderURL(layout))).put("href", "#").put("id", "copy-page").put("label", this._language.get(this._themeDisplay.getLocale(), "copy-page")).put("symbolLeft", "copy").put("type", "item")).put(JSONUtil.put((String)"type", (Object)"divider")).put(JSONUtil.put((String)"href", (Object)StringUtil.replace((String)this._getConfigureLayoutURLTemplate(), (String)"{", (String)"}", (Map)valuesMap)).put("id", "configure").put("label", this._language.get(this._themeDisplay.getLocale(), "configure")).put("symbolLeft", "cog").put("type", "item"));
        if (layout.isTypeCollection() && Validator.isNotNull((String)this._getViewCollectionItemsURL())) {
            itemsJSONArray.put(JSONUtil.put((String)"data", (Object)JSONUtil.put((String)"id", (Object)"view-collection-items").put("modalTitle", this._language.get(this._themeDisplay.getLocale(), "view-items")).put("url", StringUtil.replace((String)this._getViewCollectionItemsURL(), (String)"{", (String)"}", (Map)valuesMap))).put("href", "#").put("id", "view-collection-items").put("label", this._language.get(this._themeDisplay.getLocale(), "view-collection-items")).put("target", "_blank").put("type", "item"));
        }
        itemsJSONArray.put(JSONUtil.put((String)"data", (Object)JSONUtil.put((String)"id", (Object)"permissions").put("modalTitle", this._language.get(this._themeDisplay.getLocale(), "permissions")).put("url", this._getPermissionsURL(layout))).put("href", "#").put("id", "permissions").put("label", this._language.get(this._themeDisplay.getLocale(), "permissions")).put("symbolLeft", "password-policies").put("type", "item")).put(JSONUtil.put((String)"type", (Object)"divider")).put(JSONUtil.put((String)"data", (Object)HashMapBuilder.put((Object)"message", () -> {
            String messageKey = "are-you-sure-you-want-to-delete-the-page-x.-it-will-be-removed-immediately";
            if (layout.hasChildren() && this._hasScopeGroup(layout)) {
                messageKey = StringBundler.concat((String[])new String[]{"are-you-sure-you-want-to-delete-the-page-x.-", "this-page-serves-as-a-scope-for-content-and-", "also-contains-child-pages"});
            } else if (layout.hasChildren()) {
                messageKey = StringBundler.concat((String[])new String[]{"are-you-sure-you-want-to-delete-the-page-x.-", "this-page-contains-child-pages-that-will-", "also-be-removed"});
            } else if (this._hasScopeGroup(layout)) {
                messageKey = "are-you-sure-you-want-to-delete-the-page-x.-this-page-serves-as-a-scope-for-content";
            }
            return this._language.format(this._httpServletRequest, messageKey, (Object)HtmlUtil.escape((String)layout.getName(this._themeDisplay.getLocale())));
        }).put((Object)"modalTitle", (Object)this._language.get(this._themeDisplay.getLocale(), "delete-page")).put((Object)"url", (Object)this._getDeleteLayoutURL(layout, afterDeleteSelectedLayout)).build()).put("id", "delete").put("label", this._language.get(this._themeDisplay.getLocale(), "delete")).put("symbolLeft", "trash").put("type", "item"));
        return JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"items", (Object)itemsJSONArray).put("type", "group")});
    }

    private String _getAddChildCollectionURLTemplate() throws Exception {
        PortletURL addChildCollectionURL = this._getAddCollectionLayoutURL();
        if (addChildCollectionURL == null) {
            return "";
        }
        return StringBundler.concat((Object[])new Object[]{addChildCollectionURL, "&", "p_r_p_", "selPlid={plid}"});
    }

    private String _getAddChildURLTemplate() throws Exception {
        PortletURL addLayoutURL = this._getAddLayoutURL();
        if (addLayoutURL == null) {
            return "";
        }
        return StringBundler.concat((Object[])new Object[]{addLayoutURL, "&", "p_r_p_", "selPlid={plid}"});
    }

    private PortletURL _getAddCollectionLayoutURL() throws Exception {
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        if (scopeGroup.isStaged() && !scopeGroup.isStagingGroup()) {
            return null;
        }
        return PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCPath("/select_layout_collections.jsp").setRedirect(this._getRedirect()).setBackURL(this._getBackURL()).setParameter("groupId", (Object)this._themeDisplay.getSiteGroupId()).setParameter("privateLayout", (Object)this._isPrivateLayout()).buildPortletURL();
    }

    private PortletURL _getAddLayoutURL() throws Exception {
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        if (scopeGroup.isStaged() && !scopeGroup.isStagingGroup()) {
            return null;
        }
        return PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCPath("/select_layout_page_template_entry.jsp").setRedirect(this._getRedirect()).setBackURL(this._getBackURL()).setParameter("groupId", (Object)this._themeDisplay.getSiteGroupId()).setParameter("privateLayout", (Object)this._isPrivateLayout()).buildPortletURL();
    }

    private String _getBackURL() {
        if (this._backURL != null) {
            return this._backURL;
        }
        String backURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"backURL");
        if (Validator.isNull((String)backURL)) {
            backURL = ParamUtil.getString((HttpServletRequest)PortalUtil.getOriginalServletRequest((HttpServletRequest)this._httpServletRequest), (String)"backURL", (String)this._themeDisplay.getURLCurrent());
        }
        this._backURL = backURL;
        return backURL;
    }

    private String _getConfigureLayoutURL() throws Exception {
        PortletURL configureLayoutURL = PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCRenderCommandName("/layout_admin/edit_layout").buildPortletURL();
        Layout layout = this._themeDisplay.getLayout();
        if (layout.isTypeAssetDisplay() || layout.isTypeControlPanel()) {
            String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
            configureLayoutURL.setParameter("redirect", redirect);
            configureLayoutURL.setParameter("backURL", redirect);
        } else {
            configureLayoutURL.setParameter("redirect", PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)this._themeDisplay));
            configureLayoutURL.setParameter("backURL", PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)this._themeDisplay));
        }
        configureLayoutURL.setParameter("groupId", String.valueOf(this._themeDisplay.getScopeGroupId()));
        configureLayoutURL.setParameter("privateLayout", String.valueOf(this._isPrivateLayout()));
        return configureLayoutURL.toString();
    }

    private String _getConfigureLayoutURLTemplate() throws Exception {
        return StringBundler.concat((String[])new String[]{this._getConfigureLayoutURL(), "&", "p_r_p_", "selPlid={plid}"});
    }

    private String _getCopyLayoutRenderURL(Layout layout) {
        return PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCRenderCommandName("/layout_admin/add_layout").setRedirect(ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent())).setParameter("privateLayout", (Object)layout.isPrivateLayout()).setParameter("sourcePlid", (Object)layout.getPlid()).setWindowState(LiferayWindowState.POP_UP).buildString();
    }

    private String _getDeleteLayoutURL(Layout layout, Layout afterDeleteSelectedLayout) throws Exception {
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        if (scopeGroup.isStaged() && !scopeGroup.isStagingGroup()) {
            return null;
        }
        String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
        Layout curLayout = this._themeDisplay.getLayout();
        Layout draftLayout = layout.fetchDraftLayout();
        if (Objects.equals(curLayout.getPlid(), layout.getPlid()) || draftLayout != null && Objects.equals(curLayout.getPlid(), draftLayout.getPlid())) {
            redirect = afterDeleteSelectedLayout != null ? PortalUtil.getLayoutRelativeURL((Layout)afterDeleteSelectedLayout, (ThemeDisplay)this._themeDisplay) : String.valueOf(PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE"));
        }
        return ActionURLBuilder.createActionURL((ActionURL)((ActionURL)PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"ACTION_PHASE"))).setActionName("/layout_admin/delete_layout").setRedirect(redirect).setParameter("hideDefaultSuccessMessage", (Object)true).setParameter("selPlid", String.valueOf(layout.getPlid())).buildString();
    }

    private long _getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        Group group = this._groupProvider.getGroup(this._httpServletRequest);
        this._groupId = group != null ? Long.valueOf(group.getGroupId()) : Long.valueOf(this._themeDisplay.getSiteGroupId());
        return this._groupId;
    }

    private String _getPageTypeSelectedOption() {
        if (this._pageTypeSelectedOption != null) {
            return this._pageTypeSelectedOption;
        }
        String pageTypeSelectedOption = "PUBLIC_LAYOUT";
        String namespace = PortalUtil.getPortletNamespace((String)"com_liferay_product_navigation_product_menu_web_portlet_ProductMenuPortlet");
        String pageTypeSelectedOptionSessionValue = SessionClicks.get((HttpServletRequest)this._httpServletRequest, (String)(namespace + "PAGE_TYPE_SELECTED_OPTION"), (String)"PUBLIC_LAYOUT");
        if (this._isValidPageTypeSelectedOption(pageTypeSelectedOptionSessionValue)) {
            pageTypeSelectedOption = pageTypeSelectedOptionSessionValue;
        }
        this._pageTypeSelectedOption = pageTypeSelectedOption;
        return this._pageTypeSelectedOption;
    }

    private String _getPermissionsURL(Layout layout) throws Exception {
        return PermissionsURLTag.doTag((String)"", (String)Layout.class.getName(), (String)HtmlUtil.escape((String)layout.getName(this._themeDisplay.getLocale())), null, (String)String.valueOf(layout.getPlid()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._themeDisplay.getRequest());
    }

    private String _getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        if (Validator.isNull((String)redirect)) {
            redirect = PortalUtil.escapeRedirect((String)this._getBackURL());
        }
        this._redirect = redirect;
        return this._redirect;
    }

    private String _getViewCollectionItemsURL() throws Exception {
        PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this._httpServletRequest, (String)AssetListEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
        if (portletURL == null) {
            return "";
        }
        Layout layout = this._themeDisplay.getLayout();
        String redirect = PortalUtil.getLayoutRelativeURL((Layout)this._themeDisplay.getLayout(), (ThemeDisplay)this._themeDisplay);
        if (layout.isTypeAssetDisplay() || layout.isTypeControlPanel()) {
            redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect", (String)redirect);
        }
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("showActions", String.valueOf(Boolean.TRUE));
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return StringBundler.concat((Object[])new Object[]{portletURL, "&", PortalUtil.getPortletNamespace((String)"com_liferay_asset_list_web_portlet_AssetListPortlet"), "collectionPK={collectionPK}&", PortalUtil.getPortletNamespace((String)"com_liferay_asset_list_web_portlet_AssetListPortlet"), "collectionType={collectionType}"});
    }

    private boolean _hasScopeGroup(Layout layout) throws Exception {
        if (layout.hasScopeGroup()) {
            return true;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            return false;
        }
        return draftLayout.hasScopeGroup();
    }

    private boolean _isPageHierarchyOption(String pageTypeOption) {
        return Objects.equals(pageTypeOption, "PUBLIC_LAYOUT") || Objects.equals(pageTypeOption, "PRIVATE_LAYOUT");
    }

    private boolean _isPrivateLayout() {
        return Objects.equals("PRIVATE_LAYOUT", this._getPageTypeSelectedOption());
    }

    private boolean _isShowPreviewDraftAction(Layout layout) throws Exception {
        if (!layout.isTypeContent() || !LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE")) {
            return false;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            return false;
        }
        return draftLayout.isDraft() || !layout.isPublished();
    }

    private boolean _isValidPageTypeSelectedOption(String pageTypeSelectedOption) {
        if (this._isPageHierarchyOption(pageTypeSelectedOption)) {
            return true;
        }
        long siteNavigationMenuId = GetterUtil.getLong((String)pageTypeSelectedOption);
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuLocalService.fetchSiteNavigationMenu(siteNavigationMenuId);
        return siteNavigationMenu != null && siteNavigationMenu.getGroupId() == this._getGroupId();
    }
}

