/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.content;

import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.layout.content.LayoutContentProvider;
import com.liferay.layout.crawler.LayoutCrawler;
import com.liferay.layout.internal.search.util.LayoutPageTemplateStructureRenderUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.RenderLayoutContentThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={LayoutContentProvider.class})
public class LayoutContentProviderImpl
implements LayoutContentProvider {
    private static final String _WRAPPER_ELEMENT = "id=\"wrapper\">";
    private static final Log _log = LogFactoryUtil.getLog(LayoutContentProviderImpl.class);
    @Reference
    private FragmentRendererController _fragmentRendererController;
    @Reference
    private Html _html;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private LayoutCrawler _layoutCrawler;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Layout layout, Locale locale) {
        if (httpServletRequest == null || httpServletResponse == null) {
            return "";
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        if (layoutPageTemplateStructure == null) {
            return "";
        }
        boolean originalRenderLayoutContent = RenderLayoutContentThreadLocal.isRenderLayoutContent();
        try {
            String string;
            RenderLayoutContentThreadLocal.setRenderLayoutContent((boolean)true);
            if (this._isUseLayoutCrawler(layout)) {
                String content;
                block15: {
                    content = "";
                    try {
                        content = this._layoutCrawler.getLayoutContent(layout, locale);
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block15;
                        _log.warn((Object)"Unable to get layout content", (Throwable)exception);
                    }
                }
                content = this._getWrapper(content);
                if (Validator.isNotNull((String)content)) {
                    String exception = content;
                    return exception;
                }
            }
            httpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)httpServletRequest, (String)("p_l_id=" + layout.getPlid()), (boolean)false);
            Layout originalRequestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout originalThemeDisplayLayout = themeDisplay.getLayout();
            long originalThemeDisplayPlid = themeDisplay.getPlid();
            try {
                String content;
                block16: {
                    httpServletRequest.setAttribute("LAYOUT", (Object)layout);
                    httpServletRequest.setAttribute("SHOW_PORTLET_TOPPER", (Object)Boolean.TRUE);
                    themeDisplay.setLayout(layout);
                    themeDisplay.setPlid(layout.getPlid());
                    long segmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid());
                    content = "";
                    try {
                        content = LayoutPageTemplateStructureRenderUtil.renderLayoutContent(this._fragmentRendererController, httpServletRequest, httpServletResponse, layoutPageTemplateStructure, "INDEX", locale, segmentsExperienceId);
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block16;
                        _log.warn((Object)"Unable to get layout content", (Throwable)exception);
                    }
                }
                string = this._html.stripHtml(content);
            }
            catch (Throwable throwable) {
                httpServletRequest.setAttribute("LAYOUT", (Object)originalRequestLayout);
                httpServletRequest.removeAttribute("SHOW_PORTLET_TOPPER");
                themeDisplay.setLayout(originalThemeDisplayLayout);
                themeDisplay.setPlid(originalThemeDisplayPlid);
                throw throwable;
            }
            httpServletRequest.setAttribute("LAYOUT", (Object)originalRequestLayout);
            httpServletRequest.removeAttribute("SHOW_PORTLET_TOPPER");
            themeDisplay.setLayout(originalThemeDisplayLayout);
            themeDisplay.setPlid(originalThemeDisplayPlid);
            return string;
        }
        finally {
            RenderLayoutContentThreadLocal.setRenderLayoutContent((boolean)originalRenderLayoutContent);
        }
    }

    private String _getWrapper(String layoutContent) {
        int wrapperIndex = layoutContent.indexOf(_WRAPPER_ELEMENT);
        if (wrapperIndex == -1) {
            return layoutContent;
        }
        return this._html.stripHtml(layoutContent.substring(wrapperIndex + _WRAPPER_ELEMENT.length()));
    }

    private boolean _isUseLayoutCrawler(Layout layout) {
        if (this._layoutCrawler == null || layout.isPrivateLayout()) {
            return false;
        }
        Role role = this._roleLocalService.fetchRole(layout.getCompanyId(), "Guest");
        if (role == null) {
            return false;
        }
        ResourcePermission resourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(role.getCompanyId(), Layout.class.getName(), 4, String.valueOf(layout.getPlid()), role.getRoleId());
        return resourcePermission != null && resourcePermission.isViewActionId();
    }
}

