/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exporter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.layout.exporter.LayoutsExporter;
import com.liferay.layout.internal.headless.delivery.dto.v1_0.util.DisplayPageTemplateUtil;
import com.liferay.layout.internal.headless.delivery.dto.v1_0.util.MasterPageUtil;
import com.liferay.layout.internal.headless.delivery.dto.v1_0.util.PageTemplateCollectionUtil;
import com.liferay.layout.internal.headless.delivery.dto.v1_0.util.PageTemplateUtil;
import com.liferay.layout.internal.headless.delivery.dto.v1_0.util.UtilityPageTemplateUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryLocalService;
import com.liferay.petra.function.UnsafeTriConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactory;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.File;
import java.text.DateFormat;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutsExporter.class})
public class LayoutsExporterImpl
implements LayoutsExporter {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsExporterImpl.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            this.enable(SerializationFeature.INDENT_OUTPUT);
            this.setDateFormat((DateFormat)new ISO8601DateFormat());
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            this.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        }
    };
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutUtilityPageEntryLocalService _layoutUtilityPageEntryLocalService;
    @Reference
    private ZipWriterFactory _zipWriterFactory;

    public File exportLayoutPageTemplateEntries(long groupId) throws Exception {
        DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter = this._getPageDefinitionDTOConverter();
        ZipWriter zipWriter = this._zipWriterFactory.getZipWriter();
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(groupId);
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            if (layoutPageTemplateEntry.isDraft()) continue;
            if (layoutPageTemplateEntry.getType() == 0) {
                this._populatePageTemplatesZipWriter(layoutPageTemplateEntry, pageDefinitionDTOConverter, zipWriter);
                continue;
            }
            if (layoutPageTemplateEntry.getType() == 1) {
                this._populateDisplayPagesZipWriter(layoutPageTemplateEntry, pageDefinitionDTOConverter, zipWriter);
                continue;
            }
            if (layoutPageTemplateEntry.getType() != 3) continue;
            this._populateMasterLayoutsZipWriter(layoutPageTemplateEntry, pageDefinitionDTOConverter, zipWriter);
        }
        return zipWriter.getFile();
    }

    public File exportLayoutPageTemplateEntries(long[] layoutPageTemplateEntryIds, int type) throws Exception {
        if (0 == type) {
            return this._exportLayoutPageTemplateEntries(layoutPageTemplateEntryIds, type, (UnsafeTriConsumer<LayoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition>, ZipWriter, Exception>)((UnsafeTriConsumer)this::_populatePageTemplatesZipWriter));
        }
        if (1 == type) {
            return this._exportLayoutPageTemplateEntries(layoutPageTemplateEntryIds, type, (UnsafeTriConsumer<LayoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition>, ZipWriter, Exception>)((UnsafeTriConsumer)this::_populateDisplayPagesZipWriter));
        }
        if (3 == type) {
            return this._exportLayoutPageTemplateEntries(layoutPageTemplateEntryIds, type, (UnsafeTriConsumer<LayoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition>, ZipWriter, Exception>)((UnsafeTriConsumer)this::_populateMasterLayoutsZipWriter));
        }
        return null;
    }

    public File exportLayoutUtilityPageEntries(long[] layoutUtilityPageEntryIds) throws Exception {
        DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter = this._getPageDefinitionDTOConverter();
        ZipWriter zipWriter = this._zipWriterFactory.getZipWriter();
        for (long layoutUtilityPageEntryId : layoutUtilityPageEntryIds) {
            LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryLocalService.fetchLayoutUtilityPageEntry(layoutUtilityPageEntryId);
            this._populateLayoutUtilityPageEntriesZipWriter(layoutUtilityPageEntry, pageDefinitionDTOConverter, zipWriter);
        }
        return zipWriter.getFile();
    }

    private File _exportLayoutPageTemplateEntries(long[] layoutPageTemplateEntryIds, int type, UnsafeTriConsumer<LayoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition>, ZipWriter, Exception> unsafeConsumer) throws Exception {
        DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter = this._getPageDefinitionDTOConverter();
        ZipWriter zipWriter = this._zipWriterFactory.getZipWriter();
        for (long layoutPageTemplateEntryId : layoutPageTemplateEntryIds) {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
            if (layoutPageTemplateEntry.isDraft() || layoutPageTemplateEntry.getType() != type) continue;
            unsafeConsumer.accept((Object)layoutPageTemplateEntry, pageDefinitionDTOConverter, (Object)zipWriter);
        }
        return zipWriter.getFile();
    }

    private DTOConverterContext _getDTOConverterContext(Layout layout, LayoutStructure layoutStructure) {
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)layoutStructure.getMainItemId(), null, null, null);
        dtoConverterContext.setAttribute("layout", (Object)layout);
        return dtoConverterContext;
    }

    private LayoutStructure _getLayoutStructure(Layout layout) {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        return LayoutStructure.of((String)layoutPageTemplateStructure.getDefaultSegmentsExperienceData());
    }

    private DTOConverter<LayoutStructure, PageDefinition> _getPageDefinitionDTOConverter() {
        return this._dtoConverterRegistry.getDTOConverter(LayoutStructure.class.getName());
    }

    private FileEntry _getPreviewFileEntry(long previewFileEntryId) {
        if (previewFileEntryId <= 0L) {
            return null;
        }
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)previewFileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get file entry preview", (Throwable)portalException);
            }
            return null;
        }
    }

    private void _populateDisplayPagesZipWriter(LayoutPageTemplateEntry layoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter, ZipWriter zipWriter) throws Exception {
        FileEntry previewFileEntry;
        String displayPagePath = "display-page-templates/" + layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        SimpleFilterProvider filterProvider = simpleFilterProvider.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
        ObjectWriter objectWriter = _objectMapper.writer((FilterProvider)filterProvider);
        zipWriter.addEntry(displayPagePath + "/" + "display-page-template.json", objectWriter.writeValueAsString((Object)DisplayPageTemplateUtil.toDisplayPageTemplate(layoutPageTemplateEntry)));
        Layout layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        if (layout != null) {
            LayoutStructure layoutStructure = this._getLayoutStructure(layout);
            PageDefinition pageDefinition = (PageDefinition)pageDefinitionDTOConverter.toDTO(this._getDTOConverterContext(layout, layoutStructure), (Object)layoutStructure);
            zipWriter.addEntry(displayPagePath + "/page-definition.json", objectWriter.writeValueAsString((Object)pageDefinition));
        }
        if ((previewFileEntry = this._getPreviewFileEntry(layoutPageTemplateEntry.getPreviewFileEntryId())) != null) {
            zipWriter.addEntry(displayPagePath + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }

    private void _populateLayoutUtilityPageEntriesZipWriter(LayoutUtilityPageEntry layoutUtilityPageEntry, DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter, ZipWriter zipWriter) throws Exception {
        FileEntry previewFileEntry;
        String layoutUtilityPageEntryPath = "layout-utility-page-template/" + layoutUtilityPageEntry.getExternalReferenceCode();
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        SimpleFilterProvider filterProvider = simpleFilterProvider.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
        ObjectWriter objectWriter = _objectMapper.writer((FilterProvider)filterProvider);
        zipWriter.addEntry(layoutUtilityPageEntryPath + "/utility-page.json", objectWriter.writeValueAsString((Object)UtilityPageTemplateUtil.toUtilityPageTemplate(layoutUtilityPageEntry)));
        Layout layout = this._layoutLocalService.fetchLayout(layoutUtilityPageEntry.getPlid());
        if (layout != null) {
            LayoutStructure layoutStructure = this._getLayoutStructure(layout);
            PageDefinition pageDefinition = (PageDefinition)pageDefinitionDTOConverter.toDTO(this._getDTOConverterContext(layout, layoutStructure), (Object)layoutStructure);
            zipWriter.addEntry(layoutUtilityPageEntryPath + "/page-definition.json", objectWriter.writeValueAsString((Object)pageDefinition));
        }
        if ((previewFileEntry = this._getPreviewFileEntry(layoutUtilityPageEntry.getPreviewFileEntryId())) != null) {
            zipWriter.addEntry(layoutUtilityPageEntryPath + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }

    private void _populateMasterLayoutsZipWriter(LayoutPageTemplateEntry layoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter, ZipWriter zipWriter) throws Exception {
        FileEntry previewFileEntry;
        String masterLayoutPath = "master-pages/" + layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        SimpleFilterProvider filterProvider = simpleFilterProvider.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
        ObjectWriter objectWriter = _objectMapper.writer((FilterProvider)filterProvider);
        zipWriter.addEntry(masterLayoutPath + "/" + "master-page.json", objectWriter.writeValueAsString((Object)MasterPageUtil.toMasterPage(layoutPageTemplateEntry)));
        Layout layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        if (layout != null) {
            LayoutStructure layoutStructure = this._getLayoutStructure(layout);
            PageDefinition pageDefinition = (PageDefinition)pageDefinitionDTOConverter.toDTO(this._getDTOConverterContext(layout, layoutStructure), (Object)layoutStructure);
            zipWriter.addEntry(masterLayoutPath + "/page-definition.json", objectWriter.writeValueAsString((Object)pageDefinition));
        }
        if ((previewFileEntry = this._getPreviewFileEntry(layoutPageTemplateEntry.getPreviewFileEntryId())) != null) {
            zipWriter.addEntry(masterLayoutPath + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }

    private void _populatePageTemplatesZipWriter(LayoutPageTemplateEntry layoutPageTemplateEntry, DTOConverter<LayoutStructure, PageDefinition> pageDefinitionDTOConverter, ZipWriter zipWriter) throws Exception {
        FileEntry previewFileEntry;
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionLocalService.getLayoutPageTemplateCollection(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        String layoutPageTemplateCollectionKey = layoutPageTemplateCollection.getLayoutPageTemplateCollectionKey();
        String layoutPageTemplateCollectionPath = "page-templates/" + layoutPageTemplateCollectionKey;
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        SimpleFilterProvider filterProvider = simpleFilterProvider.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
        ObjectWriter objectWriter = _objectMapper.writer((FilterProvider)filterProvider);
        zipWriter.addEntry(layoutPageTemplateCollectionPath + "/" + "page-template-collection.json", objectWriter.writeValueAsString((Object)PageTemplateCollectionUtil.toPageTemplateCollection(layoutPageTemplateCollection)));
        String layoutPageTemplateEntryPath = layoutPageTemplateCollectionPath + "/" + layoutPageTemplateEntry.getLayoutPageTemplateEntryKey();
        zipWriter.addEntry(layoutPageTemplateEntryPath + "/" + "page-template.json", objectWriter.writeValueAsString((Object)PageTemplateUtil.toPageTemplate(layoutPageTemplateEntry)));
        Layout layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        if (layout != null) {
            LayoutStructure layoutStructure = this._getLayoutStructure(layout);
            PageDefinition pageDefinition = (PageDefinition)pageDefinitionDTOConverter.toDTO(this._getDTOConverterContext(layout, layoutStructure), (Object)layoutStructure);
            zipWriter.addEntry(layoutPageTemplateEntryPath + "/page-definition.json", objectWriter.writeValueAsString((Object)pageDefinition));
        }
        if ((previewFileEntry = this._getPreviewFileEntry(layoutPageTemplateEntry.getPreviewFileEntryId())) != null) {
            zipWriter.addEntry(layoutPageTemplateEntryPath + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }
}

