/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.data.handler;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.lar.ThemeExporter;
import com.liferay.exportimport.lar.ThemeImporter;
import com.liferay.layout.internal.exportimport.staged.model.repository.StagedLayoutSetStagedModelRepository;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactory;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ThemeFactory;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.sites.kernel.util.Sites;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class StagedLayoutSetStagedModelDataHandler
extends BaseStagedModelDataHandler<StagedLayoutSet> {
    public static final String[] CLASS_NAMES = new String[]{StagedLayoutSet.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetStagedModelDataHandler.class);
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private ColorSchemeFactory _colorSchemeFactory;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(content.processor.type=DLReferences)")
    private ExportImportContentProcessor<String> _dlReferencesExportImportContentProcessor;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutLocalServiceHelper _layoutLocalServiceHelper;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Sites _sites;
    @Reference
    private StagedLayoutSetStagedModelRepository _stagedLayoutSetStagedModelRepository;
    @Reference
    private ThemeExporter _themeExporter;
    @Reference
    private ThemeFactory _themeFactory;
    @Reference
    private ThemeImporter _themeImporter;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        boolean layoutSetSettings;
        this._exportClientExtensionEntryRels(portletDataContext, stagedLayoutSet);
        this._exportLayouts(portletDataContext, stagedLayoutSet);
        this._exportLogo(portletDataContext, stagedLayoutSet);
        this._exportTheme(portletDataContext, stagedLayoutSet);
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        if (!layoutSetPrototypeSettings) {
            layoutSet.setLayoutSetPrototypeUuid("");
            layoutSet.setLayoutSetPrototypeLinkEnabled(false);
        }
        if (!(layoutSetSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_SETTINGS"))) {
            layoutSet.setSettings("");
        }
        Element stagedLayoutSetElement = portletDataContext.getExportDataElement((ClassedModel)stagedLayoutSet);
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        settingsUnicodeProperties.remove((Object)"last-publish-date");
        stagedLayoutSet = this._unwrapLayoutSetStagingHandler(stagedLayoutSet);
        portletDataContext.addClassedModel(stagedLayoutSetElement, ExportImportPathUtil.getModelPath((StagedModel)stagedLayoutSet), (ClassedModel)stagedLayoutSet);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        this._exportFaviconFileEntry(portletDataContext, stagedLayoutSet, stagedLayoutSetElement);
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate) {
            this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new UpdateLayoutSetLastPublishDateCallable(portletDataContext.getDateRange(), portletDataContext.getGroupId(), portletDataContext.isPrivateLayout()));
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        StagedLayoutSet existingStagedLayoutSet = this._stagedLayoutSetStagedModelRepository.fetchExistingLayoutSet(portletDataContext.getScopeGroupId(), layoutSet.isPrivateLayout());
        layoutSet.setPrivateLayout(portletDataContext.isPrivateLayout());
        StagedLayoutSet importedStagedLayoutSet = (StagedLayoutSet)stagedLayoutSet.clone();
        importedStagedLayoutSet.setGroupId(portletDataContext.getScopeGroupId());
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (existingStagedLayoutSet != null && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            LayoutSet existingLayoutSet = existingStagedLayoutSet.getLayoutSet();
            LayoutSet importedLayoutSet = importedStagedLayoutSet.getLayoutSet();
            importedLayoutSet.setLayoutSetId(existingLayoutSet.getLayoutSetId());
            importedStagedLayoutSet = this._stagedLayoutSetStagedModelRepository.updateStagedModel(portletDataContext, importedStagedLayoutSet);
        }
        this._importClientExtensionEntryRels(portletDataContext, stagedLayoutSet);
        this._importLogo(portletDataContext);
        this._importTheme(portletDataContext, stagedLayoutSet);
        portletDataContext.importClassedModel((ClassedModel)stagedLayoutSet, (ClassedModel)importedStagedLayoutSet);
        Element layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        List layoutElements = layoutsElement.elements();
        this._deleteMissingLayouts(portletDataContext, layoutElements);
        HashSet<Layout> modifiedLayouts = new HashSet<Layout>();
        this._checkLayoutSetPrototypeLayouts(portletDataContext, modifiedLayouts);
        this._updateLayoutSetSettingsProperties(portletDataContext, importedStagedLayoutSet);
        LayoutSet importedLayoutSet = importedStagedLayoutSet.getLayoutSet();
        Group group = importedLayoutSet.getGroup();
        if (!group.isLayoutSetPrototype()) {
            this._updateLastMergeTime(portletDataContext, modifiedLayouts);
        }
        Element stagedLayoutSetElement = portletDataContext.getImportDataStagedModelElement((StagedModel)stagedLayoutSet);
        this._importFaviconFileEntry(portletDataContext, stagedLayoutSet, stagedLayoutSetElement);
        this._updateLayoutPriorities(portletDataContext, layoutElements, portletDataContext.isPrivateLayout());
    }

    private void _checkLayoutSetPrototypeLayouts(PortletDataContext portletDataContext, Set<Layout> modifiedLayouts) throws Exception {
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        if (!layoutSetPrototypeLinkEnabled || Validator.isNull((String)portletDataContext.getLayoutSetPrototypeUuid()) || !MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return;
        }
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(portletDataContext.getLayoutSetPrototypeUuid(), portletDataContext.getCompanyId());
        for (Layout layout : this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout())) {
            if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) continue;
            if (this._sites.isLayoutModifiedSinceLastMerge(layout)) {
                modifiedLayouts.add(layout);
                continue;
            }
            Layout sourcePrototypeLayout = this._layoutLocalService.fetchLayout(layout.getSourcePrototypeLayoutUuid(), layoutSetPrototype.getGroupId(), true);
            if (sourcePrototypeLayout != null || !this._layoutLocalService.hasLayout(layout.getUuid(), layout.getGroupId(), layout.isPrivateLayout())) continue;
            this._layoutLocalService.deleteLayout(layout, ServiceContextThreadLocal.getServiceContext());
        }
    }

    private void _deleteMissingLayouts(PortletDataContext portletDataContext, List<Element> layoutElements) {
        boolean deleteMissingLayouts = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        if (!deleteMissingLayouts) {
            return;
        }
        List sourceLayoutUuids = TransformUtil.transform(layoutElements, layoutElement -> layoutElement.attributeValue("uuid"));
        if (_log.isDebugEnabled() && !sourceLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (Layout layout : this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout())) {
            if (sourceLayoutUuids.contains(layout.getUuid()) || layoutPlids.containsValue(layout.getPlid()) || (layout = this._layoutLocalService.fetchLayout(layout.getPlid())) == null) continue;
            String layoutUUID = layout.getUuid();
            long stagingGroupID = portletDataContext.getSourceGroupId();
            try {
                Layout stagedLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUUID, stagingGroupID, !layout.isPublicLayout());
                if (stagedLayout != null && this._exportImportHelper.isLayoutRevisionInReview(stagedLayout)) continue;
                this._layoutLocalService.deleteLayout(layout, serviceContext);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to delete layout with UUID " + layoutUUID), (Throwable)exception);
            }
        }
    }

    private void _exportClientExtensionEntryRels(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        for (ClientExtensionEntryRel clientExtensionEntryRel : this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId())) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedLayoutSet, (StagedModel)clientExtensionEntryRel, (String)"strong");
        }
    }

    private void _exportFaviconFileEntry(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet, Element stagedLayoutSetElement) throws Exception {
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        long faviconFileEntryId = layoutSet.getFaviconFileEntryId();
        if (faviconFileEntryId <= 0L) {
            return;
        }
        FileEntry faviconFileEntry = null;
        try {
            faviconFileEntry = this._dlAppService.getFileEntry(layoutSet.getFaviconFileEntryId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return;
        }
        if (Validator.isNull((String)stagedLayoutSetElement.attributeValue("favicon-file-entry-uuid"))) {
            stagedLayoutSetElement.addAttribute("favicon-file-entry-uuid", faviconFileEntry.getUuid());
            stagedLayoutSetElement.addAttribute("favicon-file-entry-group-id", String.valueOf(faviconFileEntry.getGroupId()));
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedLayoutSet, (StagedModel)faviconFileEntry, (String)"strong");
    }

    private void _exportLayouts(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        portletDataContext.getExportDataGroupElement(Layout.class);
        long[] layoutIds = portletDataContext.getLayoutIds();
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        Group group = layoutSet.getGroup();
        if (group.isLayoutPrototype()) {
            layoutIds = this._exportImportHelper.getAllLayoutIds(group.getGroupId(), portletDataContext.isPrivateLayout());
        }
        for (StagedModel stagedModel : this._stagedLayoutSetStagedModelRepository.fetchChildrenStagedModels(portletDataContext, stagedLayoutSet)) {
            Layout layout = (Layout)stagedModel;
            if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId())) {
                Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
                layoutElement.addAttribute("action", "skip");
                layoutElement.addAttribute("layout-parent-layout-id", String.valueOf(layout.getParentLayoutId()));
                continue;
            }
            try {
                if (!LayoutStagingUtil.prepareLayoutStagingHandler((PortletDataContext)portletDataContext, (Layout)layout)) continue;
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedLayoutSet, (StagedModel)layout, (String)"child");
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to export layout " + layout.getName()), (Throwable)exception);
                }
                throw exception;
            }
        }
    }

    private void _exportLogo(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        Image image;
        block8: {
            boolean logo = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LOGO");
            LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
            if (!logo) {
                layoutSet.setLogoId(0L);
                return;
            }
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
            image = null;
            if (layoutSetBranch != null) {
                try {
                    image = this._imageLocalService.getImage(layoutSetBranch.getLogoId());
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get logo for layout set branch " + layoutSetBranch.getLayoutSetBranchId()), (Throwable)portalException);
                    }
                    break block8;
                }
            }
            try {
                image = this._imageLocalService.getImage(layoutSet.getLogoId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to get logo for layout set " + layoutSet.getLayoutSetId()), (Throwable)portalException);
            }
        }
        if (image != null && image.getTextObj() != null) {
            String logoPath = ExportImportPathUtil.getModelPath((StagedModel)stagedLayoutSet, (String)(image.getImageId() + "." + image.getType()));
            Element rootElement = portletDataContext.getExportDataRootElement();
            Element headerElement = rootElement.element("header");
            headerElement.addAttribute("logo-path", logoPath);
            portletDataContext.addZipEntry(logoPath, image.getTextObj());
        }
    }

    private void _exportTheme(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        block7: {
            boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
            LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
            if (!exportThemeSettings) {
                layoutSet.setThemeId(this._themeFactory.getDefaultRegularThemeId(stagedLayoutSet.getCompanyId()));
                layoutSet.setColorSchemeId(this._colorSchemeFactory.getDefaultRegularColorSchemeId());
                layoutSet.setCss("");
                return;
            }
            String css = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)stagedLayoutSet, (Serializable)((Object)layoutSet.getCss()), true, false));
            layoutSet.setCss(css);
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
            if (layoutSetBranch != null) {
                try {
                    this._themeExporter.exportTheme(portletDataContext, layoutSetBranch);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to export theme reference for layout set branch " + layoutSetBranch.getLayoutSetBranchId()), (Throwable)exception);
                    }
                    break block7;
                }
            }
            try {
                this._themeExporter.exportTheme(portletDataContext, layoutSet);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to export theme reference for layout set " + layoutSet.getLayoutSetId()), (Throwable)exception);
            }
        }
    }

    private boolean _hasSiblingLayoutWithSamePriority(Layout layout, List<Layout> siblingLayouts) {
        for (Layout siblingLayout : siblingLayouts) {
            if (layout.getPlid() == siblingLayout.getPlid() || layout.getPriority() != siblingLayout.getPriority()) continue;
            return true;
        }
        return false;
    }

    private boolean _hasSkippedSiblingLayout(Element layoutElement, Map<Long, List<String>> siblingActionsMap) {
        List<String> actions = siblingActionsMap.get(GetterUtil.getLong((String)layoutElement.attributeValue("layout-parent-layout-id")));
        return actions.contains("skip");
    }

    private void _importClientExtensionEntryRels(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        List clientExtensionEntryRelsElements = portletDataContext.getReferenceDataElements((StagedModel)stagedLayoutSet, ClientExtensionEntryRel.class);
        for (Element clientExtensionEntryRelsElement : clientExtensionEntryRelsElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)clientExtensionEntryRelsElement);
        }
    }

    private void _importFaviconFileEntry(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet, Element stagedLayoutSetElement) throws Exception {
        long faviconFileEntryId;
        block3: {
            LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedLayoutSet, DLFileEntry.class, (Serializable)Long.valueOf(layoutSet.getFaviconFileEntryId()));
            Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
            faviconFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)layoutSet.getFaviconFileEntryId(), (long)0L);
            String faviconFileEntryUuid = stagedLayoutSetElement.attributeValue("favicon-file-entry-uuid");
            if (faviconFileEntryId == 0L && Validator.isNotNull((String)faviconFileEntryUuid)) {
                long faviconFileEntryGroupId = GetterUtil.getLong((String)stagedLayoutSetElement.attributeValue("favicon-file-entry-group-id"));
                try {
                    FileEntry faviconFileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(faviconFileEntryUuid, faviconFileEntryGroupId);
                    faviconFileEntryId = faviconFileEntry.getFileEntryId();
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        LayoutSet existingLayoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        existingLayoutSet.setFaviconFileEntryId(faviconFileEntryId);
        this._layoutSetLocalService.updateLayoutSet(existingLayoutSet);
    }

    private void _importLogo(PortletDataContext portletDataContext) {
        block5: {
            boolean logo = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LOGO");
            if (!logo) {
                return;
            }
            Element rootElement = portletDataContext.getImportDataRootElement();
            Element headerElement = rootElement.element("header");
            String logoPath = headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            try {
                if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
                    this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), true, iconBytes);
                } else {
                    this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), false, (File)null);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to import logo", (Throwable)portalException);
            }
        }
    }

    private void _importTheme(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        block2: {
            LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
            try {
                String css = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)stagedLayoutSet, (Serializable)((Object)layoutSet.getCss())));
                layoutSet.setCss(css);
                this._themeImporter.importTheme(portletDataContext, layoutSet);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to import theme reference " + layoutSet.getThemeId()), (Throwable)exception);
            }
        }
    }

    private StagedLayoutSet _unwrapLayoutSetStagingHandler(StagedLayoutSet stagedLayoutSet) {
        LayoutSet layoutSet = (LayoutSet)ModelAdapterUtil.adapt((Object)stagedLayoutSet, StagedLayoutSet.class, LayoutSet.class);
        layoutSet = LayoutStagingUtil.mergeLayoutSetRevisionIntoLayoutSet((LayoutSet)layoutSet);
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
    }

    private void _updateLastMergeTime(PortletDataContext portletDataContext, Set<Layout> modifiedLayouts) throws Exception {
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (!layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        long lastMergeTime = System.currentTimeMillis();
        for (Layout layout : layouts.values()) {
            if (modifiedLayouts.contains(layout = this._layoutLocalService.getLayout(layout.getPlid()))) continue;
            UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
            typeSettingsUnicodeProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
            this._layoutLocalService.updateLayout(layout);
        }
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        settingsUnicodeProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
        long lastMergeVersion = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"lastMergeVersion");
        settingsUnicodeProperties.setProperty("last-merge-version", String.valueOf(lastMergeVersion));
        this._layoutSetLocalService.updateLayoutSet(layoutSet);
    }

    private void _updateLayoutPriorities(PortletDataContext portletDataContext, List<Element> layoutElements, boolean privateLayout) throws Exception {
        Layout layout;
        if (ExportImportThreadLocal.isInitialLayoutStagingInProcess()) {
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        HashMap<Long, Integer> layoutPriorities = new HashMap<Long, Integer>();
        HashMap<Long, List<String>> siblingActionsMap = new HashMap<Long, List<String>>();
        for (Element layoutElement : layoutElements) {
            long elementParentLayoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-parent-layout-id"));
            ArrayList<String> actions = (ArrayList<String>)siblingActionsMap.get(elementParentLayoutId);
            if (actions == null) {
                actions = new ArrayList<String>();
            } else if (actions.contains("skip")) continue;
            actions.add(layoutElement.attributeValue("action"));
            siblingActionsMap.put(elementParentLayoutId, actions);
        }
        for (Element layoutElement : layoutElements) {
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip") || this._hasSkippedSiblingLayout(layoutElement, siblingActionsMap)) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Do not update priority for layout ", layoutElement.attributeValue("uuid"), " because there are elements at the same level of ", "the page hierarchy with the SKIP action"}));
                continue;
            }
            if (!action.equals("add")) continue;
            long layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id"));
            layout = (Layout)layouts.get(layoutId);
            if (layout == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Layout ", layoutElement.attributeValue("uuid"), " might not have been imported due to a ", "controlled error. See ", "SitesImpl#addMergeFailFriendlyURLLayout."}));
                continue;
            }
            int layoutPriority = GetterUtil.getInteger((String)layoutElement.attributeValue("layout-priority"));
            layoutPriority = this._layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layoutPriority);
            layoutPriorities.put(layout.getPlid(), layoutPriority);
        }
        HashSet<Long> parentLayoutIds = new HashSet<Long>();
        Set updatedPlids = layoutPriorities.keySet();
        Iterator<Object> iterator = updatedPlids.iterator();
        while (iterator.hasNext()) {
            long plid = (Long)iterator.next();
            layout = this._layoutLocalService.fetchLayout(plid);
            int newLayoutPriority = (Integer)layoutPriorities.get(plid);
            if (layout.getPriority() == newLayoutPriority) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Updated priority for layout ", layout.getUuid(), " from ", layout.getPriority(), " to ", newLayoutPriority}));
            }
            layout.setPriority(newLayoutPriority);
            this._layoutLocalService.updateLayout(layout);
            parentLayoutIds.add(layout.getParentLayoutId());
        }
        iterator = parentLayoutIds.iterator();
        while (iterator.hasNext()) {
            long parentLayoutId = (Long)iterator.next();
            List siblingLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), privateLayout, parentLayoutId);
            for (Layout layout2 : siblingLayouts) {
                if (updatedPlids.contains(layout2.getPlid()) || !this._hasSiblingLayoutWithSamePriority(layout2, siblingLayouts)) continue;
                do {
                    int priority = layout2.getPriority();
                    layout2.setPriority(++priority);
                } while (this._hasSiblingLayoutWithSamePriority(layout2, siblingLayouts));
                this._layoutLocalService.updateLayout(layout2);
            }
        }
    }

    private void _updateLayoutSetSettingsProperties(PortletDataContext portletDataContext, StagedLayoutSet importedLayoutSet) throws Exception {
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsUnicodeProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNull((String)mergeFailFriendlyURLLayouts)) {
            boolean changed = false;
            LayoutSet stagedLayoutSet = importedLayoutSet.getLayoutSet();
            UnicodeProperties importedSettingsUnicodeProperties = stagedLayoutSet.getSettingsProperties();
            Theme importedTheme = stagedLayoutSet.getTheme();
            Map themeSettings = importedTheme.getConfigurableSettings();
            HashMap<String, String> defaultsMap = new HashMap<String, String>();
            for (Map.Entry entry : themeSettings.entrySet()) {
                ThemeSetting themeSetting = (ThemeSetting)entry.getValue();
                defaultsMap.put(ThemeSettingImpl.namespaceProperty((String)"regular", (String)((String)entry.getKey())), themeSetting.getValue());
            }
            defaultsMap.put("showSiteName", Boolean.TRUE.toString());
            defaultsMap.put("javascript", null);
            for (Map.Entry entry : defaultsMap.entrySet()) {
                String importedValue;
                String defaultValue;
                String propertyKey = (String)entry.getKey();
                String currentValue = settingsUnicodeProperties.getProperty(propertyKey, defaultValue = (String)entry.getValue());
                if (Objects.equals(currentValue, importedValue = importedSettingsUnicodeProperties.getProperty(propertyKey, defaultValue))) continue;
                if (Objects.equals(defaultValue, importedValue)) {
                    settingsUnicodeProperties.remove((Object)propertyKey);
                } else {
                    settingsUnicodeProperties.setProperty(propertyKey, importedValue);
                }
                changed = true;
            }
            if (changed) {
                this._layoutSetLocalService.updateLayoutSet(layoutSet);
            }
        }
    }

    private class UpdateLayoutSetLastPublishDateCallable
    implements Callable<Void> {
        private final DateRange _dateRange;
        private final long _groupId;
        private final boolean _privateLayout;

        public UpdateLayoutSetLastPublishDateCallable(DateRange dateRange, long groupId, boolean privateLayout) {
            this._dateRange = dateRange;
            this._groupId = groupId;
            this._privateLayout = privateLayout;
        }

        @Override
        public Void call() throws PortalException {
            Group group = StagedLayoutSetStagedModelDataHandler.this._groupLocalService.getGroup(this._groupId);
            Date endDate = null;
            if (this._dateRange != null) {
                endDate = this._dateRange.getEndDate();
            }
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                ExportImportDateUtil.updateLastPublishDate((long)stagingGroup.getGroupId(), (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            } else {
                ExportImportDateUtil.updateLastPublishDate((long)this._groupId, (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            }
            return null;
        }
    }
}

