/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.set.model.adapter.StagedLayoutSet"}, service={StagedLayoutSetStagedModelRepository.class, StagedModelRepository.class})
public class StagedLayoutSetStagedModelRepository
implements StagedModelRepository<StagedLayoutSet> {
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetStagedModelRepository.class);
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;

    public StagedLayoutSet addStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws PortalException {
        return null;
    }

    public void deleteStagedModel(StagedLayoutSet stagedLayoutSet) throws PortalException {
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public List<StagedModel> fetchChildrenStagedModels(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        return TransformUtil.transform((Collection)this._layoutLocalService.getLayouts(stagedLayoutSet.getGroupId(), layoutSet.isPrivateLayout()), layout -> {
            if (this._exportImportHelper.isLayoutRevisionInReview(layout)) {
                return null;
            }
            return layout;
        });
    }

    public StagedLayoutSet fetchExistingLayoutSet(long groupId, boolean privateLayout) {
        StagedLayoutSet stagedLayoutSet;
        block2: {
            stagedLayoutSet = null;
            try {
                stagedLayoutSet = (StagedLayoutSet)ModelAdapterUtil.adapt((Object)this._layoutSetLocalService.getLayoutSet(groupId, privateLayout), LayoutSet.class, StagedLayoutSet.class);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
        return stagedLayoutSet;
    }

    public StagedLayoutSet fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        boolean privateLayout = GetterUtil.getBoolean((String)uuid);
        try {
            return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)this._layoutSetLocalService.getLayoutSet(groupId, privateLayout), LayoutSet.class, StagedLayoutSet.class);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    public List<StagedLayoutSet> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        boolean privateLayout = GetterUtil.getBoolean((String)uuid);
        DynamicQuery dynamicQuery = this._layoutSetLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        return TransformUtil.transform((Collection)dynamicQuery.list(), layoutSet -> (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class));
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return null;
    }

    public StagedLayoutSet getStagedModel(long layoutSetId) throws PortalException {
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)this._layoutSetLocalService.getLayoutSet(layoutSetId), LayoutSet.class, StagedLayoutSet.class);
    }

    public StagedLayoutSet saveStagedModel(StagedLayoutSet stagedLayoutSet) throws PortalException {
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)this._layoutSetLocalService.updateLayoutSet(stagedLayoutSet.getLayoutSet()), LayoutSet.class, StagedLayoutSet.class);
    }

    public StagedLayoutSet updateStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws PortalException {
        boolean layoutSetSettings;
        LayoutSet layoutSet = stagedLayoutSet.getLayoutSet();
        LayoutSet existingLayoutSet = this._layoutSetLocalService.fetchLayoutSet(layoutSet.getLayoutSetId());
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        if (layoutSetPrototypeSettings && Validator.isNotNull((String)layoutSet.getLayoutSetPrototypeUuid())) {
            existingLayoutSet.setLayoutSetPrototypeUuid(layoutSet.getLayoutSetPrototypeUuid());
            existingLayoutSet.setLayoutSetPrototypeLinkEnabled(MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED"));
            existingLayoutSet = this._layoutSetLocalService.updateLayoutSet(existingLayoutSet);
        }
        if (layoutSetSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_SETTINGS")) {
            existingLayoutSet = this._layoutSetLocalService.updateSettings(existingLayoutSet.getGroupId(), existingLayoutSet.isPrivateLayout(), layoutSet.getSettings());
        }
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)existingLayoutSet, LayoutSet.class, StagedLayoutSet.class);
    }
}

