/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.helper;

import com.liferay.info.pagination.Pagination;
import com.liferay.layout.helper.CollectionPaginationHelper;
import com.liferay.portal.util.PropsValues;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(service={CollectionPaginationHelper.class})
public class CollectionPaginationHelperImpl
implements CollectionPaginationHelper {
    public Pagination getPagination(int activePage, int count, boolean displayAllPages, boolean displayAllItems, int numberOfItems, int numberOfItemsPerPage, int numberOfPages, String paginationType) {
        int end = numberOfItems;
        int start = 0;
        if (numberOfItemsPerPage <= 0 || numberOfItemsPerPage > PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA) {
            numberOfItemsPerPage = PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA;
        }
        if (this.isPaginationEnabled(paginationType)) {
            int maxNumberOfItems = count;
            if (!displayAllPages && numberOfPages > 0) {
                maxNumberOfItems = numberOfPages * numberOfItemsPerPage;
            }
            end = Math.min(Math.min(activePage * numberOfItemsPerPage, maxNumberOfItems), count);
            start = (activePage - 1) * numberOfItemsPerPage;
        } else if (displayAllItems) {
            end = count;
        }
        return Pagination.of((int)end, (int)start);
    }

    public int getTotalNumberOfItems(int count, boolean displayAllPages, boolean displayAllItems, int numberOfItems, int numberOfItemsPerPage, int numberOfPages, String paginationType) {
        if (!this.isPaginationEnabled(paginationType)) {
            if (displayAllItems) {
                return count;
            }
            return Math.min(count, numberOfItems);
        }
        if (displayAllPages || numberOfPages <= 0) {
            return count;
        }
        if (numberOfItemsPerPage <= 0 || numberOfItemsPerPage > PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA) {
            numberOfItemsPerPage = PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA;
        }
        return Math.min(count, numberOfPages * numberOfItemsPerPage);
    }

    public boolean isPaginationEnabled(String paginationType) {
        return Objects.equals(paginationType, "numeric") || Objects.equals(paginationType, "regular") || Objects.equals(paginationType, "simple");
    }
}

