/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.fragment.listener.FragmentEntryLinkListener;
import com.liferay.fragment.listener.FragmentEntryLinkListenerRegistry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.headless.delivery.dto.v1_0.ContentSubtype;
import com.liferay.headless.delivery.dto.v1_0.ContentType;
import com.liferay.headless.delivery.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.delivery.dto.v1_0.MasterPage;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.PageTemplate;
import com.liferay.headless.delivery.dto.v1_0.PageTemplateCollection;
import com.liferay.headless.delivery.dto.v1_0.Settings;
import com.liferay.headless.delivery.dto.v1_0.StyleBook;
import com.liferay.headless.delivery.dto.v1_0.UtilityPageTemplate;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.importer.LayoutsImporter;
import com.liferay.layout.importer.LayoutsImporterResultEntry;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.exception.DropzoneLayoutStructureItemException;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.internal.importer.validator.DisplayPageTemplateValidator;
import com.liferay.layout.internal.importer.validator.MasterPageValidator;
import com.liferay.layout.internal.importer.validator.PageDefinitionValidator;
import com.liferay.layout.internal.importer.validator.PageTemplateCollectionValidator;
import com.liferay.layout.internal.importer.validator.PageTemplateValidator;
import com.liferay.layout.internal.importer.validator.UtilityPageTemplateValidator;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.utility.page.converter.LayoutUtilityPageEntryTypeConverter;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryLocalService;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryService;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.json.validator.JSONValidatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutsImporter.class})
public class LayoutsImporterImpl
implements LayoutsImporter {
    private static final String _DISPLAY_PAGE_TEMPLATE_ENTRY_KEY_DEFAULT = "imported-display-page-template";
    private static final String _MASTER_PAGE_ENTRY_KEY_DEFAULT = "imported-master-page";
    private static final String _MESSAGE_KEY_IGNORED = "x-was-ignored-because-a-x-with-the-same-key-already-exists";
    private static final String _MESSAGE_KEY_INVALID = "x-could-not-be-imported-because-a-x-with-the-same-name-already-exists";
    private static final String _PAGE_TEMPLATE_COLLECTION_KEY_DEFAULT = "imported";
    private static final String _PAGE_TEMPLATE_ENTRY_KEY_DEFAULT = "imported";
    private static final String _THUMBNAIL_FILE_NAME = "thumbnail";
    private static final String[] _THUMBNAIL_VALID_EXTENSIONS = new String[]{".bmp", ".gif", ".jpeg", ".jpg", ".png", ".svg", ".tiff"};
    private static final String _UTILITY_PAGE_TEMPLATE_ENTRY_KEY_DEFAULT = "imported-utility-page";
    private static final Log _log = LogFactoryUtil.getLog(LayoutsImporterImpl.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private FragmentEntryLinkListenerRegistry _fragmentEntryLinkListenerRegistry;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private Language _language;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateCollectionService _layoutPageTemplateCollectionService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    private List<LayoutsImporterResultEntry> _layoutsImporterResultEntries;
    @Reference
    private LayoutUtilityPageEntryLocalService _layoutUtilityPageEntryLocalService;
    @Reference
    private LayoutUtilityPageEntryService _layoutUtilityPageEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    private ServiceTrackerMap<PageElement.Type, LayoutStructureItemImporter> _serviceTrackerMap;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;
    @Reference
    private ThemeLocalService _themeLocalService;

    public void importFile(long userId, long groupId, File file, boolean overwrite) throws Exception {
        this.importFile(userId, groupId, 0L, file, overwrite);
    }

    public List<LayoutsImporterResultEntry> importFile(long userId, long groupId, long layoutPageTemplateCollectionId, File file, boolean overwrite) throws Exception {
        block14: {
            this._layoutsImporterResultEntries = new ArrayList<LayoutsImporterResultEntry>();
            try (ZipFile zipFile = new ZipFile(file);){
                this._processMasterLayoutPageTemplateEntries(groupId, overwrite, userId, zipFile);
                this._processLayoutUtilityPageEntries(groupId, overwrite, userId, zipFile);
                this._processDisplayPageTemplatePageTemplateEntries(groupId, overwrite, userId, zipFile);
                this._processBasicLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, overwrite, userId, zipFile);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Throwable)portalException);
                throw portalException;
            }
        }
        return this._layoutsImporterResultEntries;
    }

    public List<FragmentEntryLink> importPageElement(Layout layout, LayoutStructure layoutStructure, String parentItemId, String pageElementJSON, int position) throws Exception {
        Consumer<LayoutStructure> consumer = processedLayoutStructure -> {
            block2: {
                try {
                    this._updateLayoutPageTemplateStructure(layout, (LayoutStructure)processedLayoutStructure);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Throwable)exception);
                }
            }
        };
        long segmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid());
        return this._importPageElement(consumer, layout, layoutStructure, parentItemId, pageElementJSON, position, segmentsExperienceId);
    }

    public List<FragmentEntryLink> importPageElement(Layout layout, LayoutStructure layoutStructure, String parentItemId, String pageElementJSON, int position, long segmentsExperienceId) throws Exception {
        Consumer<LayoutStructure> consumer = processedLayoutStructure -> {
            block2: {
                try {
                    this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(layout.getGroupId(), layout.getPlid(), segmentsExperienceId, processedLayoutStructure.toString());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Throwable)exception);
                }
            }
        };
        return this._importPageElement(consumer, layout, layoutStructure, parentItemId, pageElementJSON, position, segmentsExperienceId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, LayoutStructureItemImporter.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.createFromFunction((BundleContext)bundleContext, LayoutStructureItemImporter::getPageElementType));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _deleteExistingPortletPreferences(long plid) {
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, plid);
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            this._portletPreferencesLocalService.deletePortletPreferences(portletPreferences);
        }
    }

    private PageTemplateCollectionEntry _getDefaultPageTemplateCollectionEntry() {
        PageTemplateCollection pageTemplateCollection = new PageTemplateCollection(){
            {
                this.name = "imported";
            }
        };
        return new PageTemplateCollectionEntry("imported", pageTemplateCollection);
    }

    private List<DisplayPageTemplateEntry> _getDisplayPageTemplateEntries(long groupId, ZipFile zipFile) throws Exception {
        ArrayList<DisplayPageTemplateEntry> displayPageTemplateEntries = new ArrayList<DisplayPageTemplateEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry == null || !this._isDisplayPageTemplateFile(zipEntry.getName())) continue;
            String content = StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
            DisplayPageTemplate displayPageTemplate = null;
            try {
                DisplayPageTemplateValidator.validateDisplayPageTemplate(content);
                displayPageTemplate = (DisplayPageTemplate)_objectMapper.readValue(content, DisplayPageTemplate.class);
            }
            catch (JSONValidatorException jsonValidatorException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid display page template for: " + zipEntry.getName()), (Throwable)jsonValidatorException);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(zipEntry.getName(), 1, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-display-page-template-is-invalid", new String[]{zipEntry.getName()})));
                continue;
            }
            try {
                String pageDefinitionJSON = this._getPageDefinitionJSON(zipEntry.getName(), zipFile);
                PageDefinitionValidator.validatePageDefinition(pageDefinitionJSON);
                displayPageTemplateEntries.add(new DisplayPageTemplateEntry(displayPageTemplate, this._getKey(_DISPLAY_PAGE_TEMPLATE_ENTRY_KEY_DEFAULT, displayPageTemplate.getName(), zipEntry), (PageDefinition)_objectMapper.readValue(pageDefinitionJSON, PageDefinition.class), this._getThumbnailZipEntry(zipEntry.getName(), zipFile), zipEntry.getName()));
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid page definition for: " + displayPageTemplate.getName()), (Throwable)exception);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(displayPageTemplate.getName(), 1, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-page-definition-is-invalid", new String[]{zipEntry.getName()})));
            }
        }
        return displayPageTemplateEntries;
    }

    private String _getErrorMessage(long groupId, String languageKey, String[] arguments) throws PortalException {
        Locale locale = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        locale = serviceContext != null ? serviceContext.getLocale() : this._portal.getSiteDefaultLocale(groupId);
        return this._language.format(locale, languageKey, (Object[])arguments);
    }

    private String _getKey(String defaultKey, String name, ZipEntry zipEntry) {
        String[] pathParts = StringUtil.split((String)zipEntry.getName(), (char)'/');
        String key = defaultKey;
        if (Validator.isNotNull((String)name)) {
            key = name;
        }
        if (pathParts.length > 1) {
            key = pathParts[pathParts.length - 2];
        }
        key = StringUtil.replace((String)key, (char)' ', (char)'-');
        key = StringUtil.toLowerCase((String)key);
        return key;
    }

    private LayoutPageTemplateCollection _getLayoutPageTemplateCollection(long groupId, long layoutPageTemplateCollectionId, PageTemplateCollectionEntry pageTemplateCollectionEntry, boolean overwrite) throws Exception {
        LayoutPageTemplateCollection layoutPageTemplateCollection = null;
        if (layoutPageTemplateCollectionId > 0L) {
            layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.fetchLayoutPageTemplateCollection(layoutPageTemplateCollectionId);
            if (layoutPageTemplateCollection == null) {
                throw new PortalException("Invalid layout page template collection ID: " + layoutPageTemplateCollectionId);
            }
            return layoutPageTemplateCollection;
        }
        String layoutPageTemplateCollectionKey = pageTemplateCollectionEntry.getKey();
        PageTemplateCollection pageTemplateCollection = pageTemplateCollectionEntry.getPageTemplateCollection();
        layoutPageTemplateCollection = this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(groupId, layoutPageTemplateCollectionKey);
        if (layoutPageTemplateCollection == null && (layoutPageTemplateCollection = this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollectionByName(groupId, pageTemplateCollection.getName())) == null) {
            return this._layoutPageTemplateCollectionService.addLayoutPageTemplateCollection(groupId, pageTemplateCollection.getName(), pageTemplateCollection.getDescription(), ServiceContextThreadLocal.getServiceContext());
        }
        if (overwrite) {
            return this._layoutPageTemplateCollectionService.updateLayoutPageTemplateCollection(layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), pageTemplateCollection.getName(), pageTemplateCollection.getDescription());
        }
        if (layoutPageTemplateCollection == null) {
            throw new PortalException("Invalid layout page template collection ID: " + layoutPageTemplateCollectionId);
        }
        return layoutPageTemplateCollection;
    }

    private List<UtilityPageTemplateEntry> _getLayoutUtilityPageEntries(long groupId, ZipFile zipFile) throws Exception {
        ArrayList<UtilityPageTemplateEntry> utilityPageTemplateEntries = new ArrayList<UtilityPageTemplateEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry == null || !this._isUtilityPageTemplateFile(zipEntry.getName())) continue;
            String content = StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
            UtilityPageTemplate utilityPageTemplate = null;
            try {
                UtilityPageTemplateValidator.validateUtilityPageTemplate(content);
                utilityPageTemplate = (UtilityPageTemplate)_objectMapper.readValue(content, UtilityPageTemplate.class);
            }
            catch (JSONValidatorException jsonValidatorException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid utility page template for: " + zipEntry.getName()), (Throwable)jsonValidatorException);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(zipEntry.getName(), LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-utility-page-is-invalid", new String[]{zipEntry.getName()})));
                continue;
            }
            try {
                String pageDefinitionJSON = this._getPageDefinitionJSON(zipEntry.getName(), zipFile);
                PageDefinitionValidator.validatePageDefinition(pageDefinitionJSON);
                utilityPageTemplateEntries.add(new UtilityPageTemplateEntry(utilityPageTemplate, this._getKey(_UTILITY_PAGE_TEMPLATE_ENTRY_KEY_DEFAULT, utilityPageTemplate.getName(), zipEntry), (PageDefinition)_objectMapper.readValue(pageDefinitionJSON, PageDefinition.class), this._getThumbnailZipEntry(zipEntry.getName(), zipFile), zipEntry.getName()));
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid page definition for: " + utilityPageTemplate.getName()), (Throwable)exception);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(utilityPageTemplate.getName(), LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-page-definition-is-invalid", new String[]{zipEntry.getName()})));
            }
        }
        return utilityPageTemplateEntries;
    }

    private List<MasterPageEntry> _getMasterPageEntries(long groupId, ZipFile zipFile) throws Exception {
        ArrayList<MasterPageEntry> masterPageEntries = new ArrayList<MasterPageEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry == null || !this._isMasterPageFile(zipEntry.getName())) continue;
            String content = StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
            MasterPage masterPage = null;
            try {
                MasterPageValidator.validateMasterPage(content);
                masterPage = (MasterPage)_objectMapper.readValue(content, MasterPage.class);
            }
            catch (JSONValidatorException jsonValidatorException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid master page for: " + zipEntry.getName()), (Throwable)jsonValidatorException);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(zipEntry.getName(), 3, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-master-page-is-invalid", new String[]{zipEntry.getName()})));
                continue;
            }
            try {
                String pageDefinitionJSON = this._getPageDefinitionJSON(zipEntry.getName(), zipFile);
                PageDefinitionValidator.validatePageDefinition(pageDefinitionJSON);
                masterPageEntries.add(new MasterPageEntry(this._getKey(_MASTER_PAGE_ENTRY_KEY_DEFAULT, masterPage.getName(), zipEntry), masterPage, (PageDefinition)_objectMapper.readValue(pageDefinitionJSON, PageDefinition.class), this._getThumbnailZipEntry(zipEntry.getName(), zipFile), zipEntry.getName()));
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid page definition for: " + masterPage.getName()), (Throwable)exception);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(masterPage.getName(), 3, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-page-definition-is-invalid", new String[]{zipEntry.getName()})));
            }
        }
        return masterPageEntries;
    }

    private String _getPageDefinitionJSON(String fileName, ZipFile zipFile) throws IOException {
        String path = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        ZipEntry zipEntry = zipFile.getEntry(path + "page-definition.json");
        if (zipEntry == null) {
            return null;
        }
        return StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
    }

    private Map<String, PageTemplateCollectionEntry> _getPageTemplateCollectionEntryMap(long groupId, ZipFile zipFile) throws Exception {
        ZipEntry zipEntry;
        HashMap<String, PageTemplateCollectionEntry> pageTemplateCollectionMap = new HashMap<String, PageTemplateCollectionEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry == null || !this._isPageTemplateCollectionFile(zipEntry.getName())) continue;
            String[] pathParts = StringUtil.split((String)zipEntry.getName(), (char)'/');
            String pageTemplateCollectionKey = "imported";
            if (pathParts.length > 1) {
                pageTemplateCollectionKey = pathParts[pathParts.length - 2];
            }
            String content = StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
            PageTemplateCollectionValidator.validatePageTemplateCollection(content);
            PageTemplateCollection pageTemplateCollection = (PageTemplateCollection)_objectMapper.readValue(content, PageTemplateCollection.class);
            pageTemplateCollectionMap.put(pageTemplateCollectionKey, new PageTemplateCollectionEntry(pageTemplateCollectionKey, pageTemplateCollection));
        }
        enumeration = zipFile.entries();
        if (MapUtil.isEmpty(pageTemplateCollectionMap)) {
            pageTemplateCollectionMap.put("imported", this._getDefaultPageTemplateCollectionEntry());
        }
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry == null || !this._isPageTemplateFile(zipEntry.getName())) continue;
            String content = StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
            PageTemplate pageTemplate = null;
            try {
                PageTemplateValidator.validatePageTemplate(content);
                pageTemplate = (PageTemplate)_objectMapper.readValue(content, PageTemplate.class);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid page template for: " + zipEntry.getName()), (Throwable)exception);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(zipEntry.getName(), 0, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-page-template-is-invalid", new String[]{zipEntry.getName()})));
                continue;
            }
            PageTemplateCollectionEntry pageTemplateCollectionEntry = (PageTemplateCollectionEntry)pageTemplateCollectionMap.get(this._getPageTemplateCollectionKey(zipEntry.getName(), zipFile));
            try {
                String pageDefinitionJSON = this._getPageDefinitionJSON(zipEntry.getName(), zipFile);
                PageDefinitionValidator.validatePageDefinition(pageDefinitionJSON);
                PageDefinition pageDefinition = (PageDefinition)_objectMapper.readValue(pageDefinitionJSON, PageDefinition.class);
                pageTemplateCollectionEntry.addPageTemplateEntry(this._getKey("imported", pageTemplate.getName(), zipEntry), new PageTemplateEntry(pageTemplate, pageDefinition, this._getThumbnailZipEntry(zipEntry.getName(), zipFile), zipEntry.getName()));
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid page definition for: " + pageTemplate.getName()), (Throwable)exception);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(pageTemplate.getName(), 0, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-its-page-definition-is-invalid", new String[]{zipEntry.getName()})));
            }
        }
        return pageTemplateCollectionMap;
    }

    private String _getPageTemplateCollectionKey(String fileName, ZipFile zipFile) {
        if (fileName.lastIndexOf(47) == -1) {
            return "imported";
        }
        String path = fileName.substring(0, fileName.lastIndexOf("/"));
        ZipEntry zipEntry = zipFile.getEntry(path + '/' + "page-template-collection.json");
        if (zipEntry == null) {
            return this._getPageTemplateCollectionKey(path, zipFile);
        }
        int pos = path.lastIndexOf(47);
        String layoutPageTemplateCollectionKey = path.substring(pos + 1);
        if (Validator.isNotNull((String)layoutPageTemplateCollectionKey)) {
            return layoutPageTemplateCollectionKey;
        }
        return "imported";
    }

    private long _getPreviewFileEntryId(String className, long classPK, long groupId, long userId, ZipEntry zipEntry, ZipFile zipFile) throws Exception {
        if (zipEntry == null) {
            return 0L;
        }
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, "com_liferay_layout_admin_web_portlet_GroupPagesPortlet");
        if (repository == null) {
            repository = this._portletFileRepository.addPortletRepository(groupId, "com_liferay_layout_admin_web_portlet_GroupPagesPortlet", ServiceContextThreadLocal.getServiceContext());
        }
        String imageFileName = classPK + "_preview." + FileUtil.getExtension((String)zipEntry.getName());
        byte[] bytes = null;
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            bytes = FileUtil.getBytes((InputStream)inputStream);
        }
        FileEntry fileEntry = this._portletFileRepository.fetchPortletFileEntry(groupId, repository.getDlFolderId(), imageFileName);
        if (fileEntry != null) {
            this._portletFileRepository.deletePortletFileEntry(fileEntry.getFileEntryId());
        }
        fileEntry = this._portletFileRepository.addPortletFileEntry(groupId, userId, className, classPK, "com_liferay_layout_admin_web_portlet_GroupPagesPortlet", repository.getDlFolderId(), bytes, imageFileName, MimeTypesUtil.getContentType((String)imageFileName), false);
        return fileEntry.getFileEntryId();
    }

    private String _getThemeId(long companyId, String themeName) {
        List themes = ListUtil.filter((List)this._themeLocalService.getThemes(companyId), theme -> Objects.equals(theme.getName(), themeName));
        if (ListUtil.isNotEmpty((List)themes)) {
            Theme theme2 = (Theme)themes.get(0);
            return theme2.getThemeId();
        }
        return null;
    }

    private ZipEntry _getThumbnailZipEntry(String fileName, ZipFile zipFile) {
        String path = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        for (String thumbnailExtension : _THUMBNAIL_VALID_EXTENSIONS) {
            ZipEntry zipEntry = zipFile.getEntry(path + _THUMBNAIL_FILE_NAME + thumbnailExtension);
            if (zipEntry == null) continue;
            return zipEntry;
        }
        return null;
    }

    private List<FragmentEntryLink> _importPageElement(Consumer<LayoutStructure> consumer, Layout layout, LayoutStructure layoutStructure, String parentItemId, String pageElementJSON, int position, long segmentsExperienceId) throws Exception {
        PageElement pageElement = (PageElement)_objectMapper.readValue(pageElementJSON, PageElement.class);
        ArrayList<FragmentEntryLink> fragmentEntryLinks = new ArrayList<FragmentEntryLink>();
        this._processPageElement(fragmentEntryLinks, layout, layoutStructure, 1.1, pageElement, parentItemId, position, segmentsExperienceId, new HashSet<String>());
        consumer.accept(layoutStructure);
        return fragmentEntryLinks;
    }

    private boolean _isDisplayPageTemplateFile(String fileName) {
        return fileName.endsWith("/display-page-template.json");
    }

    private boolean _isMasterPageFile(String fileName) {
        return fileName.endsWith("/master-page.json");
    }

    private boolean _isPageTemplateCollectionFile(String fileName) {
        return fileName.endsWith("/page-template-collection.json");
    }

    private boolean _isPageTemplateFile(String fileName) {
        return fileName.endsWith("/page-template.json");
    }

    private boolean _isUtilityPageTemplateFile(String fileName) {
        return fileName.endsWith("/utility-page.json");
    }

    private void _processBasicLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, boolean overwrite, long userId, ZipFile zipFile) throws Exception {
        Map<String, PageTemplateCollectionEntry> pageTemplateCollectionEntryMap = this._getPageTemplateCollectionEntryMap(groupId, zipFile);
        for (Map.Entry<String, PageTemplateCollectionEntry> entry : pageTemplateCollectionEntryMap.entrySet()) {
            PageTemplateCollectionEntry pageTemplateCollectionEntry = entry.getValue();
            Map<String, PageTemplateEntry> pageTemplatesEntries = pageTemplateCollectionEntry.getPageTemplatesEntries();
            if (MapUtil.isEmpty(pageTemplatesEntries)) continue;
            LayoutPageTemplateCollection layoutPageTemplateCollection = this._getLayoutPageTemplateCollection(groupId, layoutPageTemplateCollectionId, pageTemplateCollectionEntry, overwrite);
            this._processPageTemplateEntries(groupId, layoutPageTemplateCollection, pageTemplatesEntries, overwrite, userId, zipFile);
        }
    }

    private void _processDisplayPageTemplatePageTemplateEntries(long groupId, boolean overwrite, long userId, ZipFile zipFile) throws Exception {
        List<DisplayPageTemplateEntry> displayPageTemplateEntries = this._getDisplayPageTemplateEntries(groupId, zipFile);
        for (DisplayPageTemplateEntry displayPageTemplateEntry : displayPageTemplateEntries) {
            DisplayPagesImporterCallable callable = new DisplayPagesImporterCallable(groupId, displayPageTemplateEntry, overwrite, userId, zipFile);
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            }
            catch (Throwable throwable) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)throwable, throwable);
                }
                DisplayPageTemplate displayPageTemplate = displayPageTemplateEntry.getDisplayPageTemplate();
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(displayPageTemplate.getName(), 1, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-of-invalid-values-in-its-page-definition", new String[]{displayPageTemplate.getName()})));
            }
        }
    }

    private LayoutPageTemplateEntry _processLayoutPageTemplateEntry(long classNameId, long classTypeId, long groupId, long layoutPageTemplateCollectionId, LayoutPageTemplateEntry layoutPageTemplateEntry, String name, PageDefinition pageDefinition, int layoutPageTemplateEntryType, boolean overwrite, long userId, ZipEntry thumbnailZipEntry, String zipPath, ZipFile zipFile) throws Exception {
        try {
            boolean added = false;
            if (layoutPageTemplateEntry == null) {
                layoutPageTemplateEntry = classNameId == 0L ? this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(groupId, layoutPageTemplateCollectionId, name, layoutPageTemplateEntryType, 0L, 0, ServiceContextThreadLocal.getServiceContext()) : this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(groupId, layoutPageTemplateCollectionId, classNameId, classTypeId, name, 0L, 0, ServiceContextThreadLocal.getServiceContext());
                added = true;
            } else if (overwrite) {
                this._deleteExistingPortletPreferences(layoutPageTemplateEntry.getPlid());
                layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), name);
                added = true;
            }
            if (added) {
                HashSet<String> warningMessages = new HashSet<String>();
                this._processPageDefinition(layoutPageTemplateEntry.getPlid(), pageDefinition, warningMessages);
                long previewFileEntryId = this._getPreviewFileEntryId(LayoutPageTemplateEntry.class.getName(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), groupId, userId, thumbnailZipEntry, zipFile);
                layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), previewFileEntryId);
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(name, layoutPageTemplateEntryType, LayoutsImporterResultEntry.Status.IMPORTED, warningMessages.toArray(new String[0])));
            } else {
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(name, layoutPageTemplateEntryType, LayoutsImporterResultEntry.Status.IGNORED, this._getErrorMessage(groupId, _MESSAGE_KEY_IGNORED, new String[]{zipPath, this._toTypeName(layoutPageTemplateEntryType)})));
            }
        }
        catch (DropzoneLayoutStructureItemException dropzoneLayoutStructureItemException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)((Object)dropzoneLayoutStructureItemException));
            }
            throw new PortalException();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(name, layoutPageTemplateEntryType, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, _MESSAGE_KEY_INVALID, new String[]{zipPath, this._toTypeName(layoutPageTemplateEntryType)})));
            return null;
        }
        return layoutPageTemplateEntry;
    }

    private void _processLayoutUtilityPageEntries(long groupId, boolean overwrite, long userId, ZipFile zipFile) throws Exception {
        List<UtilityPageTemplateEntry> utilityPageTemplateEntries = this._getLayoutUtilityPageEntries(groupId, zipFile);
        for (UtilityPageTemplateEntry utilityPageTemplateEntry : utilityPageTemplateEntries) {
            UtilityPageImporterCallable callable = new UtilityPageImporterCallable(groupId, utilityPageTemplateEntry, overwrite, userId, zipFile);
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            }
            catch (Throwable throwable) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)throwable, throwable);
                }
                UtilityPageTemplate utilityPageTemplate = utilityPageTemplateEntry.getUtilityPageTemplate();
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(utilityPageTemplate.getName(), LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-of-invalid-values-in-its-page-definition", new String[]{utilityPageTemplate.getName()})));
            }
        }
    }

    private void _processLayoutUtilityPageTemplateEntry(String externalReferenceCode, long groupId, LayoutUtilityPageEntry layoutUtilityPageEntry, String name, PageDefinition pageDefinition, String type, boolean overwrite, long userId, ZipEntry thumbnailZipEntry, String zipPath, ZipFile zipFile) throws Exception {
        try {
            boolean added = false;
            if (layoutUtilityPageEntry == null) {
                layoutUtilityPageEntry = this._layoutUtilityPageEntryService.addLayoutUtilityPageEntry(externalReferenceCode, groupId, 0L, 0L, false, name, type, 0L, ServiceContextThreadLocal.getServiceContext());
                added = true;
            } else if (overwrite) {
                this._deleteExistingPortletPreferences(layoutUtilityPageEntry.getPlid());
                layoutUtilityPageEntry = this._layoutUtilityPageEntryService.updateLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), name);
                added = true;
            }
            if (added) {
                HashSet<String> warningMessages = new HashSet<String>();
                this._processPageDefinition(layoutUtilityPageEntry.getPlid(), pageDefinition, warningMessages);
                long previewFileEntryId = this._getPreviewFileEntryId(LayoutUtilityPageEntry.class.getName(), layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), groupId, userId, thumbnailZipEntry, zipFile);
                if (previewFileEntryId > 0L) {
                    this._layoutUtilityPageEntryService.updateLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), previewFileEntryId);
                }
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(name, LayoutsImporterResultEntry.Status.IMPORTED, warningMessages.toArray(new String[0])));
            } else {
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(name, LayoutsImporterResultEntry.Status.IGNORED, this._getErrorMessage(groupId, _MESSAGE_KEY_IGNORED, new String[]{zipPath, "utility page"})));
            }
        }
        catch (DropzoneLayoutStructureItemException dropzoneLayoutStructureItemException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)((Object)dropzoneLayoutStructureItemException));
            }
            throw new PortalException();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(name, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, _MESSAGE_KEY_INVALID, new String[]{zipPath, "utility page"})));
        }
    }

    private void _processMasterLayoutPageTemplateEntries(long groupId, boolean overwrite, long userId, ZipFile zipFile) throws Exception {
        List<MasterPageEntry> masterPageEntries = this._getMasterPageEntries(groupId, zipFile);
        for (MasterPageEntry masterPageEntry : masterPageEntries) {
            MasterLayoutTemplatesImporterCallable callable = new MasterLayoutTemplatesImporterCallable(groupId, masterPageEntry, overwrite, userId, zipFile);
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            }
            catch (Throwable throwable) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)throwable, throwable);
                }
                MasterPage masterPage = masterPageEntry.getMasterPage();
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(masterPage.getName(), 3, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-of-invalid-values-in-its-page-definition", new String[]{masterPage.getName()})));
            }
        }
    }

    private void _processPageDefinition(long plid, PageDefinition pageDefinition, Set<String> warningMessages) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(plid);
        LayoutStructure layoutStructure = new LayoutStructure();
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.addRootLayoutStructureItem();
        if (pageDefinition != null) {
            PageElement pageElement = pageDefinition.getPageElement();
            if (pageElement.getType() == PageElement.Type.ROOT && pageElement.getPageElements() != null) {
                double pageDefinitionVersion = GetterUtil.getDouble((Object)pageDefinition.getVersion(), (double)1.0);
                int position = 0;
                for (PageElement childPageElement : pageElement.getPageElements()) {
                    if (!this._processPageElement(new ArrayList<FragmentEntryLink>(), layout, layoutStructure, pageDefinitionVersion, childPageElement, rootLayoutStructureItem.getItemId(), position, this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid()), warningMessages)) continue;
                    ++position;
                }
            }
            Settings settings = pageDefinition.getSettings();
            layout = this._layoutLocalService.fetchLayout(layout.getPlid());
            this._updateLayoutSettings(layout, settings);
        }
        this._updateLayoutPageTemplateStructure(layout, layoutStructure);
        this._updateLayouts(plid);
    }

    private boolean _processPageElement(List<FragmentEntryLink> fragmentEntryLinks, Layout layout, LayoutStructure layoutStructure, double pageDefinitionVersion, PageElement pageElement, String parentItemId, int position, long segmentsExperienceId, Set<String> warningMessages) throws Exception {
        LayoutStructureItemImporter layoutStructureItemImporter = (LayoutStructureItemImporter)this._serviceTrackerMap.getService((Object)pageElement.getType());
        LayoutStructureItem layoutStructureItem = null;
        if (layoutStructureItemImporter != null) {
            layoutStructureItem = layoutStructureItemImporter.addLayoutStructureItem(layoutStructure, new LayoutStructureItemImporterContext(layout, pageDefinitionVersion, parentItemId, position, segmentsExperienceId), pageElement, warningMessages);
        } else if (pageElement.getType() == PageElement.Type.ROOT) {
            layoutStructureItem = layoutStructure.getMainLayoutStructureItem();
        } else {
            return false;
        }
        if (layoutStructureItem == null) {
            return false;
        }
        if (layoutStructureItem instanceof FragmentStyledLayoutStructureItem) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem;
            fragmentEntryLinks.add(this._fragmentEntryLinkLocalService.getFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId()));
        }
        if (pageElement.getPageElements() == null) {
            return true;
        }
        int childPosition = 0;
        for (PageElement childPageElement : pageElement.getPageElements()) {
            if (!this._processPageElement(fragmentEntryLinks, layout, layoutStructure, pageDefinitionVersion, childPageElement, layoutStructureItem.getItemId(), childPosition, segmentsExperienceId, warningMessages)) continue;
            ++childPosition;
        }
        return true;
    }

    private void _processPageTemplateEntries(long groupId, LayoutPageTemplateCollection layoutPageTemplateCollection, Map<String, PageTemplateEntry> pageTemplateEntryMap, boolean overwrite, long userId, ZipFile zipFile) throws Exception {
        for (Map.Entry<String, PageTemplateEntry> entry : pageTemplateEntryMap.entrySet()) {
            PageTemplateEntry pageTemplateEntry = entry.getValue();
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(groupId, entry.getKey());
            BasicLayoutsImporterCallable callable = new BasicLayoutsImporterCallable(groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), layoutPageTemplateEntry, overwrite, userId, pageTemplateEntry, zipFile);
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            }
            catch (Throwable throwable) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)throwable, throwable);
                }
                PageTemplate pageTemplate = pageTemplateEntry.getPageTemplate();
                this._layoutsImporterResultEntries.add(new LayoutsImporterResultEntry(pageTemplate.getName(), 3, LayoutsImporterResultEntry.Status.INVALID, this._getErrorMessage(groupId, "x-could-not-be-imported-because-of-invalid-values-in-its-page-definition", new String[]{pageTemplate.getName()})));
            }
        }
    }

    private String _toTypeName(int layoutPageTemplateEntryType) {
        if (layoutPageTemplateEntryType == 1) {
            return "display page template";
        }
        if (layoutPageTemplateEntryType == 3) {
            return "master page";
        }
        if (layoutPageTemplateEntryType == 0) {
            return "page template";
        }
        return null;
    }

    private void _updateLayoutPageTemplateStructure(Layout layout, LayoutStructure layoutStructure) throws Exception {
        JSONObject jsonObject = layoutStructure.toJSONObject();
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        if (layoutPageTemplateStructure != null) {
            this._layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(layoutPageTemplateStructure);
        }
        this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(layout.getUserId(), layout.getGroupId(), layout.getPlid(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid()), jsonObject.toString(), ServiceContextThreadLocal.getServiceContext());
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(layout.getGroupId(), layout.getPlid())) {
            for (FragmentEntryLinkListener fragmentEntryLinkListener : this._fragmentEntryLinkListenerRegistry.getFragmentEntryLinkListeners()) {
                fragmentEntryLinkListener.onAddFragmentEntryLink(fragmentEntryLink);
            }
        }
    }

    private void _updateLayouts(long plid) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        Layout draftLayout = layout.fetchDraftLayout();
        draftLayout = this._layoutCopyHelper.copyLayoutContent(layout, draftLayout);
        this._layoutLocalService.updateStatus(draftLayout.getUserId(), draftLayout.getPlid(), 0, ServiceContextThreadLocal.getServiceContext());
    }

    private void _updateLayoutSettings(Layout layout, Settings settings) {
        StyleBookEntry styleBookEntry;
        StyleBook styleBook;
        LayoutPageTemplateEntry masterLayoutPageTemplateEntry;
        MasterPage masterPage;
        if (settings == null) {
            layout.setThemeId(null);
            layout.setColorSchemeId(null);
            this._layoutLocalService.updateLayout(layout);
            return;
        }
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        Map themeSettings = (Map)settings.getThemeSettings();
        Set entrySet = unicodeProperties.entrySet();
        entrySet.removeIf(entry -> {
            String key = (String)entry.getKey();
            return key.startsWith("lfr-theme:");
        });
        if (themeSettings != null) {
            for (Map.Entry entry2 : themeSettings.entrySet()) {
                unicodeProperties.put((String)entry2.getKey(), (String)entry2.getValue());
            }
            layout.setTypeSettingsProperties(unicodeProperties);
        }
        if (Validator.isNotNull((String)settings.getThemeName())) {
            String themeId = this._getThemeId(layout.getCompanyId(), settings.getThemeName());
            layout.setThemeId(themeId);
        }
        if (Validator.isNotNull((String)settings.getColorSchemeName())) {
            layout.setColorSchemeId(settings.getColorSchemeName());
        }
        if (Validator.isNotNull((String)settings.getCss())) {
            layout.setCss(settings.getCss());
        }
        if ((masterPage = settings.getMasterPage()) != null && (masterLayoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layout.getGroupId(), masterPage.getKey())) != null) {
            layout.setMasterLayoutPlid(masterLayoutPageTemplateEntry.getPlid());
        }
        if ((styleBook = settings.getStyleBook()) != null && (styleBookEntry = this._styleBookEntryLocalService.fetchStyleBookEntry(layout.getGroupId(), styleBook.getKey())) != null) {
            layout.setStyleBookEntryId(styleBookEntry.getStyleBookEntryId());
        }
        this._layoutLocalService.updateLayout(layout);
    }

    private class UtilityPageImporterCallable
    implements Callable<Void> {
        private final long _groupId;
        private final boolean _overwrite;
        private final long _userId;
        private final UtilityPageTemplateEntry _utilityPageTemplateEntry;
        private final ZipFile _zipFile;

        @Override
        public Void call() throws Exception {
            UtilityPageTemplate utilityPageTemplate = this._utilityPageTemplateEntry.getUtilityPageTemplate();
            LayoutUtilityPageEntry layoutUtilityPageEntry = LayoutsImporterImpl.this._layoutUtilityPageEntryLocalService.fetchLayoutUtilityPageEntryByExternalReferenceCode(utilityPageTemplate.getExternalReferenceCode(), this._groupId);
            LayoutsImporterImpl.this._processLayoutUtilityPageTemplateEntry(utilityPageTemplate.getExternalReferenceCode(), this._groupId, layoutUtilityPageEntry, utilityPageTemplate.getName(), this._utilityPageTemplateEntry.getPageDefinition(), LayoutUtilityPageEntryTypeConverter.convertToInternalValue((String)utilityPageTemplate.getTypeAsString()), this._overwrite, this._userId, this._utilityPageTemplateEntry.getThumbnailZipEntry(), this._utilityPageTemplateEntry.getZipPath(), this._zipFile);
            return null;
        }

        private UtilityPageImporterCallable(long groupId, UtilityPageTemplateEntry utilityPageTemplateEntry, boolean overwrite, long userId, ZipFile zipFile) {
            this._groupId = groupId;
            this._utilityPageTemplateEntry = utilityPageTemplateEntry;
            this._overwrite = overwrite;
            this._userId = userId;
            this._zipFile = zipFile;
        }
    }

    private class PageTemplateEntry {
        private final PageDefinition _pageDefinition;
        private final PageTemplate _pageTemplate;
        private final ZipEntry _thumbnailZipEntry;
        private final String _zipPath;

        public PageTemplateEntry(PageTemplate pageTemplate, PageDefinition pageDefinition, ZipEntry thumbnailZipEntry, String zipPath) {
            this._pageTemplate = pageTemplate;
            this._pageDefinition = pageDefinition;
            this._thumbnailZipEntry = thumbnailZipEntry;
            this._zipPath = zipPath;
        }

        public PageDefinition getPageDefinition() {
            return this._pageDefinition;
        }

        public PageTemplate getPageTemplate() {
            return this._pageTemplate;
        }

        public ZipEntry getThumbnailZipEntry() {
            return this._thumbnailZipEntry;
        }

        public String getZipPath() {
            return this._zipPath;
        }
    }

    private class PageTemplateCollectionEntry {
        private final String _key;
        private final PageTemplateCollection _pageTemplateCollection;
        private final Map<String, PageTemplateEntry> _pageTemplateEntries = new HashMap<String, PageTemplateEntry>();

        public PageTemplateCollectionEntry(String key, PageTemplateCollection pageTemplateCollection) {
            this._key = key;
            this._pageTemplateCollection = pageTemplateCollection;
        }

        public void addPageTemplateEntry(String key, PageTemplateEntry pageTemplateEntry) {
            this._pageTemplateEntries.put(key, pageTemplateEntry);
        }

        public String getKey() {
            return this._key;
        }

        public PageTemplateCollection getPageTemplateCollection() {
            return this._pageTemplateCollection;
        }

        public Map<String, PageTemplateEntry> getPageTemplatesEntries() {
            return this._pageTemplateEntries;
        }
    }

    private class MasterLayoutTemplatesImporterCallable
    implements Callable<Void> {
        private final long _groupId;
        private final MasterPageEntry _masterPageEntry;
        private final boolean _overwrite;
        private final long _userId;
        private final ZipFile _zipFile;

        @Override
        public Void call() throws Exception {
            MasterPage masterPage = this._masterPageEntry.getMasterPage();
            LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutsImporterImpl.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(this._groupId, this._masterPageEntry.getKey());
            LayoutsImporterImpl.this._processLayoutPageTemplateEntry(0L, 0L, this._groupId, 0L, layoutPageTemplateEntry, masterPage.getName(), this._masterPageEntry.getPageDefinition(), 3, this._overwrite, this._userId, this._masterPageEntry.getThumbnailZipEntry(), this._masterPageEntry.getZipPath(), this._zipFile);
            return null;
        }

        private MasterLayoutTemplatesImporterCallable(long groupId, MasterPageEntry masterPageEntry, boolean overwrite, long userId, ZipFile zipFile) {
            this._groupId = groupId;
            this._masterPageEntry = masterPageEntry;
            this._overwrite = overwrite;
            this._userId = userId;
            this._zipFile = zipFile;
        }
    }

    private class DisplayPagesImporterCallable
    implements Callable<Void> {
        private final DisplayPageTemplateEntry _displayPageTemplateEntry;
        private final long _groupId;
        private final boolean _overwrite;
        private final long _userId;
        private final ZipFile _zipFile;

        @Override
        public Void call() throws Exception {
            DisplayPageTemplate displayPageTemplate = this._displayPageTemplateEntry.getDisplayPageTemplate();
            ContentType contentType = displayPageTemplate.getContentType();
            long classNameId = LayoutsImporterImpl.this._portal.getClassNameId(contentType.getClassName());
            long classTypeId = this._getClassTypeId(displayPageTemplate, classNameId);
            LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutsImporterImpl.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(this._groupId, this._displayPageTemplateEntry.getKey());
            layoutPageTemplateEntry = LayoutsImporterImpl.this._processLayoutPageTemplateEntry(classNameId, classTypeId, this._groupId, 0L, layoutPageTemplateEntry, displayPageTemplate.getName(), this._displayPageTemplateEntry.getPageDefinition(), 1, this._overwrite, this._userId, this._displayPageTemplateEntry.getThumbnailZipEntry(), this._displayPageTemplateEntry.getZipPath(), this._zipFile);
            boolean defaultTemplate = GetterUtil.getBoolean((Object)displayPageTemplate.getDefaultTemplate());
            if (layoutPageTemplateEntry != null && defaultTemplate) {
                LayoutsImporterImpl.this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), true);
            }
            return null;
        }

        private DisplayPagesImporterCallable(long groupId, DisplayPageTemplateEntry displayPageTemplateEntry, boolean overwrite, long userId, ZipFile zipFile) {
            this._groupId = groupId;
            this._displayPageTemplateEntry = displayPageTemplateEntry;
            this._overwrite = overwrite;
            this._userId = userId;
            this._zipFile = zipFile;
        }

        private long _getClassTypeId(DisplayPageTemplate displayPageTemplate, long classNameId) {
            ContentSubtype contentSubtype = displayPageTemplate.getContentSubtype();
            if (contentSubtype == null) {
                return 0L;
            }
            Long subtypeId = contentSubtype.getSubtypeId();
            if (subtypeId != null) {
                return subtypeId;
            }
            String subtypeKey = contentSubtype.getSubtypeKey();
            if (Validator.isNull((String)subtypeKey)) {
                return 0L;
            }
            InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)LayoutsImporterImpl.this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormVariationsProvider.class, LayoutsImporterImpl.this._portal.getClassName(classNameId));
            if (infoItemFormVariationsProvider == null) {
                return 0L;
            }
            InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariation(this._groupId, subtypeKey);
            if (infoItemFormVariation == null) {
                return 0L;
            }
            return GetterUtil.getLong((String)infoItemFormVariation.getKey());
        }
    }

    private class BasicLayoutsImporterCallable
    implements Callable<Void> {
        private final long _groupId;
        private final long _layoutPageTemplateCollectionId;
        private final LayoutPageTemplateEntry _layoutPageTemplateEntry;
        private final boolean _overwrite;
        private final PageTemplateEntry _pageTemplateEntry;
        private final long _userId;
        private final ZipFile _zipFile;

        @Override
        public Void call() throws Exception {
            PageTemplate pageTemplate = this._pageTemplateEntry.getPageTemplate();
            LayoutsImporterImpl.this._processLayoutPageTemplateEntry(0L, 0L, this._groupId, this._layoutPageTemplateCollectionId, this._layoutPageTemplateEntry, pageTemplate.getName(), this._pageTemplateEntry.getPageDefinition(), 0, this._overwrite, this._userId, this._pageTemplateEntry.getThumbnailZipEntry(), this._pageTemplateEntry.getZipPath(), this._zipFile);
            return null;
        }

        private BasicLayoutsImporterCallable(long groupId, long layoutPageTemplateCollectionId, LayoutPageTemplateEntry layoutPageTemplateEntry, boolean overwrite, long userId, PageTemplateEntry pageTemplateEntry, ZipFile zipFile) {
            this._groupId = groupId;
            this._layoutPageTemplateCollectionId = layoutPageTemplateCollectionId;
            this._layoutPageTemplateEntry = layoutPageTemplateEntry;
            this._overwrite = overwrite;
            this._userId = userId;
            this._pageTemplateEntry = pageTemplateEntry;
            this._zipFile = zipFile;
        }
    }

    private static class UtilityPageTemplateEntry {
        private final String _key;
        private final PageDefinition _pageDefinition;
        private final ZipEntry _thumbnailZipEntry;
        private final UtilityPageTemplate _utilityPageTemplate;
        private final String _zipPath;

        public UtilityPageTemplateEntry(UtilityPageTemplate utilityPageTemplate, String key, PageDefinition pageDefinition, ZipEntry thumbnailZipEntry, String zipPath) {
            this._utilityPageTemplate = utilityPageTemplate;
            this._key = key;
            this._pageDefinition = pageDefinition;
            this._thumbnailZipEntry = thumbnailZipEntry;
            this._zipPath = zipPath;
        }

        public String getKey() {
            return this._key;
        }

        public PageDefinition getPageDefinition() {
            return this._pageDefinition;
        }

        public ZipEntry getThumbnailZipEntry() {
            return this._thumbnailZipEntry;
        }

        public UtilityPageTemplate getUtilityPageTemplate() {
            return this._utilityPageTemplate;
        }

        public String getZipPath() {
            return this._zipPath;
        }
    }

    private static class MasterPageEntry {
        private final String _key;
        private final MasterPage _masterPage;
        private final PageDefinition _pageDefinition;
        private final ZipEntry _thumbnailZipEntry;
        private final String _zipPath;

        public MasterPageEntry(String key, MasterPage masterPage, PageDefinition pageDefinition, ZipEntry thumbnailZipEntry, String zipPath) {
            this._key = key;
            this._masterPage = masterPage;
            this._pageDefinition = pageDefinition;
            this._thumbnailZipEntry = thumbnailZipEntry;
            this._zipPath = zipPath;
        }

        public String getKey() {
            return this._key;
        }

        public MasterPage getMasterPage() {
            return this._masterPage;
        }

        public PageDefinition getPageDefinition() {
            return this._pageDefinition;
        }

        public ZipEntry getThumbnailZipEntry() {
            return this._thumbnailZipEntry;
        }

        public String getZipPath() {
            return this._zipPath;
        }
    }

    private static class DisplayPageTemplateEntry {
        private final DisplayPageTemplate _displayPageTemplate;
        private final String _key;
        private final PageDefinition _pageDefinition;
        private final ZipEntry _thumbnailZipEntry;
        private final String _zipPath;

        public DisplayPageTemplateEntry(DisplayPageTemplate displayPageTemplate, String key, PageDefinition pageDefinition, ZipEntry thumbnailZipEntry, String zipPath) {
            this._displayPageTemplate = displayPageTemplate;
            this._key = key;
            this._pageDefinition = pageDefinition;
            this._thumbnailZipEntry = thumbnailZipEntry;
            this._zipPath = zipPath;
        }

        public DisplayPageTemplate getDisplayPageTemplate() {
            return this._displayPageTemplate;
        }

        public String getKey() {
            return this._key;
        }

        public PageDefinition getPageDefinition() {
            return this._pageDefinition;
        }

        public ZipEntry getThumbnailZipEntry() {
            return this._thumbnailZipEntry;
        }

        public String getZipPath() {
            return this._zipPath;
        }
    }
}

