/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.headless.delivery.dto.v1_0.CollectionConfig;
import com.liferay.headless.delivery.dto.v1_0.PageCollectionDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.collection.EmptyCollectionOptions;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemImporter.class})
public class CollectionLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final Log _log = LogFactoryUtil.getLog(CollectionLayoutStructureItemImporter.class);
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        Map formLayout;
        Integer numberOfPages;
        CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem = (CollectionStyledLayoutStructureItem)layoutStructure.addCollectionStyledLayoutStructureItem(layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return collectionStyledLayoutStructureItem;
        }
        Map collectionConfig = (Map)definitionMap.get("collectionConfig");
        if (collectionConfig != null) {
            collectionStyledLayoutStructureItem.setCollectionJSONObject(this._getCollectionConfigAsJSONObject(collectionConfig));
        }
        if (definitionMap.containsKey("collectionViewports")) {
            List collectionViewports = (List)definitionMap.get("collectionViewports");
            for (Map collectionViewport : collectionViewports) {
                this._processCollectionViewportDefinition(collectionStyledLayoutStructureItem, (Map)collectionViewport.get("collectionViewportDefinition"), (String)collectionViewport.get("id"));
            }
        }
        collectionStyledLayoutStructureItem.setDisplayAllItems((Boolean)definitionMap.get("displayAllItems"));
        Boolean displayAllPages = (Boolean)definitionMap.get("displayAllPages");
        Map emptyCollectionConfig = (Map)definitionMap.get("emptyCollectionConfig");
        collectionStyledLayoutStructureItem.setEmptyCollectionOptions(this._getEmptyCollectionOptions(emptyCollectionConfig));
        Boolean showAllItems = (Boolean)definitionMap.get("showAllItems");
        if (displayAllPages == null) {
            displayAllPages = showAllItems;
        }
        collectionStyledLayoutStructureItem.setDisplayAllPages(displayAllPages);
        collectionStyledLayoutStructureItem.setListItemStyle((String)definitionMap.get("listItemStyle"));
        collectionStyledLayoutStructureItem.setListStyle((String)definitionMap.get("listStyle"));
        collectionStyledLayoutStructureItem.setNumberOfColumns(((Integer)definitionMap.get("numberOfColumns")).intValue());
        Integer numberOfItems = (Integer)definitionMap.get("numberOfItems");
        collectionStyledLayoutStructureItem.setNumberOfItems(numberOfItems.intValue());
        Integer numberOfItemsPerPage = (Integer)definitionMap.get("numberOfItemsPerPage");
        if (numberOfItemsPerPage != null) {
            collectionStyledLayoutStructureItem.setNumberOfItemsPerPage(numberOfItemsPerPage.intValue());
        }
        if ((numberOfPages = (Integer)definitionMap.get("numberOfPages")) == null) {
            if (numberOfItemsPerPage != null && numberOfItemsPerPage > 0) {
                collectionStyledLayoutStructureItem.setNumberOfPages((int)Math.ceil((double)numberOfItems.intValue() / (double)numberOfItemsPerPage.intValue()));
            }
        } else {
            collectionStyledLayoutStructureItem.setNumberOfPages(numberOfPages.intValue());
        }
        collectionStyledLayoutStructureItem.setPaginationType(this._toPaginationType((String)definitionMap.get("paginationType")));
        collectionStyledLayoutStructureItem.setShowAllItems(showAllItems);
        collectionStyledLayoutStructureItem.setTemplateKey((String)definitionMap.get("templateKey"));
        if (definitionMap.containsKey("fragmentViewports")) {
            List fragmentViewports = (List)definitionMap.get("fragmentViewports");
            for (Map fragmentViewport : fragmentViewports) {
                JSONObject jsonObject = JSONUtil.put((String)((String)fragmentViewport.get("id")), (Object)this.toFragmentViewportStylesJSONObject(fragmentViewport));
                collectionStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        }
        if ((formLayout = (Map)definitionMap.get("layout")) != null) {
            String justify;
            String flexWrap;
            String align = String.valueOf(formLayout.getOrDefault("align", ""));
            if (Validator.isNotNull((String)align)) {
                collectionStyledLayoutStructureItem.setAlign(AlignConverter.convertToInternalValue((String)align));
            }
            if (Validator.isNotNull((String)(flexWrap = String.valueOf(formLayout.getOrDefault("flexWrap", ""))))) {
                collectionStyledLayoutStructureItem.setFlexWrap(FlexWrapConverter.convertToInternalValue((String)flexWrap));
            }
            if (Validator.isNotNull((String)(justify = String.valueOf(formLayout.getOrDefault("justify", ""))))) {
                collectionStyledLayoutStructureItem.setJustify(JustifyConverter.convertToInternalValue((String)justify));
            }
        }
        if (definitionMap.containsKey("name")) {
            collectionStyledLayoutStructureItem.setName(GetterUtil.getString((Object)definitionMap.get("name")));
        }
        return collectionStyledLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.COLLECTION;
    }

    private JSONObject _getCollectionConfigAsJSONObject(Map<String, Object> collectionConfig) {
        String type = (String)collectionConfig.get("collectionType");
        if (Validator.isNull((String)type)) {
            return null;
        }
        Map collectionReference = (Map)collectionConfig.get("collectionReference");
        if (MapUtil.isEmpty(collectionConfig)) {
            return null;
        }
        if (Objects.equals(type, CollectionConfig.CollectionType.COLLECTION.getValue())) {
            return this._getCollectionJSONObject(collectionReference);
        }
        if (Objects.equals(type, CollectionConfig.CollectionType.COLLECTION_PROVIDER.getValue())) {
            return this._getCollectionProviderJSONObject(collectionReference);
        }
        return null;
    }

    private JSONObject _getCollectionJSONObject(Map<String, Object> collectionReference) {
        Long classPK = this._toClassPK(String.valueOf(collectionReference.get("classPK")));
        if (classPK == null) {
            return null;
        }
        AssetListEntry assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(classPK.longValue());
        if (assetListEntry == null) {
            return null;
        }
        return JSONUtil.put((String)"classNameId", (Object)this.portal.getClassNameId(AssetListEntry.class.getName())).put("classPK", String.valueOf(classPK)).put("itemSubtype", assetListEntry.getAssetEntrySubtype()).put("itemType", assetListEntry.getAssetEntryType()).put("title", assetListEntry.getTitle()).put("type", InfoListItemSelectorReturnType.class.getName());
    }

    private JSONObject _getCollectionProviderJSONObject(Map<String, Object> collectionReference) {
        String className = (String)collectionReference.get("className");
        InfoCollectionProvider infoCollectionProvider = (InfoCollectionProvider)this.infoItemServiceRegistry.getInfoItemService(InfoCollectionProvider.class, className);
        if (infoCollectionProvider == null) {
            infoCollectionProvider = (InfoCollectionProvider)this.infoItemServiceRegistry.getInfoItemService(RelatedInfoItemCollectionProvider.class, className);
        }
        if (infoCollectionProvider == null) {
            return null;
        }
        return JSONUtil.put((String)"itemSubtype", (Object)this._getItemSubtype(infoCollectionProvider)).put("itemType", infoCollectionProvider.getCollectionItemClassName()).put("key", className).put("title", infoCollectionProvider.getLabel(LocaleUtil.getDefault())).put("type", InfoListProviderItemSelectorReturnType.class.getName());
    }

    private EmptyCollectionOptions _getEmptyCollectionOptions(final Map<String, Object> emptyCollectionConfig) {
        if (emptyCollectionConfig == null || emptyCollectionConfig.isEmpty()) {
            return null;
        }
        return new EmptyCollectionOptions(){
            {
                this.setDisplayMessage(() -> {
                    if (emptyCollectionConfig.containsKey("displayMessage")) {
                        return GetterUtil.getBoolean(emptyCollectionConfig.get("displayMessage"), (boolean)true);
                    }
                    return null;
                });
                this.setMessage(() -> (Map)emptyCollectionConfig.get("message_i18n"));
            }
        };
    }

    private String _getItemSubtype(InfoCollectionProvider<?> infoCollectionProvider) {
        if (infoCollectionProvider instanceof SingleFormVariationInfoCollectionProvider) {
            SingleFormVariationInfoCollectionProvider singleFormVariationInfoCollectionProvider = (SingleFormVariationInfoCollectionProvider)infoCollectionProvider;
            return singleFormVariationInfoCollectionProvider.getFormVariationKey();
        }
        return null;
    }

    private void _processCollectionViewportDefinition(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem, Map<String, Object> collectionViewportDefinitionMap, String collectionViewportId) {
        collectionStyledLayoutStructureItem.setViewportConfiguration(collectionViewportId, JSONUtil.put((String)"numberOfColumns", () -> {
            if (collectionViewportDefinitionMap.containsKey("numberOfColumns")) {
                return GetterUtil.getInteger(collectionViewportDefinitionMap.get("numberOfColumns"));
            }
            return null;
        }));
    }

    private Long _toClassPK(String classPKString) {
        if (Validator.isNull((String)classPKString)) {
            return null;
        }
        Long classPK = null;
        try {
            classPK = Long.parseLong(classPKString);
        }
        catch (NumberFormatException numberFormatException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Unable to parse class PK %s to a long", classPKString), (Throwable)numberFormatException);
            }
            return null;
        }
        return classPK;
    }

    private String _toPaginationType(String paginationType) {
        if (Validator.isNull((String)paginationType) || Objects.equals(paginationType, PageCollectionDefinition.PaginationType.NONE.getValue())) {
            return "none";
        }
        if (Objects.equals(paginationType, PageCollectionDefinition.PaginationType.NUMERIC.getValue()) || Objects.equals(paginationType, PageCollectionDefinition.PaginationType.REGULAR.getValue())) {
            return "numeric";
        }
        if (Objects.equals(paginationType, PageCollectionDefinition.PaginationType.SIMPLE.getValue())) {
            return "simple";
        }
        return null;
    }
}

