/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.headless.delivery.dto.v1_0.FragmentLink;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.BorderRadiusConverter;
import com.liferay.layout.converter.ContentDisplayConverter;
import com.liferay.layout.converter.ContentVisibilityConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.HtmlTagConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.converter.MarginConverter;
import com.liferay.layout.converter.PaddingConverter;
import com.liferay.layout.converter.ShadowConverter;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemImporter.class})
public class ContainerLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        Map fragmentStyleMap;
        Map containerLayout;
        String htmlTag;
        Map containerHtmlProperties;
        String contentVisibility;
        ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)layoutStructure.addContainerStyledLayoutStructureItem(layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return containerStyledLayoutStructureItem;
        }
        JSONObject stylesJSONObject = JSONUtil.put((String)"backgroundColor", (Object)definitionMap.get("backgroundColor"));
        Map backgroundFragmentImageMap = (Map)definitionMap.get("backgroundFragmentImage");
        if (MapUtil.isEmpty((Map)backgroundFragmentImageMap)) {
            backgroundFragmentImageMap = (Map)definitionMap.get("backgroundImage");
        }
        if (backgroundFragmentImageMap != null) {
            Object urlMap;
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            Map titleMap = (Map)backgroundFragmentImageMap.get("title");
            if (titleMap != null) {
                jsonObject.put("title", this.getLocalizedValue(titleMap));
            }
            if ((urlMap = (Map)backgroundFragmentImageMap.get("url")) != null) {
                jsonObject.put("url", this.getLocalizedValue((Map<String, Object>)urlMap));
                this.processMapping(jsonObject, layoutStructureItemImporterContext, (Map)urlMap.get("mapping"));
            }
            stylesJSONObject.put("backgroundImage", jsonObject);
        }
        if (Validator.isNotNull((String)(contentVisibility = String.valueOf(definitionMap.getOrDefault("contentVisibility", ""))))) {
            containerStyledLayoutStructureItem.setContentVisibility(ContentVisibilityConverter.convertToInternalValue((String)contentVisibility));
        }
        if (definitionMap.containsKey("cssClasses")) {
            List cssClasses = (List)definitionMap.get("cssClasses");
            containerStyledLayoutStructureItem.setCssClasses(new HashSet(cssClasses));
        }
        if (definitionMap.containsKey("customCSS")) {
            containerStyledLayoutStructureItem.setCustomCSS(String.valueOf(definitionMap.get("customCSS")));
        }
        if (definitionMap.containsKey("customCSSViewports")) {
            List customCSSViewports = (List)definitionMap.get("customCSSViewports");
            for (Map customCSSViewport : customCSSViewports) {
                containerStyledLayoutStructureItem.setCustomCSSViewport((String)customCSSViewport.get("id"), (String)customCSSViewport.get("customCSS"));
            }
        }
        if ((containerHtmlProperties = (Map)definitionMap.get("htmlProperties")) != null && Validator.isNotNull((String)(htmlTag = String.valueOf(containerHtmlProperties.getOrDefault("htmlTag", ""))))) {
            containerStyledLayoutStructureItem.setHtmlTag(HtmlTagConverter.convertToInternalValue((String)htmlTag));
        }
        if ((containerLayout = (Map)definitionMap.get("layout")) != null) {
            String paddingBottom;
            String opacity;
            String marginTop;
            String marginRight;
            String marginLeft;
            String marginBottom;
            String justify;
            String flexWrap;
            String contentDisplay;
            String align = String.valueOf(containerLayout.getOrDefault("align", ""));
            if (Validator.isNotNull((String)align)) {
                containerStyledLayoutStructureItem.setAlign(AlignConverter.convertToInternalValue((String)align));
            }
            stylesJSONObject.put("borderColor", (String)containerLayout.get("borderColor")).put("borderRadius", BorderRadiusConverter.convertToInternalValue((String)((String)containerLayout.get("borderRadius"))));
            String borderWidth = String.valueOf(containerLayout.getOrDefault("borderWidth", ""));
            if (Validator.isNotNull((String)borderWidth)) {
                stylesJSONObject.put("borderWidth", borderWidth);
            }
            if (Validator.isNotNull((String)(contentDisplay = String.valueOf(containerLayout.getOrDefault("contentDisplay", ""))))) {
                containerStyledLayoutStructureItem.setContentDisplay(ContentDisplayConverter.convertToInternalValue((String)contentDisplay));
            }
            if (Validator.isNotNull((String)(flexWrap = String.valueOf(containerLayout.getOrDefault("flexWrap", ""))))) {
                containerStyledLayoutStructureItem.setFlexWrap(FlexWrapConverter.convertToInternalValue((String)flexWrap));
            }
            if (Validator.isNotNull((String)(justify = String.valueOf(containerLayout.getOrDefault("justify", ""))))) {
                containerStyledLayoutStructureItem.setJustify(JustifyConverter.convertToInternalValue((String)justify));
            }
            if (Validator.isNotNull((String)(marginBottom = MarginConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("marginBottom", "")))))) {
                stylesJSONObject.put("marginBottom", marginBottom);
            }
            if (Validator.isNotNull((String)(marginLeft = MarginConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("marginLeft", "")))))) {
                stylesJSONObject.put("marginLeft", marginLeft);
            }
            if (Validator.isNotNull((String)(marginRight = MarginConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("marginRight", "")))))) {
                stylesJSONObject.put("marginRight", marginRight);
            }
            if (Validator.isNotNull((String)(marginTop = MarginConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("marginTop", "")))))) {
                stylesJSONObject.put("marginTop", marginTop);
            }
            if (Validator.isNotNull((String)(opacity = String.valueOf(containerLayout.getOrDefault("opacity", ""))))) {
                stylesJSONObject.put("opacity", opacity);
            }
            if (Validator.isNotNull((String)(paddingBottom = PaddingConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("paddingBottom", "")))))) {
                stylesJSONObject.put("paddingBottom", paddingBottom);
            }
            String paddingHorizontal = PaddingConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("paddingHorizontal", "")));
            String paddingLeft = PaddingConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("paddingLeft", "")));
            String paddingRight = PaddingConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("paddingRight", "")));
            if (Validator.isNotNull((String)paddingLeft)) {
                stylesJSONObject.put("paddingLeft", paddingLeft);
            } else if (Validator.isNotNull((String)paddingHorizontal)) {
                stylesJSONObject.put("paddingLeft", paddingHorizontal);
            }
            if (Validator.isNotNull((String)paddingRight)) {
                stylesJSONObject.put("paddingRight", paddingRight);
            } else if (Validator.isNotNull((String)paddingHorizontal)) {
                stylesJSONObject.put("paddingRight", paddingHorizontal);
            }
            String paddingTop = PaddingConverter.convertToInternalValue((String)String.valueOf(containerLayout.getOrDefault("paddingTop", "")));
            if (Validator.isNotNull((String)paddingTop)) {
                stylesJSONObject.put("paddingTop", paddingTop);
            }
            stylesJSONObject.put("shadow", ShadowConverter.convertToInternalValue((String)((String)containerLayout.get("shadow"))));
            String containerType = StringUtil.toLowerCase((String)((String)containerLayout.get("containerType")));
            String widthType = StringUtil.toLowerCase((String)((String)containerLayout.get("widthType")));
            if (widthType != null) {
                containerStyledLayoutStructureItem.setWidthType(widthType);
            } else if (containerType != null) {
                containerStyledLayoutStructureItem.setWidthType(containerType);
            }
        }
        containerStyledLayoutStructureItem.updateItemConfig(JSONUtil.put((String)"styles", (Object)stylesJSONObject));
        Map fragmentLinkMap = (Map)definitionMap.get("fragmentLink");
        if (fragmentLinkMap != null) {
            String target;
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            Map hrefMap = (Map)fragmentLinkMap.get("href");
            if (hrefMap != null) {
                Object localizedValue = this.getLocalizedValue(hrefMap);
                if (localizedValue != null) {
                    jsonObject.put("href", localizedValue);
                }
                this.processMapping(jsonObject, layoutStructureItemImporterContext, (Map)hrefMap.get("mapping"));
            }
            if ((target = (String)fragmentLinkMap.get("target")) != null) {
                if (Objects.equals(target, FragmentLink.Target.PARENT.getValue()) || Objects.equals(target, FragmentLink.Target.TOP.getValue())) {
                    target = FragmentLink.Target.SELF.getValue();
                }
                jsonObject.put("target", "_" + StringUtil.toLowerCase((String)target));
            }
            containerStyledLayoutStructureItem.setLinkJSONObject(jsonObject);
        }
        if ((fragmentStyleMap = (Map)definitionMap.get("fragmentStyle")) != null) {
            JSONObject jsonObject = JSONUtil.put((String)"styles", (Object)this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentStyleMap));
            containerStyledLayoutStructureItem.updateItemConfig(jsonObject);
        }
        if (definitionMap.containsKey("fragmentViewports")) {
            List fragmentViewports = (List)definitionMap.get("fragmentViewports");
            for (Map fragmentViewport : fragmentViewports) {
                JSONObject jsonObject = JSONUtil.put((String)((String)fragmentViewport.get("id")), (Object)this.toFragmentViewportStylesJSONObject(fragmentViewport));
                containerStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        }
        if (definitionMap.containsKey("indexed")) {
            containerStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)definitionMap.get("indexed")));
        }
        if (definitionMap.containsKey("name")) {
            containerStyledLayoutStructureItem.setName(GetterUtil.getString((Object)definitionMap.get("name")));
        }
        return containerStyledLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.SECTION;
    }
}

