/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.headless.delivery.dto.v1_0.ContextReference;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.ContentDisplayConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemImporter.class})
public class FormLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        Map formLayout;
        Map fragmentStyleMap;
        Map sourceMap;
        FormStyledLayoutStructureItem formStyledLayoutStructureItem = (FormStyledLayoutStructureItem)layoutStructure.addFormStyledLayoutStructureItem(layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return formStyledLayoutStructureItem;
        }
        if (definitionMap.containsKey("cssClasses")) {
            List cssClasses = (List)definitionMap.get("cssClasses");
            formStyledLayoutStructureItem.setCssClasses(new HashSet(cssClasses));
        }
        if (definitionMap.containsKey("customCSS")) {
            formStyledLayoutStructureItem.setCustomCSS(String.valueOf(definitionMap.get("customCSS")));
        }
        if (definitionMap.containsKey("customCSSViewports")) {
            List customCSSViewports = (List)definitionMap.get("customCSSViewports");
            for (Map customCSSViewport : customCSSViewports) {
                formStyledLayoutStructureItem.setCustomCSSViewport((String)customCSSViewport.get("id"), (String)customCSSViewport.get("customCSS"));
            }
        }
        if ((sourceMap = (Map)definitionMap.get("formConfig")) != null) {
            Map itemReferenceMap = (Map)sourceMap.get("formReference");
            if (Objects.equals(ContextReference.ContextSource.DISPLAY_PAGE_ITEM.getValue(), (String)itemReferenceMap.get("contextSource"))) {
                formStyledLayoutStructureItem.setFormConfig(1);
            } else {
                formStyledLayoutStructureItem.setClassNameId(this.portal.getClassNameId((String)itemReferenceMap.get("className")));
                Integer classType = (Integer)itemReferenceMap.get("classType");
                if (classType != null) {
                    formStyledLayoutStructureItem.setClassTypeId((long)classType.intValue());
                }
                formStyledLayoutStructureItem.setFormConfig(2);
            }
            JSONObject successMessageJSONObject = this._getSuccessMessageJSONObject(layoutStructureItemImporterContext, sourceMap);
            if (successMessageJSONObject != null) {
                formStyledLayoutStructureItem.setSuccessMessageJSONObject(successMessageJSONObject);
            }
        }
        if ((fragmentStyleMap = (Map)definitionMap.get("fragmentStyle")) != null) {
            JSONObject jsonObject = JSONUtil.put((String)"styles", (Object)this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentStyleMap));
            formStyledLayoutStructureItem.updateItemConfig(jsonObject);
        }
        if (definitionMap.containsKey("fragmentViewports")) {
            List fragmentViewports = (List)definitionMap.get("fragmentViewports");
            for (Map fragmentViewport : fragmentViewports) {
                JSONObject jsonObject = JSONUtil.put((String)((String)fragmentViewport.get("id")), (Object)this.toFragmentViewportStylesJSONObject(fragmentViewport));
                formStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        }
        if (definitionMap.containsKey("indexed")) {
            formStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)definitionMap.get("indexed")));
        }
        if ((formLayout = (Map)definitionMap.get("layout")) != null) {
            String widthType;
            String justify;
            String flexWrap;
            String contentDisplay;
            String align = String.valueOf(formLayout.getOrDefault("align", ""));
            if (Validator.isNotNull((String)align)) {
                formStyledLayoutStructureItem.setAlign(AlignConverter.convertToInternalValue((String)align));
            }
            if (Validator.isNotNull((String)(contentDisplay = String.valueOf(formLayout.getOrDefault("contentDisplay", ""))))) {
                formStyledLayoutStructureItem.setContentDisplay(ContentDisplayConverter.convertToInternalValue((String)contentDisplay));
            }
            if (Validator.isNotNull((String)(flexWrap = String.valueOf(formLayout.getOrDefault("flexWrap", ""))))) {
                formStyledLayoutStructureItem.setFlexWrap(FlexWrapConverter.convertToInternalValue((String)flexWrap));
            }
            if (Validator.isNotNull((String)(justify = String.valueOf(formLayout.getOrDefault("justify", ""))))) {
                formStyledLayoutStructureItem.setJustify(JustifyConverter.convertToInternalValue((String)justify));
            }
            if ((widthType = StringUtil.toLowerCase((String)((String)formLayout.get("widthType")))) != null) {
                formStyledLayoutStructureItem.setWidthType(widthType);
            }
        }
        if (definitionMap.containsKey("name")) {
            formStyledLayoutStructureItem.setName(GetterUtil.getString((Object)definitionMap.get("name")));
        }
        return formStyledLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.FORM;
    }

    private JSONObject _getLocalizedValuesJSONObject(String key, Map<String, Object> propertiesMap) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        Map map = (Map)propertiesMap.get(key);
        if (MapUtil.isEmpty((Map)map)) {
            return jsonObject;
        }
        Map localizedMap = (Map)map.get("value_i18n");
        if (localizedMap == null) {
            return jsonObject;
        }
        for (Map.Entry entry : localizedMap.entrySet()) {
            jsonObject.put((String)entry.getKey(), entry.getValue());
        }
        return JSONUtil.put((String)key, (Object)jsonObject);
    }

    private JSONObject _getSuccessMessageJSONObject(LayoutStructureItemImporterContext layoutStructureItemImporterContext, Map<String, Object> sourceMap) {
        Map formSuccessSubmissionResultMap = (Map)sourceMap.get("formSuccessSubmissionResult");
        if (MapUtil.isEmpty((Map)formSuccessSubmissionResultMap)) {
            return null;
        }
        if (formSuccessSubmissionResultMap.containsKey("message")) {
            return this._getLocalizedValuesJSONObject("message", formSuccessSubmissionResultMap);
        }
        if (formSuccessSubmissionResultMap.containsKey("itemReference")) {
            Map itemReference = (Map)formSuccessSubmissionResultMap.get("itemReference");
            return JSONUtil.put((String)"layout", (Object)this.getLayoutFromItemReferenceJSONObject(itemReference, layoutStructureItemImporterContext));
        }
        if (formSuccessSubmissionResultMap.containsKey("url")) {
            return this._getLocalizedValuesJSONObject("url", formSuccessSubmissionResultMap);
        }
        return null;
    }
}

