/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemImporter.class})
public class RowLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        Map fragmentStyleMap;
        RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)layoutStructure.addLayoutStructureItem("row", layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return rowStyledLayoutStructureItem;
        }
        if (definitionMap.containsKey("cssClasses")) {
            List cssClasses = (List)definitionMap.get("cssClasses");
            rowStyledLayoutStructureItem.setCssClasses(new HashSet(cssClasses));
        }
        if (definitionMap.containsKey("customCSS")) {
            rowStyledLayoutStructureItem.setCustomCSS(String.valueOf(definitionMap.get("customCSS")));
        }
        if (definitionMap.containsKey("customCSSViewports")) {
            List customCSSViewports = (List)definitionMap.get("customCSSViewports");
            for (Map map : customCSSViewports) {
                rowStyledLayoutStructureItem.setCustomCSSViewport((String)map.get("id"), (String)map.get("customCSS"));
            }
        }
        rowStyledLayoutStructureItem.setGutters(((Boolean)definitionMap.get("gutters")).booleanValue());
        if (definitionMap.containsKey("indexed")) {
            rowStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)definitionMap.get("indexed")));
        }
        if (definitionMap.containsKey("name")) {
            rowStyledLayoutStructureItem.setName(GetterUtil.getString((Object)definitionMap.get("name")));
        }
        rowStyledLayoutStructureItem.setNumberOfColumns(((Integer)definitionMap.get("numberOfColumns")).intValue());
        if (definitionMap.containsKey("reverseOrder")) {
            rowStyledLayoutStructureItem.setModulesPerRow(((Integer)definitionMap.get("modulesPerRow")).intValue());
            rowStyledLayoutStructureItem.setReverseOrder(((Boolean)definitionMap.get("reverseOrder")).booleanValue());
        }
        if (definitionMap.containsKey("verticalAlignment")) {
            rowStyledLayoutStructureItem.setVerticalAlignment((String)definitionMap.get("verticalAlignment"));
        }
        if (definitionMap.containsKey("rowViewports")) {
            List rowViewports = (List)definitionMap.get("rowViewports");
            for (Map map : rowViewports) {
                this._processRowViewportDefinition(rowStyledLayoutStructureItem, (Map)map.get("rowViewportDefinition"), (String)map.get("id"));
            }
        } else if (definitionMap.containsKey("rowViewportConfig")) {
            Map rowViewportConfigurations = (Map)definitionMap.get("rowViewportConfig");
            for (Map.Entry entry : rowViewportConfigurations.entrySet()) {
                this._processRowViewportDefinition(rowStyledLayoutStructureItem, (Map)entry.getValue(), (String)entry.getKey());
            }
        }
        if ((fragmentStyleMap = (Map)definitionMap.get("fragmentStyle")) != null) {
            JSONObject jsonObject = JSONUtil.put((String)"styles", (Object)this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentStyleMap));
            rowStyledLayoutStructureItem.updateItemConfig(jsonObject);
        }
        if (definitionMap.containsKey("fragmentViewports")) {
            List fragmentViewports = (List)definitionMap.get("fragmentViewports");
            for (Map fragmentViewport : fragmentViewports) {
                JSONObject jsonObject = JSONUtil.put((String)((String)fragmentViewport.get("id")), (Object)this.toFragmentViewportStylesJSONObject(fragmentViewport));
                rowStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        }
        return rowStyledLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.ROW;
    }

    private void _processRowViewportDefinition(RowStyledLayoutStructureItem rowStyledLayoutStructureItem, Map<String, Object> rowViewportDefinitionMap, String rowViewportId) {
        rowStyledLayoutStructureItem.setViewportConfiguration(rowViewportId, JSONUtil.put((String)"modulesPerRow", () -> {
            if (rowViewportDefinitionMap.containsKey("modulesPerRow")) {
                return GetterUtil.getInteger(rowViewportDefinitionMap.get("modulesPerRow"));
            }
            return null;
        }).put("reverseOrder", () -> {
            if (rowViewportDefinitionMap.containsKey("reverseOrder")) {
                return GetterUtil.getBoolean(rowViewportDefinitionMap.get("reverseOrder"));
            }
            return null;
        }).put("verticalAlignment", () -> {
            if (rowViewportDefinitionMap.containsKey("verticalAlignment")) {
                return GetterUtil.getString(rowViewportDefinitionMap.get("verticalAlignment"));
            }
            return null;
        }));
    }
}

