/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.helper.PortletConfigurationImporterHelper;
import com.liferay.layout.internal.importer.helper.PortletPermissionsImporterHelper;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemImporter.class})
public class WidgetLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private PortletConfigurationImporterHelper _portletConfigurationImporterHelper;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPermissionsImporterHelper _portletPermissionsImporterHelper;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        Map fragmentStyleMap;
        FragmentEntryLink fragmentEntryLink = this._addFragmentEntryLink(layoutStructureItemImporterContext.getLayout(), pageElement, warningMessages);
        if (fragmentEntryLink == null) {
            return null;
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return fragmentStyledLayoutStructureItem;
        }
        if (definitionMap.containsKey("cssClasses")) {
            List cssClasses = (List)definitionMap.get("cssClasses");
            fragmentStyledLayoutStructureItem.setCssClasses(new HashSet(cssClasses));
        }
        if (definitionMap.containsKey("customCSS")) {
            fragmentStyledLayoutStructureItem.setCustomCSS(String.valueOf(definitionMap.get("customCSS")));
        }
        if (definitionMap.containsKey("customCSSViewports")) {
            List customCSSViewports = (List)definitionMap.get("customCSSViewports");
            for (Map customCSSViewport : customCSSViewports) {
                fragmentStyledLayoutStructureItem.setCustomCSSViewport((String)customCSSViewport.get("id"), (String)customCSSViewport.get("customCSS"));
            }
        }
        if ((fragmentStyleMap = (Map)definitionMap.get("fragmentStyle")) != null) {
            JSONObject jsonObject = JSONUtil.put((String)"styles", (Object)this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentStyleMap));
            fragmentStyledLayoutStructureItem.updateItemConfig(jsonObject);
        }
        if (definitionMap.containsKey("fragmentViewports")) {
            List fragmentViewports = (List)definitionMap.get("fragmentViewports");
            for (Map fragmentViewport : fragmentViewports) {
                JSONObject jsonObject = JSONUtil.put((String)((String)fragmentViewport.get("id")), (Object)this.toFragmentViewportStylesJSONObject(fragmentViewport));
                fragmentStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        }
        if (definitionMap.containsKey("name")) {
            fragmentStyledLayoutStructureItem.setName(GetterUtil.getString((Object)definitionMap.get("name")));
        }
        return fragmentStyledLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.WIDGET;
    }

    private FragmentEntryLink _addFragmentEntryLink(Layout layout, PageElement pageElement, Set<String> warningMessages) throws Exception {
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return null;
        }
        Map widgetInstance = (Map)definitionMap.get("widgetInstance");
        if (widgetInstance == null) {
            return null;
        }
        String widgetName = (String)widgetInstance.get("widgetName");
        if (Validator.isNull((String)widgetName)) {
            return null;
        }
        String widgetInstanceId = (String)widgetInstance.get("widgetInstanceId");
        JSONObject editableValueJSONObject = this._fragmentEntryProcessorRegistry.getDefaultEditableValuesJSONObject("", "");
        if (Validator.isNull((String)widgetInstanceId)) {
            widgetInstanceId = StringUtil.randomId();
        }
        widgetInstanceId = this._getPortletInstanceId(layout, widgetInstanceId, widgetName);
        editableValueJSONObject.put("instanceId", widgetInstanceId).put("portletId", widgetName);
        Map widgetConfigDefinitionMap = (Map)widgetInstance.get("widgetConfig");
        this._portletConfigurationImporterHelper.importPortletConfiguration(layout.getPlid(), PortletIdCodec.encode((String)widgetName, (String)widgetInstanceId), widgetConfigDefinitionMap);
        List widgetPermissionsMaps = (List)widgetInstance.get("widgetPermissions");
        this._portletPermissionsImporterHelper.importPortletPermissions(layout.getPlid(), PortletIdCodec.encode((String)widgetName, (String)widgetInstanceId), warningMessages, widgetPermissionsMaps);
        return this._fragmentEntryLinkLocalService.addFragmentEntryLink(layout.getUserId(), layout.getGroupId(), 0L, 0L, this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid()), layout.getPlid(), "", "", "", "", editableValueJSONObject.toString(), widgetInstanceId, 0, null, 4, ServiceContextThreadLocal.getServiceContext());
    }

    private String _getPortletInstanceId(Layout layout, String portletInstanceId, String portletId) throws Exception {
        Portlet portlet = this._portletLocalService.fetchPortletById(layout.getCompanyId(), portletId);
        if (portlet == null) {
            throw new PortletIdException();
        }
        if (portlet.isInstanceable()) {
            return portletInstanceId;
        }
        long count = this._portletPreferencesLocalService.getPortletPreferencesCount(3, layout.getPlid(), portletId);
        if (count > 0L) {
            throw new PortletIdException("Unable to add uninstanceable portlet more than once");
        }
        return "";
    }
}

