/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.LayoutQueryStringComposite;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FriendlyURLResolver.class})
public class VirtualLayoutFriendlyURLResolver
implements FriendlyURLResolver {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String groupFriendlyURL = null;
        int pos = friendlyURL.indexOf(47, 3);
        if (pos != -1) {
            groupFriendlyURL = friendlyURL.substring(2, pos);
        }
        if (Validator.isNull(groupFriendlyURL)) {
            return mainPath;
        }
        Group group = this._groupLocalService.fetchFriendlyURLGroup(companyId, groupFriendlyURL);
        if (group == null) {
            return mainPath;
        }
        String layoutFriendlyURL = null;
        if (pos != -1 && pos + 1 != friendlyURL.length()) {
            layoutFriendlyURL = friendlyURL.substring(pos);
        }
        if (Validator.isNull(layoutFriendlyURL)) {
            return mainPath;
        }
        return HttpComponentsUtil.addParameter((String)HttpComponentsUtil.removeParameter((String)this._portal.getActualURL(group.getGroupId(), privateLayout, mainPath, layoutFriendlyURL, params, requestContext), (String)"p_v_l_s_g_id"), (String)"p_v_l_s_g_id", (long)groupId);
    }

    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String groupFriendlyURL = null;
        int pos = friendlyURL.indexOf(47, 3);
        if (pos != -1) {
            groupFriendlyURL = friendlyURL.substring(2, pos);
        }
        Group group = this._groupLocalService.fetchFriendlyURLGroup(companyId, groupFriendlyURL);
        String layoutFriendlyURL = null;
        if (pos != -1 && pos + 1 != friendlyURL.length()) {
            layoutFriendlyURL = friendlyURL.substring(pos);
        }
        LayoutQueryStringComposite layoutQueryStringComposite = this._portal.getActualLayoutQueryStringComposite(group.getGroupId(), privateLayout, layoutFriendlyURL, params, requestContext);
        return new LayoutFriendlyURLComposite(layoutQueryStringComposite.getLayout(), layoutFriendlyURL, false);
    }

    public LayoutFriendlyURLSeparatorComposite getLayoutFriendlyURLSeparatorComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLComposite layoutFriendlyURLComposite = this.getLayoutFriendlyURLComposite(companyId, groupId, privateLayout, friendlyURL, params, requestContext);
        if (layoutFriendlyURLComposite == null) {
            return null;
        }
        return new LayoutFriendlyURLSeparatorComposite(layoutFriendlyURLComposite, "/-/");
    }

    public String getURLSeparator() {
        return "/~";
    }
}

