/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.portlet.category;

import com.liferay.layout.portlet.category.PortletCategoryManager;
import com.liferay.layout.util.PortalPreferencesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletCategoryComparator;
import com.liferay.portal.kernel.util.comparator.PortletTitleComparator;
import com.liferay.portal.util.PortletCategoryUtil;
import com.liferay.portal.util.WebAppPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortletCategoryManager.class})
public class PortletCategoryManagerImpl
implements PortletCategoryManager {
    private static final String[] _UNSUPPORTED_PORTLETS_NAMES = new String[]{"com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet"};
    private static final Log _log = LogFactoryUtil.getLog(PortletCategoryManagerImpl.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private PortletItemLocalService _portletItemLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;

    public JSONArray getPortletsJSONArray(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay) throws Exception {
        PortletCategory rootPortletCategory = (PortletCategory)WebAppPool.get((Long)themeDisplay.getCompanyId(), (String)"PORTLET_CATEGORY");
        PortletCategory highlightedPortletCategory = rootPortletCategory.getCategory("category.highlighted");
        PortletCategory portletCategory = PortletCategoryUtil.getRelevantPortletCategory((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getCompanyId(), (Layout)themeDisplay.getLayout(), (PortletCategory)rootPortletCategory, (LayoutTypePortlet)themeDisplay.getLayoutTypePortlet());
        Map<String, JSONObject> portletCategoryJSONObjectsMap = this._getPortletCategoryJSONObjectsMap(this._getHighlightedPortletIds(httpServletRequest, highlightedPortletCategory), httpServletRequest, portletCategory, themeDisplay);
        List<String> sortedPortletCategoryKeys = this._getSortedPortletCategoryKeys(this._portletPreferencesFactory.getPortalPreferences(httpServletRequest));
        if (sortedPortletCategoryKeys.isEmpty()) {
            return JSONUtil.toJSONArray(new ArrayList<JSONObject>(portletCategoryJSONObjectsMap.values()), portletCategoryJSONObject -> portletCategoryJSONObject);
        }
        LinkedList<JSONObject> sortedPortletCategoryJSONObjectsList = new LinkedList<JSONObject>();
        for (String portletCategoryKey : sortedPortletCategoryKeys) {
            JSONObject portletCategoryJSONObject2 = portletCategoryJSONObjectsMap.remove(portletCategoryKey);
            if (portletCategoryJSONObject2 == null) continue;
            sortedPortletCategoryJSONObjectsList.add(portletCategoryJSONObject2);
        }
        sortedPortletCategoryJSONObjectsList.addAll(0, portletCategoryJSONObjectsMap.values());
        return JSONUtil.toJSONArray(sortedPortletCategoryJSONObjectsList, portletCategoryJSONObject -> portletCategoryJSONObject);
    }

    public void updateSortedPortletCategoryKeys(PortalPreferences portalPreferences, String[] sortedPortletCategoryKeys) {
        PortalPreferencesUtil.updateSortedPortalPreferencesValues((PortalPreferences)portalPreferences, (String)"com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", (String)"sortedPortletCategoryKeys", (String[])sortedPortletCategoryKeys);
    }

    private Set<String> _getHighlightedPortletIds(HttpServletRequest httpServletRequest, PortletCategory highlightedPortletCategory) {
        TreeSet<String> highlightedPortletIds = new TreeSet<String>(highlightedPortletCategory.getPortletIds());
        PortalPreferences portalPreferences = this._portletPreferencesFactory.getPortalPreferences(httpServletRequest);
        highlightedPortletIds.addAll(SetUtil.fromArray((Object[])portalPreferences.getValues("com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "highlightedPortletIds", new String[0])));
        highlightedPortletIds.removeAll(SetUtil.fromArray((Object[])portalPreferences.getValues("com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "nonhighlightedPortletIds", new String[0])));
        return highlightedPortletIds;
    }

    private Set<String> _getLayoutDecodedPortletNames(ThemeDisplay themeDisplay) {
        HashSet<String> layoutDecodedPortletNames = new HashSet<String>();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        for (Portlet layoutPortlet : layoutTypePortlet.getPortlets()) {
            String decodedPortletName = PortletIdCodec.decodePortletName((String)layoutPortlet.getPortletId());
            layoutDecodedPortletNames.add(decodedPortletName);
        }
        return layoutDecodedPortletNames;
    }

    private Map<String, JSONObject> _getPortletCategoryJSONObjectsMap(Set<String> highlightedPortletIds, HttpServletRequest httpServletRequest, PortletCategory portletCategory, ThemeDisplay themeDisplay) throws Exception {
        LinkedHashMap<String, JSONObject> portletCategoryJSONObjectsMap = new LinkedHashMap<String, JSONObject>();
        Set<String> layoutDecodedPortletNames = this._getLayoutDecodedPortletNames(themeDisplay);
        List portletCategories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
        portletCategories = ListUtil.sort((List)portletCategories, (Comparator)new PortletCategoryComparator(themeDisplay.getLocale()));
        for (PortletCategory currentPortletCategory : portletCategories) {
            if (currentPortletCategory.isHidden()) continue;
            String portletCategoryKey = StringUtil.replace((String)currentPortletCategory.getPath(), (String[])new String[]{"/", "."}, (String[])new String[]{"-", "-"});
            Map<String, JSONObject> childPortletCategoryJSONObjectsMap = this._getPortletCategoryJSONObjectsMap(highlightedPortletIds, httpServletRequest, currentPortletCategory, themeDisplay);
            JSONArray childPortletCategoriesJSONArray = JSONUtil.toJSONArray(childPortletCategoryJSONObjectsMap.values(), portletCategoryJSONObject -> portletCategoryJSONObject);
            JSONArray portletsJSONArray = this._getPortletsJSONArray(highlightedPortletIds, httpServletRequest, layoutDecodedPortletNames, currentPortletCategory, themeDisplay);
            if (childPortletCategoriesJSONArray.length() <= 0 && portletsJSONArray.length() <= 0) continue;
            portletCategoryJSONObjectsMap.put(portletCategoryKey, JSONUtil.put((String)"categories", (Object)childPortletCategoriesJSONArray).put("path", portletCategoryKey).put("portlets", portletsJSONArray).put("title", this._getPortletCategoryTitle(httpServletRequest, currentPortletCategory, themeDisplay)));
        }
        return portletCategoryJSONObjectsMap;
    }

    private String _getPortletCategoryTitle(HttpServletRequest httpServletRequest, PortletCategory portletCategory, ThemeDisplay themeDisplay) {
        for (String portletId : PortletCategoryUtil.getFirstChildPortletIds((PortletCategory)portletCategory)) {
            PortletConfig portletConfig;
            ResourceBundle portletResourceBundle;
            String title;
            PortletApp portletApp;
            Portlet portlet = this._portletLocalService.getPortletById(themeDisplay.getCompanyId(), portletId);
            if (portlet == null || !(portletApp = portlet.getPortletApp()).isWARFile() || !Validator.isNotNull((String)(title = ResourceBundleUtil.getString((ResourceBundle)(portletResourceBundle = (portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext())).getResourceBundle(themeDisplay.getLocale())), (String)portletCategory.getName())))) continue;
            return title;
        }
        return this._language.get(httpServletRequest, portletCategory.getName());
    }

    private JSONArray _getPortletItemsJSONArray(Portlet portlet, ThemeDisplay themeDisplay) {
        List portletItems = this._portletItemLocalService.getPortletItems(themeDisplay.getScopeGroupId(), portlet.getPortletId(), PortletPreferences.class.getName());
        if (ListUtil.isEmpty((List)portletItems)) {
            return this._jsonFactory.createJSONArray();
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (PortletItem portletItem : portletItems) {
            jsonArray.put(JSONUtil.put((String)"instanceable", (Object)portlet.isInstanceable()).put("portletId", portlet.getPortletId()).put("portletItemId", portletItem.getPortletItemId()).put("title", HtmlUtil.escape((String)portletItem.getName())));
        }
        return jsonArray;
    }

    private List<Portlet> _getPortlets(Set<String> highlightedPortletIds, PortletCategory portletCategory, ThemeDisplay themeDisplay) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Set<String> portletIds = portletCategory.getPortletIds();
        Layout layout = themeDisplay.getLayout();
        if (Objects.equals(portletCategory.getName(), "category.highlighted")) {
            portletIds = highlightedPortletIds;
        }
        for (String portletId : portletIds) {
            Portlet portlet = this._portletLocalService.getPortletById(themeDisplay.getCompanyId(), portletId);
            if (portlet == null || (layout.isTypeAssetDisplay() || layout.isTypeContent()) && ArrayUtil.contains((Object[])_UNSUPPORTED_PORTLETS_NAMES, (Object)portlet.getPortletName())) continue;
            try {
                if (!PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (Portlet)portlet, (String)"ADD_TO_PAGE")) continue;
                portlets.add(portlet);
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to check portlet permissions for " + portlet.getPortletId()), (Throwable)portalException);
            }
        }
        return portlets;
    }

    private JSONArray _getPortletsJSONArray(Set<String> highlightedPortletIds, HttpServletRequest httpServletRequest, Set<String> layoutDecodedPortletNames, PortletCategory portletCategory, ThemeDisplay themeDisplay) throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        HttpSession httpSession = httpServletRequest.getSession();
        ServletContext servletContext = httpSession.getServletContext();
        List portlets = this._getPortlets(highlightedPortletIds, portletCategory, themeDisplay);
        portlets = ListUtil.sort(portlets, (Comparator)new PortletTitleComparator(servletContext, themeDisplay.getLocale()));
        for (Portlet portlet : portlets) {
            jsonArray.put(JSONUtil.put((String)"highlighted", (Object)highlightedPortletIds.contains(portlet.getPortletId())).put("instanceable", portlet.isInstanceable()).put("portletId", portlet.getPortletId()).put("portletItems", this._getPortletItemsJSONArray(portlet, themeDisplay)).put("title", this._portal.getPortletTitle(portlet, servletContext, themeDisplay.getLocale())).put("used", () -> {
                Layout layout = themeDisplay.getLayout();
                if (!layout.isTypePortlet() || portlet.isInstanceable()) {
                    return false;
                }
                LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
                if (layoutDecodedPortletNames.contains(portlet.getPortletId()) || layoutTypePortlet.hasPortletId(portlet.getPortletId())) {
                    return true;
                }
                return false;
            }));
        }
        return jsonArray;
    }

    private List<String> _getSortedPortletCategoryKeys(PortalPreferences portalPreferences) {
        return PortalPreferencesUtil.getSortedPortalPreferencesValues((PortalPreferences)portalPreferences, (String)"com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", (String)"sortedPortletCategoryKeys");
    }
}

