/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.struts;

import com.liferay.portal.kernel.exception.LayoutTypeException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/edit_layout"}, service={StrutsAction.class})
public class EditLayoutStrutsAction
implements StrutsAction {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jsonObject;
        block2: {
            jsonObject = this._jsonFactory.createJSONObject();
            try {
                this._updateParentLayoutId(httpServletRequest);
                jsonObject.put("status", 200);
            }
            catch (LayoutTypeException layoutTypeException) {
                jsonObject.put("message", this._getLayoutTypeExceptionMessage(httpServletRequest, layoutTypeException));
                long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
                if (layoutTypeException.getType() != 2 || plid <= 0L) break block2;
                Layout layout = this._layoutLocalService.getLayout(plid);
                jsonObject.put("groupId", layout.getGroupId()).put("layoutId", layout.getLayoutId()).put("originalParentLayoutId", layout.getParentLayoutId()).put("originalParentPlid", layout.getParentPlid()).put("originalPriority", layout.getPriority()).put("plid", plid).put("status", 400);
            }
        }
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonObject.toString());
        return null;
    }

    private String _getLayoutTypeExceptionMessage(HttpServletRequest httpServletRequest, LayoutTypeException layoutTypeException) {
        if (layoutTypeException.getType() == 2) {
            return this._language.format(httpServletRequest, "you-cannot-move-this-page-because-the-resulting-order-would-place-a-page-of-type-x-as-the-first-page", (Object)("layout.types." + layoutTypeException.getLayoutType()));
        }
        if (layoutTypeException.getType() == 1) {
            return this._language.get(httpServletRequest, "a-page-cannot-become-a-child-of-a-page-that-is-not-parentable");
        }
        return "";
    }

    private void _updateParentLayoutId(HttpServletRequest httpServletRequest) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
        long parentPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentPlid");
        int priority = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"priority");
        this._layoutService.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
    }
}

