/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.struts;

import com.liferay.layout.util.LayoutsTree;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/get_layouts_tree"}, service={StrutsAction.class})
public class GetLayoutsTreeStrutsAction
implements StrutsAction {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutsTree _layoutsTree;
    @Reference
    private Portal _portal;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentLayoutId");
        boolean incomplete = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"incomplete", (boolean)true);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)JSONUtil.put((String)"hasMoreElements", () -> {
            int childLayoutsCount = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId);
            int start = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"start");
            start = Math.max(0, start);
            int pageSize = GetterUtil.getInteger((Object)PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN);
            int end = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"end", (int)(start + pageSize));
            if (childLayoutsCount > (end = Math.max(start, end))) {
                return true;
            }
            return false;
        }).put("items", this._layoutsTree.getLayoutsJSONArray(null, groupId, httpServletRequest, false, incomplete, false, parentLayoutId, privateLayout, "productMenuPagesTree")).toString());
        return null;
    }
}

