/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.struts;

import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.theme.ThemeUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/get_page_preview"}, service={StrutsAction.class})
public class GetPagePreviewStrutsAction
implements StrutsAction {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay currentThemeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ThemeDisplay themeDisplay = (ThemeDisplay)currentThemeDisplay.clone();
        long selPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"selPlid");
        if (selPlid > 0L) {
            Layout layout = this._layoutLocalService.fetchLayout(selPlid);
            themeDisplay.setLayout(layout);
            LayoutSet layoutSet = layout.getLayoutSet();
            themeDisplay.setLayoutSet(layoutSet);
            themeDisplay.setLookAndFeel(layoutSet.getTheme(), layoutSet.getColorScheme());
            themeDisplay.setPlid(layout.getPlid());
            themeDisplay.setScopeGroupId(layout.getGroupId());
        }
        if (!LayoutPermissionUtil.containsLayoutUpdatePermission((PermissionChecker)PermissionCheckerFactoryUtil.create((User)themeDisplay.getRealUser()), (Layout)themeDisplay.getLayout())) {
            httpServletResponse.setStatus(404);
            return null;
        }
        long[] currentSegmentsExperienceIds = GetterUtil.getLongValues((Object)httpServletRequest.getAttribute("SEGMENTS_EXPERIENCE_IDS"));
        Layout currentLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        boolean currentPortletDecorate = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("PORTLET_DECORATE"));
        try {
            long segmentsExperienceId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"segmentsExperienceId", (long)this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(selPlid));
            httpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)new long[]{segmentsExperienceId});
            httpServletRequest.setAttribute("PORTLET_DECORATE", (Object)Boolean.FALSE);
            String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId", (String)LocaleUtil.toLanguageId((Locale)themeDisplay.getLocale()));
            themeDisplay.setLocale(LocaleUtil.fromLanguageId((String)languageId));
            themeDisplay.setSignedIn(false);
            User guestUser = this._userLocalService.getGuestUser(themeDisplay.getCompanyId());
            themeDisplay.setUser(guestUser);
            Layout layout = themeDisplay.getLayout();
            layout.setClassNameId(0L);
            String className = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"className");
            long classPK = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"classPK");
            if (layout.isTypeAssetDisplay() && (Validator.isNull((String)className) || classPK <= 0L)) {
                layout.setType("content");
            }
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            ServiceContext clonedServiceContext = (ServiceContext)serviceContext.clone();
            clonedServiceContext.setPlid(layout.getPlid());
            clonedServiceContext.setScopeGroupId(layout.getGroupId());
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)clonedServiceContext);
            httpServletRequest.setAttribute("LAYOUT", (Object)layout);
            httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
            if (Validator.isNotNull((String)className) && classPK > 0L) {
                this._includeInfoItemObjects(className, classPK, httpServletRequest);
            }
            layout.includeLayoutContent(httpServletRequest, httpServletResponse);
            ServletContext servletContext = ServletContextPool.get((String)"");
            LayoutSet layoutSet = themeDisplay.getLayoutSet();
            Document document = Jsoup.parse((String)ThemeUtil.include((ServletContext)servletContext, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)"portal_normal.ftl", (Theme)layoutSet.getTheme(), (boolean)false));
            Element contentElement = document.getElementById("content");
            StringBundler sb = (StringBundler)httpServletRequest.getAttribute("LAYOUT_CONTENT");
            contentElement.html(sb.toString());
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)document.toString());
        }
        finally {
            httpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)currentSegmentsExperienceIds);
            httpServletRequest.setAttribute("LAYOUT", (Object)currentLayout);
            httpServletRequest.setAttribute("PORTLET_DECORATE", (Object)currentPortletDecorate);
            httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)currentThemeDisplay);
            ServiceContextThreadLocal.popServiceContext();
        }
        return null;
    }

    private void _includeInfoItemObjects(String className, long classPK, HttpServletRequest httpServletRequest) throws Exception {
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = new ClassPKInfoItemIdentifier(classPK);
        String version = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"version");
        if (Validator.isNotNull((String)version)) {
            classPKInfoItemIdentifier.setVersion(version);
        }
        Object infoItem = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)classPKInfoItemIdentifier);
        httpServletRequest.setAttribute("INFO_ITEM", infoItem);
        InfoItemDetailsProvider infoItemDetailsProvider = (InfoItemDetailsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemDetailsProvider.class, className);
        httpServletRequest.setAttribute("INFO_ITEM_DETAILS", (Object)infoItemDetailsProvider.getInfoItemDetails(infoItem));
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByClassName(className);
        httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_PROVIDER", (Object)layoutDisplayPageProvider);
        LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(className, classPK));
        if (layoutDisplayPageObjectProvider != null) {
            httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER", (Object)layoutDisplayPageObjectProvider);
        }
    }
}

