/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RobotsUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/robots"}, service={StrutsAction.class})
public class RobotsStrutsAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(RobotsStrutsAction.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            String host = GetterUtil.getString((String)this._portal.getForwardedHost(httpServletRequest));
            LayoutSet layoutSet = null;
            VirtualHost virtualHost = this._virtualHostLocalService.fetchVirtualHost(host);
            if (virtualHost != null && virtualHost.getLayoutSetId() > 0L) {
                layoutSet = this._layoutSetLocalService.fetchLayoutSet(host);
            } else {
                Company company = this._portal.getCompany(httpServletRequest);
                if (host.equals(company.getVirtualHostname()) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) {
                    Group defaultGroup = this._groupLocalService.getGroup(company.getCompanyId(), PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                    layoutSet = defaultGroup.getPublicLayoutSet();
                }
            }
            String robots = RobotsUtil.getRobots((LayoutSet)layoutSet, (boolean)httpServletRequest.isSecure());
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null, (byte[])robots.getBytes("UTF-8"), (String)"text/plain; charset=UTF-8");
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            this._portal.sendError(500, exception, httpServletRequest, httpServletResponse);
        }
        return null;
    }
}

