/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.struts;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SessionTreeJSClicks;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ConcurrentModificationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/session_tree_js_click"}, service={StrutsAction.class})
public class SessionTreeJSClickStrutsAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(SessionTreeJSClickStrutsAction.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
            String treeId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"treeId");
            if (cmd.equals("collapse")) {
                SessionTreeJSClicks.closeNodes((HttpServletRequest)httpServletRequest, (String)treeId);
            } else if (cmd.equals("expand")) {
                String[] nodeIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"nodeIds"));
                SessionTreeJSClicks.openNodes((HttpServletRequest)httpServletRequest, (String)treeId, (String[])nodeIds);
            } else if (cmd.equals("layoutCheck")) {
                long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
                if (plid == 0L) {
                    boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
                    SessionTreeJSClicks.openLayoutNodes((HttpServletRequest)httpServletRequest, (String)treeId, (boolean)privateLayout, (long)0L, (boolean)true);
                } else {
                    boolean recursive = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"recursive");
                    Layout layout = this._layoutLocalService.getLayout(plid);
                    SessionTreeJSClicks.openLayoutNodes((HttpServletRequest)httpServletRequest, (String)treeId, (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (boolean)recursive);
                }
            } else if (!cmd.equals("layoutCollapse")) {
                if (cmd.equals("layoutUncheck")) {
                    long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
                    if (plid == 0L) {
                        SessionTreeJSClicks.closeNodes((HttpServletRequest)httpServletRequest, (String)treeId);
                    } else {
                        boolean recursive = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"recursive");
                        Layout layout = this._layoutLocalService.getLayout(plid);
                        SessionTreeJSClicks.closeLayoutNodes((HttpServletRequest)httpServletRequest, (String)treeId, (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (boolean)recursive);
                    }
                } else if (!cmd.equals("layoutUncollapse")) {
                    String nodeId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"nodeId");
                    boolean openNode = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"openNode");
                    if (openNode) {
                        SessionTreeJSClicks.openNode((HttpServletRequest)httpServletRequest, (String)treeId, (String)nodeId);
                    } else {
                        SessionTreeJSClicks.closeNode((HttpServletRequest)httpServletRequest, (String)treeId, (String)nodeId);
                    }
                }
            }
            if (!cmd.isEmpty()) {
                this.updateCheckedLayoutPlids(httpServletRequest, treeId);
            }
            httpServletResponse.setContentType("application/json");
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)httpServletRequest);
            String json = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId + "Plid");
            if (Validator.isNotNull((String)json)) {
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)json);
            }
        }
        catch (Exception exception) {
            this._portal.sendError(exception, httpServletRequest, httpServletResponse);
        }
        return null;
    }

    protected void updateCheckedLayoutPlids(HttpServletRequest httpServletRequest, String treeId) {
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        while (true) {
            try {
                long[] checkedLayoutIds;
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)httpServletRequest);
                for (long checkedLayoutId : checkedLayoutIds = StringUtil.split((String)portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId), (long)0L)) {
                    Layout checkedLayout;
                    if (checkedLayoutId == 0L) {
                        jsonArray.put(String.valueOf(0L));
                    }
                    if ((checkedLayout = this._layoutLocalService.fetchLayout(groupId, privateLayout, checkedLayoutId)) == null) continue;
                    jsonArray.put(String.valueOf(checkedLayout.getPlid()));
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId + "Plid", jsonArray.toString());
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)concurrentModificationException);
                continue;
            }
            break;
        }
    }
}

