/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.struts;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.action.RenderPortletAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.AddPortletProvider;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.render.PortletRenderParts;
import com.liferay.portal.kernel.portlet.render.PortletRenderUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.struts.Action;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/update_layout"}, service={StrutsAction.class})
public class UpdateLayoutStrutsAction
implements StrutsAction {
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    private ServiceTrackerMap<String, AddPortletProvider> _serviceTrackerMap;
    @Reference
    private Staging _staging;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
        String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
        boolean updateLayout = true;
        if (cmd.equals("add")) {
            if (portletId == null) {
                throw new IllegalArgumentException("Portlet ID is null");
            }
            String columnId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_col_id", null);
            int columnPos = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"p_p_col_pos", (int)-1);
            String originalPortletId = portletId;
            if ((portletId = layoutTypePortlet.addPortletId(userId, portletId, columnId, columnPos)) == null) {
                throw new PortalException(StringBundler.concat((Object[])new Object[]{"Portlet ", originalPortletId, " cannot be added to layout ", layout.getPlid(), " by user ", userId}));
            }
            this.storeAddContentPortletPreferences(httpServletRequest, layout, portletId, themeDisplay);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("delete")) {
            if (layoutTypePortlet.hasPortletId(portletId)) {
                layoutTypePortlet.removePortletId(userId, portletId);
                if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
                    updateLayout = false;
                }
            }
        } else if (cmd.equals("minimize")) {
            boolean restore = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"p_p_restore");
            if (restore) {
                layoutTypePortlet.removeStateMinPortletId(portletId);
            } else {
                layoutTypePortlet.addStateMinPortletId(portletId);
            }
            updateLayout = false;
        } else if (cmd.equals("move")) {
            String columnId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_col_id");
            int columnPos = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"p_p_col_pos");
            layoutTypePortlet.movePortletId(userId, portletId, columnId, columnPos);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("redo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            this._layoutRevisionLocalService.updateStatus(userId, layoutRevisionId, 2, serviceContext);
            this._staging.setRecentLayoutRevisionId(httpServletRequest, layoutSetBranchId, layout.getPlid(), layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("select_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutSetBranchId");
            this._staging.setRecentLayoutRevisionId(httpServletRequest, layoutSetBranchId, layout.getPlid(), layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("update_type_settings")) {
            UnicodeProperties layoutTypeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
            UnicodeProperties formTypeSettingsUnicodeProperties = PropertiesParamUtil.getProperties((HttpServletRequest)httpServletRequest, (String)"TypeSettingsProperties--");
            layoutTypeSettingsUnicodeProperties.putAll((Map)formTypeSettingsUnicodeProperties);
        } else if (cmd.equals("undo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            LayoutRevision layoutRevision = this._layoutRevisionLocalService.updateStatus(userId, layoutRevisionId, 5, serviceContext);
            this._staging.setRecentLayoutRevisionId(httpServletRequest, layoutSetBranchId, layout.getPlid(), layoutRevision.getParentLayoutRevisionId());
            updateLayout = false;
        }
        if (updateLayout) {
            layoutTypePortlet.resetModes();
            layoutTypePortlet.resetStates();
            layout = this._layoutService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        } else {
            LayoutClone layoutClone = LayoutCloneFactory.getInstance();
            if (layoutClone != null) {
                layoutClone.update(httpServletRequest, layout.getPlid(), layout.getTypeSettings());
            }
        }
        if (cmd.equals("add") && portletId != null) {
            this.addPortlet(httpServletRequest, httpServletResponse, portletId);
        }
        return "";
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, AddPortletProvider.class, (String)"model.class.name");
    }

    protected void addPortlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId) throws Exception {
        Action renderPortletAction = (Action)InstancePool.get((String)RenderPortletAction.class.getName());
        Portlet portlet = this._portletLocalService.getPortletById(this._portal.getCompanyId(httpServletRequest), portletId);
        DynamicServletRequest dynamicRequest = null;
        if (portlet.isPrivateRequestAttributes()) {
            String portletNamespace = this._portal.getPortletNamespace(portlet.getPortletId());
            dynamicRequest = new NamespaceServletRequest(httpServletRequest, portletNamespace, portletNamespace);
        } else {
            dynamicRequest = new DynamicServletRequest(httpServletRequest);
        }
        dynamicRequest.setParameter("p_p_id", portletId);
        String dataType = StringUtil.toLowerCase((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"dataType"));
        if (dataType.equals("json")) {
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
            renderPortletAction.execute(null, (HttpServletRequest)dynamicRequest, (HttpServletResponse)bufferCacheServletResponse);
            String portletHTML = bufferCacheServletResponse.getString();
            portletHTML = portletHTML.trim();
            PortletRenderParts portletRenderParts = PortletRenderUtil.getPortletRenderParts((HttpServletRequest)httpServletRequest, (String)portletHTML, (Portlet)portlet);
            JSONObject jsonObject = JSONUtil.put((String)"footerCssPaths", (Object)portletRenderParts.getFooterCssPaths()).put("footerJavaScriptPaths", (Object)portletRenderParts.getFooterJavaScriptPaths()).put("headerCssPaths", (Object)portletRenderParts.getHeaderCssPaths()).put("headerJavaScriptPaths", (Object)portletRenderParts.getHeaderJavaScriptPaths()).put("portletHTML", portletRenderParts.getPortletHTML()).put("refresh", portletRenderParts.isRefresh());
            httpServletResponse.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonObject.toString());
        } else {
            renderPortletAction.execute(null, (HttpServletRequest)dynamicRequest, httpServletResponse);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void storeAddContentPortletPreferences(HttpServletRequest httpServletRequest, Layout layout, String portletId, ThemeDisplay themeDisplay) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String[] portletData = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"portletData"));
        if (portletData.length == 0) {
            return;
        }
        long classPK = GetterUtil.getLong((String)portletData[0]);
        String className = GetterUtil.getString((String)portletData[1]);
        if (classPK <= 0L || Validator.isNull((String)className)) {
            return;
        }
        AddPortletProvider addPortletProvider = (AddPortletProvider)this._serviceTrackerMap.getService((Object)className);
        if (addPortletProvider == null) {
            addPortletProvider = (AddPortletProvider)this._serviceTrackerMap.getService((Object)AssetEntry.class.getName());
        }
        if (addPortletProvider != null) {
            addPortletProvider.updatePortletPreferences(portletSetup, portletId, className, classPK, themeDisplay);
        }
        portletSetup.store();
    }
}

