/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.CopyLayoutThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.sites.kernel.util.Sites;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutCopyHelper.class})
public class LayoutCopyHelperImpl
implements LayoutCopyHelper {
    private static final Log _log = LogFactoryUtil.getLog(LayoutCopyHelperImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private Sites _sites;

    public Layout copyLayoutContent(Layout sourceLayout, Layout targetLayout) throws Exception {
        return this.copyLayoutContent(TransformUtil.transformToLongArray((Collection)this._segmentsExperienceLocalService.getSegmentsExperiences(sourceLayout.getGroupId(), this._portal.getClassNameId(Layout.class), sourceLayout.getPlid()), SegmentsExperienceModel::getSegmentsExperienceId), sourceLayout, targetLayout);
    }

    public Layout copyLayoutContent(long segmentsExperienceId, Layout sourceLayout, Layout targetLayout) throws Exception {
        long defaultSegmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid());
        Consumer<Layout> consumer = processedTargetLayout -> {
            block2: {
                try {
                    this._copyLayoutPageTemplateStructureFromSegmentsExperience(sourceLayout, segmentsExperienceId, (Layout)processedTargetLayout, defaultSegmentsExperienceId);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Throwable)exception);
                }
            }
        };
        CopyLayoutCallable callable = new CopyLayoutCallable(consumer, sourceLayout, new long[]{segmentsExperienceId}, targetLayout, new long[]{defaultSegmentsExperienceId});
        boolean copyLayout = CopyLayoutThreadLocal.isCopyLayout();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            CopyLayoutThreadLocal.setCopyLayout((boolean)true);
            Layout layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            return layout;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        finally {
            CopyLayoutThreadLocal.setCopyLayout((boolean)copyLayout);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    public Layout copyLayoutContent(long[] segmentsExperiencesIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        Consumer<Layout> consumer = processedTargetLayout -> {
            block2: {
                try {
                    this._copyLayoutPageTemplateStructure(segmentsExperiencesIds, sourceLayout, (Layout)processedTargetLayout);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Throwable)exception);
                }
            }
        };
        CopyLayoutCallable callable = new CopyLayoutCallable(consumer, sourceLayout, segmentsExperiencesIds, targetLayout, segmentsExperiencesIds);
        boolean copyLayout = CopyLayoutThreadLocal.isCopyLayout();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            CopyLayoutThreadLocal.setCopyLayout((boolean)true);
            Layout layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            return layout;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        finally {
            CopyLayoutThreadLocal.setCopyLayout((boolean)copyLayout);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    private void _copyAssetCategoryIdsAndAssetTagNames(Layout sourceLayout, Layout targetLayout) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        this._layoutLocalService.updateAsset(targetLayout.getUserId(), targetLayout, this._assetCategoryLocalService.getCategoryIds(Layout.class.getName(), sourceLayout.getPlid()), this._assetTagLocalService.getTagNames(Layout.class.getName(), sourceLayout.getPlid()));
    }

    private void _copyLayoutClassedModelUsages(Layout sourceLayout, Layout targetLayout) {
        List sourceLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(sourceLayout.getPlid());
        this._deleteLayoutClassedModelUsages(sourceLayoutLayoutClassedModelUsages, targetLayout);
        List targetLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid());
        for (LayoutClassedModelUsage sourceLayoutLayoutClassedModelUsage : sourceLayoutLayoutClassedModelUsages) {
            if (this._hasLayoutClassedModelUsage(targetLayoutLayoutClassedModelUsages, sourceLayoutLayoutClassedModelUsage)) continue;
            String containerKey = sourceLayoutLayoutClassedModelUsage.getContainerKey();
            long containerType = sourceLayoutLayoutClassedModelUsage.getContainerType();
            if (containerType == this._portal.getClassNameId(FragmentEntryLink.class.getName())) {
                long fragmentEntryLinkId = GetterUtil.getLong((String)sourceLayoutLayoutClassedModelUsage.getContainerKey());
                FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(sourceLayout.getGroupId(), fragmentEntryLinkId, targetLayout.getPlid());
                if (fragmentEntryLink != null) {
                    containerKey = String.valueOf(fragmentEntryLink.getFragmentEntryLinkId());
                }
            }
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsage.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), containerKey, sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid(), ServiceContextThreadLocal.getServiceContext());
        }
    }

    private void _copyLayoutPageTemplateStructure(long[] segmentsExperiencesIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        if (layoutPageTemplateStructure == null) {
            LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
            if (targetLayoutPageTemplateStructure != null) {
                this._layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(targetLayoutPageTemplateStructure);
            }
            this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(targetLayout.getGroupId(), targetLayout.getPlid());
            layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.rebuildLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        }
        HashMap<Long, FragmentEntryLink> fragmentEntryLinksMap = new HashMap<Long, FragmentEntryLink>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(sourceLayout.getGroupId(), segmentsExperiencesIds, sourceLayout.getPlid())) {
            fragmentEntryLinksMap.put(fragmentEntryLink.getFragmentEntryLinkId(), fragmentEntryLink);
        }
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(targetLayout.getGroupId(), segmentsExperiencesIds, targetLayout.getPlid());
        LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
        if (targetLayoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(targetLayout.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()), null, ServiceContextThreadLocal.getServiceContext());
        }
        Map<Long, Long> segmentsExperienceIdsMap = this._getSegmentsExperienceIds(segmentsExperiencesIds, sourceLayout, targetLayout);
        for (Map.Entry<Long, Long> entry : segmentsExperienceIdsMap.entrySet()) {
            String data = layoutPageTemplateStructure.getData(entry.getKey().longValue());
            if (Validator.isNull((String)data)) {
                this._segmentsExperienceLocalService.deleteSegmentsExperience(entry.getKey().longValue());
                continue;
            }
            JSONObject dataJSONObject = this._processDataJSONObject(LayoutStructure.of((String)data), targetLayout, fragmentEntryLinksMap, entry.getValue());
            this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), entry.getValue().longValue(), dataJSONObject.toString());
        }
    }

    private void _copyLayoutPageTemplateStructureFromSegmentsExperience(Layout sourceLayout, long sourceSegmentsExperienceId, Layout targetLayout, long targetSegmentsExperienceId) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        String data = layoutPageTemplateStructure.getData(sourceSegmentsExperienceId);
        if (Validator.isNull((String)data)) {
            return;
        }
        HashMap<Long, FragmentEntryLink> fragmentEntryLinksMap = new HashMap<Long, FragmentEntryLink>();
        for (Object fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(sourceLayout.getGroupId(), sourceSegmentsExperienceId, sourceLayout.getPlid())) {
            fragmentEntryLinksMap.put(fragmentEntryLink.getFragmentEntryLinkId(), (FragmentEntryLink)fragmentEntryLink);
        }
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : layoutStructure.getDeletedLayoutStructureItems()) {
            layoutStructure.deleteLayoutStructureItem(deletedLayoutStructureItem.getItemId());
        }
        JSONObject dataJSONObject = this._processDataJSONObject(layoutStructure, targetLayout, fragmentEntryLinksMap, targetSegmentsExperienceId);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), targetSegmentsExperienceId, dataJSONObject.toString());
    }

    private void _copyLayoutSEOEntry(Layout sourceLayout, Layout targetLayout) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getLayoutId());
        if (layoutSEOEntry == null) {
            LayoutSEOEntry targetLayoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            if (targetLayoutSEOEntry != null) {
                this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            }
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this._layoutSEOEntryLocalService.copyLayoutSEOEntry(targetLayout.getUserId(), targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.getDDMStorageId(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), layoutSEOEntry.getOpenGraphImageFileEntryId(), layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), serviceContext);
    }

    private void _copyPortletPermissions(List<String> portletIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        for (String portletId : portletIds) {
            String resourceName = PortletIdCodec.decodePortletName((String)portletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)portletId);
            Map sourceRoleIdsToActionIds = this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, (Collection)ResourceActionsUtil.getPortletResourceActions((String)resourceName));
            if (sourceRoleIdsToActionIds.isEmpty()) continue;
            Group targetGroup = targetLayout.getGroup();
            HashSet<Long> roleIds = new HashSet<Long>();
            for (Role role : this._roleLocalService.getGroupRelatedRoles(targetLayout.getGroupId())) {
                String roleName = role.getName();
                if (roleName.equals("Administrator") || !targetGroup.isLayoutSetPrototype() && targetLayout.isPrivateLayout() && roleName.equals("Guest")) continue;
                roleIds.add(role.getRoleId());
            }
            HashMap<Long, String[]> targetRoleIdsToActionIds = new HashMap<Long, String[]>();
            for (Map.Entry entry : sourceRoleIdsToActionIds.entrySet()) {
                Long roleId = (Long)entry.getKey();
                if (!roleIds.contains(roleId)) continue;
                Set sourceActionIds = (Set)entry.getValue();
                targetRoleIdsToActionIds.put(roleId, sourceActionIds.toArray(new String[0]));
            }
            this._resourcePermissionLocalService.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)portletId), targetRoleIdsToActionIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyPortletPreferences(List<String> portletIds, Layout sourceLayout, Layout targetLayout) {
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled((boolean)false);
            for (String portletId : portletIds) {
                PortletPreferencesIds portletPreferencesIds;
                javax.portlet.PortletPreferences jxPortletPreferences;
                Portlet portlet = this._portletLocalService.getPortletById(portletId);
                if (portlet == null || portlet.isUndeployedPortlet() || (jxPortletPreferences = this._portletPreferencesLocalService.fetchPreferences(portletPreferencesIds = this._portletPreferencesFactory.getPortletPreferencesIds(sourceLayout.getCompanyId(), sourceLayout.getGroupId(), 0L, sourceLayout.getPlid(), portletId))) == null) continue;
                PortletPreferences targetPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId);
                if (targetPortletPreferences != null) {
                    this._portletPreferencesLocalService.updatePreferences(targetPortletPreferences.getOwnerId(), targetPortletPreferences.getOwnerType(), targetPortletPreferences.getPlid(), targetPortletPreferences.getPortletId(), jxPortletPreferences);
                    continue;
                }
                this._portletPreferencesLocalService.addPortletPreferences(targetLayout.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId, portlet, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
            }
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
        }
    }

    private void _deleteLayoutClassedModelUsages(List<LayoutClassedModelUsage> sourceLayoutLayoutClassedModelUsages, Layout targetLayout) {
        for (LayoutClassedModelUsage targetLayoutClassedModelUsage : this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid())) {
            if (this._hasLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsages, targetLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(targetLayoutClassedModelUsage);
        }
    }

    private void _deletePortletPermissions(Layout layout, long[] segmentsExperiencesIds) throws Exception {
        for (String portletId : this._getLayoutPortletIds(layout, segmentsExperiencesIds)) {
            this._resourcePermissionLocalService.deleteResourcePermissions(layout.getCompanyId(), PortletIdCodec.decodePortletName((String)portletId), 4, PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
        }
    }

    private List<String> _getLayoutPortletIds(Layout layout, long[] segmentsExperiencesIds) {
        ArrayList<String> layoutPortletIds = new ArrayList<String>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(layout.getGroupId(), segmentsExperiencesIds, layout.getPlid())) {
            layoutPortletIds.addAll(this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink));
        }
        return layoutPortletIds;
    }

    private Map<Long, Long> _getSegmentsExperienceIds(long[] segmentsExperiencesIds, Layout sourceLayout, Layout targetLayout) {
        HashMap<Long, Long> segmentsExperienceIdsMap = new HashMap<Long, Long>();
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            for (long segmentsExperienceId : segmentsExperiencesIds) {
                SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
                if (Objects.equals(segmentsExperience.getSegmentsExperienceKey(), "DEFAULT")) {
                    segmentsExperienceIdsMap.put(segmentsExperience.getSegmentsExperienceId(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()));
                    continue;
                }
                segmentsExperienceIdsMap.put(segmentsExperienceId, segmentsExperienceId);
            }
            return segmentsExperienceIdsMap;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (long segmentsExperienceId : segmentsExperiencesIds) {
            SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
            if (Objects.equals(segmentsExperience.getSegmentsExperienceKey(), "DEFAULT")) {
                segmentsExperienceIdsMap.put(segmentsExperience.getSegmentsExperienceId(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()));
                continue;
            }
            SegmentsExperience newSegmentsExperience = (SegmentsExperience)segmentsExperience.clone();
            newSegmentsExperience.setUuid(serviceContext.getUuid());
            newSegmentsExperience.setSegmentsExperienceId(this._counterLocalService.increment());
            newSegmentsExperience.setUserId(targetLayout.getUserId());
            newSegmentsExperience.setUserName(targetLayout.getUserName());
            newSegmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
            newSegmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newSegmentsExperience.setSegmentsExperienceKey(String.valueOf(this._counterLocalService.increment()));
            newSegmentsExperience.setClassNameId(this._portal.getClassNameId(Layout.class));
            newSegmentsExperience.setClassPK(targetLayout.getPlid());
            this._segmentsExperienceLocalService.addSegmentsExperience(newSegmentsExperience);
            segmentsExperienceIdsMap.put(segmentsExperience.getSegmentsExperienceId(), newSegmentsExperience.getSegmentsExperienceId());
        }
        return segmentsExperienceIdsMap;
    }

    private boolean _hasLayoutClassedModelUsage(List<LayoutClassedModelUsage> layoutClassedModelUsages, LayoutClassedModelUsage targetLayoutClassedModelUsage) {
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            if (layoutClassedModelUsage.getClassNameId() != targetLayoutClassedModelUsage.getClassNameId() || layoutClassedModelUsage.getClassPK() != targetLayoutClassedModelUsage.getClassPK() || !Objects.equals(layoutClassedModelUsage.getContainerKey(), targetLayoutClassedModelUsage.getContainerKey()) || layoutClassedModelUsage.getContainerType() != targetLayoutClassedModelUsage.getContainerType()) continue;
            return true;
        }
        return false;
    }

    private JSONObject _processDataJSONObject(LayoutStructure layoutStructure, Layout targetLayout, Map<Long, FragmentEntryLink> fragmentEntryLinksMap, long targetSegmentsExperienceId) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            FragmentEntryLink fragmentEntryLink;
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (fragmentEntryLink = fragmentEntryLinksMap.get((fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId())) == null) continue;
            FragmentEntryLink newFragmentEntryLink = (FragmentEntryLink)fragmentEntryLink.clone();
            newFragmentEntryLink.setUuid(serviceContext.getUuid());
            newFragmentEntryLink.setFragmentEntryLinkId(this._counterLocalService.increment());
            newFragmentEntryLink.setUserId(targetLayout.getUserId());
            newFragmentEntryLink.setUserName(targetLayout.getUserName());
            newFragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
            newFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newFragmentEntryLink.setOriginalFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId());
            newFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
            newFragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
            newFragmentEntryLink.setClassPK(targetLayout.getPlid());
            newFragmentEntryLink.setPlid(targetLayout.getPlid());
            newFragmentEntryLink.setLastPropagationDate(serviceContext.getCreateDate(new Date()));
            newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(newFragmentEntryLink);
            fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(newFragmentEntryLink.getFragmentEntryLinkId());
            this._commentManager.copyDiscussion(targetLayout.getUserId(), targetLayout.getGroupId(), FragmentEntryLink.class.getName(), fragmentEntryLink.getFragmentEntryLinkId(), newFragmentEntryLink.getFragmentEntryLinkId(), className -> serviceContext);
        }
        return layoutStructure.toJSONObject();
    }

    private class CopyLayoutCallable
    implements Callable<Layout> {
        private final Consumer<Layout> _consumer;
        private final Layout _sourceLayout;
        private final long[] _sourceSegmentsExperiencesIds;
        private final Layout _targetLayout;
        private final long[] _targetSegmentsExperiencesIds;

        @Override
        public Layout call() throws Exception {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext == null) {
                ServiceContextThreadLocal.pushServiceContext((ServiceContext)new ServiceContext());
            }
            if (Objects.equals(this._sourceLayout.getType(), "portlet")) {
                LayoutCopyHelperImpl.this._sites.copyPortletPermissions(this._targetLayout, this._sourceLayout);
            } else {
                LayoutCopyHelperImpl.this._deletePortletPermissions(this._targetLayout, this._targetSegmentsExperiencesIds);
                this._consumer.accept(this._targetLayout);
                List portletIds = LayoutCopyHelperImpl.this._getLayoutPortletIds(this._sourceLayout, this._sourceSegmentsExperiencesIds);
                LayoutCopyHelperImpl.this._copyPortletPermissions(portletIds, this._sourceLayout, this._targetLayout);
                LayoutCopyHelperImpl.this._copyPortletPreferences(portletIds, this._sourceLayout, this._targetLayout);
            }
            LayoutCopyHelperImpl.this._copyLayoutClassedModelUsages(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._sites.copyExpandoBridgeAttributes(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._sites.copyPortletSetups(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyAssetCategoryIdsAndAssetTagNames(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyLayoutSEOEntry(this._sourceLayout, this._targetLayout);
            this._copyLayoutClientExtensions(this._sourceLayout, this._targetLayout);
            Image image = LayoutCopyHelperImpl.this._imageLocalService.getImage(this._sourceLayout.getIconImageId());
            byte[] imageBytes = null;
            if (image != null) {
                imageBytes = image.getTextObj();
            }
            return LayoutCopyHelperImpl.this._layoutLocalService.updateLayout(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), this._sourceLayout.getTypeSettings(), imageBytes, this._sourceLayout.getThemeId(), this._sourceLayout.getColorSchemeId(), this._sourceLayout.getStyleBookEntryId(), this._sourceLayout.getCss(), this._sourceLayout.getFaviconFileEntryId(), this._sourceLayout.getMasterLayoutPlid());
        }

        private CopyLayoutCallable(Consumer<Layout> consumer, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds) {
            this._consumer = consumer;
            this._sourceLayout = sourceLayout;
            this._sourceSegmentsExperiencesIds = sourceSegmentsExperiencesIds;
            this._targetLayout = targetLayout;
            this._targetSegmentsExperiencesIds = targetSegmentsExperiencesIds;
        }

        private void _copyLayoutClientExtensions(Layout sourceLayout, Layout targetLayout) throws Exception {
            long classNameId = LayoutCopyHelperImpl.this._portal.getClassNameId(Layout.class);
            LayoutCopyHelperImpl.this._clientExtensionEntryRelLocalService.deleteClientExtensionEntryRels(classNameId, targetLayout.getPlid());
            List clientExtensionEntryRels = LayoutCopyHelperImpl.this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, sourceLayout.getPlid());
            for (ClientExtensionEntryRel clientExtensionEntryRel : clientExtensionEntryRels) {
                LayoutCopyHelperImpl.this._clientExtensionEntryRelLocalService.addClientExtensionEntryRel(targetLayout.getUserId(), targetLayout.getGroupId(), classNameId, targetLayout.getPlid(), clientExtensionEntryRel.getCETExternalReferenceCode(), clientExtensionEntryRel.getType(), clientExtensionEntryRel.getTypeSettings(), ServiceContextThreadLocal.getServiceContext());
            }
        }
    }
}

