/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.application.list.GroupProvider;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.layout.internal.action.provider.LayoutActionProvider;
import com.liferay.layout.security.permission.resource.LayoutContentModelResourcePermission;
import com.liferay.layout.util.LayoutsTree;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.util.PropsValues;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutsTree.class})
public class LayoutsTreeImpl
implements LayoutsTree {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupProvider _groupProvider;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutContentModelResourcePermission _layoutContentModelResourcePermission;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPermission _layoutPermission;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    @Reference
    private Staging _staging;

    public JSONArray getLayoutsJSONArray(long[] expandedLayoutIds, long groupId, HttpServletRequest httpServletRequest, boolean includeActions, boolean incomplete, boolean loadMore, long parentLayoutId, boolean privateLayout, String treeId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._getLayoutsJSONArray(this._getAncestorLayouts(httpServletRequest), false, expandedLayoutIds, groupId, httpServletRequest, includeActions, incomplete, loadMore, parentLayoutId, privateLayout, themeDisplay, treeId);
    }

    private Layout _fetchCurrentLayout(HttpServletRequest httpServletRequest) {
        long selPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"selPlid");
        if (selPlid > 0L) {
            return this._layoutLocalService.fetchLayout(selPlid);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        return null;
    }

    private List<Layout> _getAncestorLayouts(HttpServletRequest httpServletRequest) throws Exception {
        Layout layout = this._fetchCurrentLayout(httpServletRequest);
        if (layout == null) {
            return Collections.emptyList();
        }
        List ancestorLayouts = this._layoutService.getAncestorLayouts(layout.getPlid());
        ancestorLayouts.add(layout);
        return ancestorLayouts;
    }

    private Layout _getDraftLayout(Layout layout) {
        if (!layout.isTypeContent()) {
            return null;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            return null;
        }
        if (draftLayout.isDraft() || !layout.isPublished()) {
            return draftLayout;
        }
        return null;
    }

    private JSONArray _getLayoutsJSONArray(List<Layout> ancestorLayouts, boolean childLayout, long[] expandedLayoutIds, long groupId, HttpServletRequest httpServletRequest, boolean includeActions, boolean incomplete, boolean loadMore, long parentLayoutId, boolean privateLayout, ThemeDisplay themeDisplay, String treeId) throws Exception {
        int count = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId);
        if (count <= 0) {
            return this._jsonFactory.createJSONArray();
        }
        JSONArray layoutsJSONArray = this._jsonFactory.createJSONArray();
        List<Layout> layouts = this._getPaginatedLayouts(httpServletRequest, groupId, privateLayout, parentLayoutId, loadMore, incomplete, treeId, childLayout, count, this._layoutLocalService.getLayoutsCount(this._groupLocalService.getGroup(groupId), privateLayout, parentLayoutId));
        Layout afterDeleteSelectedLayout = null;
        Layout secondLayout = null;
        int index = 0;
        for (Layout layout : layouts) {
            if (index == 1) {
                secondLayout = layout;
                break;
            }
            ++index;
        }
        for (Layout layout : layouts) {
            int childLayoutsCount = 0;
            JSONArray childLayoutsJSONArray = null;
            if (this._isExpandableLayout(ancestorLayouts, expandedLayoutIds, layout)) {
                if (layout instanceof VirtualLayout) {
                    VirtualLayout virtualLayout = (VirtualLayout)layout;
                    childLayoutsJSONArray = this._getLayoutsJSONArray(ancestorLayouts, true, expandedLayoutIds, virtualLayout.getSourceGroupId(), httpServletRequest, includeActions, incomplete, loadMore, virtualLayout.getLayoutId(), virtualLayout.isPrivateLayout(), themeDisplay, treeId);
                } else {
                    childLayoutsJSONArray = this._getLayoutsJSONArray(ancestorLayouts, true, expandedLayoutIds, groupId, httpServletRequest, includeActions, incomplete, loadMore, layout.getLayoutId(), layout.isPrivateLayout(), themeDisplay, treeId);
                }
                childLayoutsCount = childLayoutsJSONArray.length();
            } else {
                childLayoutsCount = this._layoutService.getLayoutsCount(groupId, privateLayout, layout.getLayoutId());
                childLayoutsJSONArray = this._jsonFactory.createJSONArray();
            }
            if (includeActions) {
                if (afterDeleteSelectedLayout == null && layout.getParentLayoutId() != 0L) {
                    afterDeleteSelectedLayout = this._layoutLocalService.fetchLayout(layout.getParentPlid());
                }
                if (afterDeleteSelectedLayout == null) {
                    afterDeleteSelectedLayout = secondLayout;
                }
            }
            layoutsJSONArray.put(this._toJSONObject(afterDeleteSelectedLayout, childLayoutsCount, childLayoutsJSONArray, httpServletRequest, includeActions, layout, themeDisplay));
            if (!includeActions) continue;
            afterDeleteSelectedLayout = layout;
        }
        return layoutsJSONArray;
    }

    private int _getLoadedLayoutsCount(HttpSession httpSession, long groupId, boolean privateLayout, long layoutId, String treeId) throws Exception {
        String key = StringBundler.concat((Object[])new Object[]{treeId, ":", groupId, ":", privateLayout, ":Pagination"});
        String paginationJSON = SessionClicks.get((HttpSession)httpSession, (String)key, (String)this._jsonFactory.getNullJSON());
        JSONObject paginationJSONObject = this._jsonFactory.createJSONObject(paginationJSON);
        return paginationJSONObject.getInt(String.valueOf(layoutId), 0);
    }

    private List<Layout> _getPaginatedLayouts(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, boolean loadMore, boolean incomplete, String treeId, boolean childLayout, int count, int totalCount) throws Exception {
        if (!this._isPaginationEnabled(httpServletRequest)) {
            return this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, -1, -1);
        }
        int loadedLayoutsCount = this._getLoadedLayoutsCount(httpServletRequest.getSession(), groupId, privateLayout, parentLayoutId, treeId);
        int start = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"start");
        int end = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"end", (int)((start = Math.max(0, Math.min(start, count))) + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN));
        if (loadedLayoutsCount > end) {
            end = loadedLayoutsCount;
        }
        if (loadMore) {
            String key = StringBundler.concat((Object[])new Object[]{treeId, ":", groupId, ":", privateLayout, ":Pagination"});
            String paginationJSON = SessionClicks.get((HttpSession)httpServletRequest.getSession(), (String)key, (String)this._jsonFactory.getNullJSON());
            JSONObject paginationJSONObject = this._jsonFactory.createJSONObject(paginationJSON);
            paginationJSONObject.put(String.valueOf(parentLayoutId), end);
            SessionClicks.put((HttpSession)httpServletRequest.getSession(), (String)key, (String)paginationJSONObject.toString());
        }
        end = Math.max(start, Math.min(end, count));
        if (childLayout && count > PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN && start == PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN) {
            start = end;
        }
        if (count != totalCount) {
            List layouts = this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, -1, -1);
            return layouts.subList(start, end);
        }
        return this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end);
    }

    private boolean _isExpandableLayout(List<Layout> ancestorLayouts, long[] expandedLayoutIds, Layout layout) {
        return ancestorLayouts.contains(layout) || ArrayUtil.contains((long[])expandedLayoutIds, (long)layout.getLayoutId());
    }

    private boolean _isPaginationEnabled(HttpServletRequest httpServletRequest) {
        boolean paginate = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"paginate", (boolean)true);
        return paginate && PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN > -1;
    }

    private JSONObject _toJSONObject(Layout afterDeleteSelectedLayout, long childLayoutsCount, JSONArray childLayoutsJSONArray, HttpServletRequest httpServletRequest, boolean includeActions, Layout layout, ThemeDisplay themeDisplay) throws Exception {
        Layout draftLayout = this._getDraftLayout(layout);
        boolean hasUpdatePermission = this._layoutPermission.containsLayoutUpdatePermission(themeDisplay.getPermissionChecker(), layout);
        JSONObject jsonObject = JSONUtil.put((String)"actions", () -> {
            if (includeActions) {
                LayoutActionProvider layoutActionProvider = new LayoutActionProvider(this._groupProvider, httpServletRequest, this._language, this._siteNavigationMenuLocalService);
                return layoutActionProvider.getActionsJSONArray(layout, afterDeleteSelectedLayout);
            }
            return null;
        }).put("children", () -> {
            if (childLayoutsJSONArray.length() > 0) {
                return childLayoutsJSONArray;
            }
            return null;
        }).put("groupId", () -> {
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                return virtualLayout.getSourceGroupId();
            }
            return layout.getGroupId();
        }).put("hasChildren", layout.hasChildren()).put("icon", layout.getIcon()).put("id", layout.getPlid()).put("layoutId", layout.getLayoutId()).put("name", () -> {
            if (draftLayout != null && (hasUpdatePermission || !layout.isPublished() || this._layoutContentModelResourcePermission.contains(themeDisplay.getPermissionChecker(), layout.getPlid(), "UPDATE"))) {
                return layout.getName(themeDisplay.getLocale()) + "*";
            }
            return layout.getName(themeDisplay.getLocale());
        }).put("paginated", () -> {
            if (childLayoutsCount != (long)childLayoutsJSONArray.length()) {
                return true;
            }
            return null;
        }).put("plid", layout.getPlid()).put("priority", layout.getPriority()).put("privateLayout", layout.isPrivateLayout()).put("regularURL", () -> {
            if (hasUpdatePermission || layout.isPublished()) {
                return layout.getRegularURL(httpServletRequest);
            }
            return "";
        }).put("target", GetterUtil.getString((String)HtmlUtil.escape((String)layout.getTypeSettingsProperty("target")), (String)"_self")).put("type", layout.getType());
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        if (layoutRevision != null) {
            LayoutBranch layoutBranch;
            if (this._staging.isIncomplete(layout, layoutRevision.getLayoutSetBranchId())) {
                jsonObject.put("incomplete", true);
            }
            if (!(layoutBranch = layoutRevision.getLayoutBranch()).isMaster()) {
                jsonObject.put("layoutBranchName", layoutBranch.getName());
            }
            if (layoutRevision.isHead()) {
                jsonObject.put("layoutRevisionHead", true);
            }
            jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId());
        }
        return jsonObject;
    }
}

