/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.workflow;

import com.liferay.layout.content.LayoutContentProvider;
import com.liferay.layout.internal.configuration.LayoutWorkflowHandlerConfiguration;
import com.liferay.layout.service.LayoutLocalizationLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.layout.internal.configuration.LayoutWorkflowHandlerConfiguration"}, property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={WorkflowHandler.class})
public class LayoutWorkflowHandler
extends BaseWorkflowHandler<Layout> {
    @Reference
    private Language _language;
    @Reference
    private LayoutContentProvider _layoutContentProvider;
    private volatile LayoutWorkflowHandlerConfiguration _layoutConverterConfiguration;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalizationLocalService _layoutLocalizationLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String getClassName() {
        return Layout.class.getName();
    }

    public String getType(Locale locale) {
        return this._language.get(locale, "content-page");
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(classPK);
        if (layout.isSystem() || !layout.isTypeContent()) {
            return null;
        }
        return super.getWorkflowDefinitionLink(companyId, groupId, classPK);
    }

    public boolean isVisible() {
        return this._layoutConverterConfiguration.enabled();
    }

    public Layout updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        Layout layout = this._layoutLocalService.getLayout(classPK);
        if (layout.isDenied() && status == 1) {
            return layout;
        }
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        if (status != 0) {
            return this._layoutLocalService.updateStatus(userId, classPK, status, serviceContext);
        }
        Layout draftLayout = layout.fetchDraftLayout();
        long originalUserId = PrincipalThreadLocal.getUserId();
        try {
            PrincipalThreadLocal.setName((long)userId);
            this._layoutCopyHelper.copyLayoutContent(draftLayout, layout);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        finally {
            PrincipalThreadLocal.setName((long)originalUserId);
        }
        this._layoutLocalService.updateStatus(userId, draftLayout.getPlid(), 0, serviceContext);
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        HttpServletResponse httpServletResponse = serviceContext.getResponse();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (httpServletRequest == null && themeDisplay != null) {
            httpServletRequest = themeDisplay.getRequest();
        }
        if (httpServletResponse == null && themeDisplay != null) {
            httpServletResponse = themeDisplay.getResponse();
        }
        if (httpServletRequest != null && httpServletResponse != null) {
            layout = this._layoutLocalService.getLayout(layout.getPlid());
            this._updateLayoutContent(httpServletRequest, httpServletResponse, layout, serviceContext);
        }
        return this._layoutLocalService.updateStatus(userId, classPK, status, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._layoutConverterConfiguration = (LayoutWorkflowHandlerConfiguration)ConfigurableUtil.createConfigurable(LayoutWorkflowHandlerConfiguration.class, properties);
    }

    private void _updateLayoutContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Layout layout, ServiceContext serviceContext) {
        for (Locale locale : this._language.getAvailableLocales(layout.getGroupId())) {
            this._layoutLocalizationLocalService.updateLayoutLocalization(this._layoutContentProvider.getLayoutContent(httpServletRequest, httpServletResponse, layout, locale), LocaleUtil.toLanguageId((Locale)locale), layout.getPlid(), serviceContext);
        }
    }
}

