/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.workflow.definition.link.update.handler;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.definition.link.update.handler.WorkflowDefinitionLinkUpdateHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.LayoutRevision"}, service={WorkflowDefinitionLinkUpdateHandler.class})
public class LayoutRevisionWorkflowDefinitionLinkUpdateHandler
implements WorkflowDefinitionLinkUpdateHandler {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRevisionWorkflowDefinitionLinkUpdateHandler.class);
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public void updatedWorkflowDefinitionLink(String workflowDefinition) {
        if (Validator.isNotNull((String)workflowDefinition)) {
            return;
        }
        for (LayoutRevision layoutRevision : this._layoutRevisionLocalService.getLayoutRevisionsByStatus(1)) {
            layoutRevision.setStatus(2);
            this._layoutRevisionLocalService.updateLayoutRevision(layoutRevision);
            try {
                this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(layoutRevision.getCompanyId(), layoutRevision.getGroupId(), layoutRevision.getModelClassName(), layoutRevision.getLayoutRevisionId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to delete workflow instance links for layout revision " + layoutRevision.getLayoutRevisionId()), (Throwable)portalException);
            }
        }
    }
}

