/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.portlets.web.internal.display.context;

import com.liferay.layout.portlets.web.internal.search.PortletSearch;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.WebAppPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPortletsDisplayContext {
    private String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private final Map<String, String[]> _layoutPortletCategories = new HashMap<String, String[]>();
    private final ArrayList<Portlet> _layoutPortlets = new ArrayList();
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public LayoutPortletsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest httpServletRequest) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = httpServletRequest;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.initPortlets(themeDisplay.getCompanyId());
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public String getPortletCategoryLabels(String portletId) {
        String[] categories = this._layoutPortletCategories.get(portletId);
        Stream<String> stream = Arrays.stream(categories);
        return stream.map(category -> LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)category)).collect(Collectors.joining(", "));
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public SearchContainer getSearchContainer() {
        PortletSearch searchContainer = new PortletSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        searchContainer.setEmptyResultsMessage("there-are-no-widgets");
        searchContainer.setId("layoutPortlets");
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByType(this.getOrderByType());
        searchContainer.setTotal(this._layoutPortlets.size());
        List results = ListUtil.sort(this._layoutPortlets, (Comparator)searchContainer.getOrderByComparator());
        results = ListUtil.subList((List)results, (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        searchContainer.setResults(results);
        return searchContainer;
    }

    protected void initPortlets(long companyId) {
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get((Long)companyId, (String)"PORTLET_CATEGORY");
        Collection portletCategories = portletCategory.getCategories();
        for (PortletCategory curPortletCategory : portletCategories) {
            if (curPortletCategory.isHidden()) continue;
            for (String portletId : curPortletCategory.getPortletIds()) {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                if (portlet.isSystem() || !portlet.isInclude()) continue;
                if (portlet != null) {
                    this._layoutPortlets.add(portlet);
                }
                Object[] categories = this._layoutPortletCategories.get(portletId);
                String curPortletCategoryName = curPortletCategory.getName();
                if (categories == null) {
                    this._layoutPortletCategories.put(portletId, new String[]{curPortletCategoryName});
                    continue;
                }
                this._layoutPortletCategories.put(portletId, (String[])ArrayUtil.append((Object[])categories, (Object)curPortletCategoryName));
            }
        }
    }
}

