/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.prototype.web.display.context;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.LayoutPrototypeCreateDateComparator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPrototypeDisplayContext {
    private String _displayStyle;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public LayoutPrototypeDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest request) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._request = request;
    }

    public Boolean getActive() {
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation");
        Boolean active = null;
        if (navigation.equals("active")) {
            active = true;
        } else if (navigation.equals("inactive")) {
            active = false;
        }
        return active;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_layout_prototype_web_portlet_LayoutPrototypePortlet", "display-style", "list");
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        return portletURL;
    }

    public SearchContainer getSearchContainer() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._renderResponse.createRenderURL(), null, "there-are-no-page-templates");
        if (this.isShowAddButton()) {
            searchContainer.setEmptyResultsMessageCssClass("there-are-no-page-templates.-you-can-add-a-page-template-by-clicking-the-plus-button-on-the-bottom-right-corner");
            searchContainer.setEmptyResultsMessageCssClass("taglib-empty-result-message-header-has-plus-btn");
        }
        searchContainer.setId("layoutPrototype");
        searchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        boolean orderByAsc = false;
        if (this.getOrderByType().equals("asc")) {
            orderByAsc = true;
        }
        LayoutPrototypeCreateDateComparator orderByComparator = new LayoutPrototypeCreateDateComparator(orderByAsc);
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByComparator((OrderByComparator)orderByComparator);
        searchContainer.setOrderByType(this.getOrderByType());
        searchContainer.setTotal(this.getTotal());
        List results = LayoutPrototypeLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (Boolean)this.getActive(), (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
        searchContainer.setResults(results);
        return searchContainer;
    }

    public boolean isDescriptiveView() {
        return Objects.equals(this.getDisplayStyle(), "descriptive");
    }

    public boolean isDisabledManagementBar() {
        return this.getTotal() <= 0;
    }

    public boolean isIconView() {
        return Objects.equals(this.getDisplayStyle(), "icon");
    }

    public boolean isListView() {
        return Objects.equals(this.getDisplayStyle(), "list");
    }

    public boolean isShowAddButton() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return PortalPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (String)"ADD_LAYOUT_PROTOTYPE");
    }

    protected int getTotal() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return LayoutPrototypeLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (Boolean)this.getActive());
    }
}

