/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.prototype.web.portlet;

import com.liferay.portal.kernel.exception.NoSuchLayoutPrototypeException;
import com.liferay.portal.kernel.exception.RequiredLayoutPrototypeException;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutPrototypeService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-users-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.icon=/icons/layout_prototypes.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Page Templates", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_layout_prototype_web_portlet_LayoutPrototypePortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class LayoutPrototypePortlet
extends MVCPortlet {
    private LayoutPrototypeService _layoutPrototypeService;

    public void changeDisplayStyle(ActionRequest actionRequest, ActionResponse actionResponse) {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)actionRequest);
        portalPreferences.setValue("com_liferay_layout_prototype_web_portlet_LayoutPrototypePortlet", "display-style", displayStyle);
    }

    public void deleteLayoutPrototypes(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] layoutPrototypeIds = null;
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        layoutPrototypeIds = layoutPrototypeId > 0L ? new long[]{layoutPrototypeId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        for (long curLayoutPrototypeId : layoutPrototypeIds) {
            this._layoutPrototypeService.deleteLayoutPrototype(curLayoutPrototypeId);
        }
    }

    public void editLayoutPrototype(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)LayoutPrototype.class.getName(), (PortletRequest)actionRequest);
        if (layoutPrototypeId <= 0L) {
            this._layoutPrototypeService.addLayoutPrototype(nameMap, descriptionMap, active, serviceContext);
        } else {
            this._layoutPrototypeService.updateLayoutPrototype(layoutPrototypeId, nameMap, descriptionMap, active, serviceContext);
        }
    }

    public void resetMergeFailCount(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        LayoutPrototype layoutPrototype = this._layoutPrototypeService.getLayoutPrototype(layoutPrototypeId);
        SitesUtil.setMergeFailCount((LayoutPrototype)layoutPrototype, (int)0);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof NoSuchLayoutPrototypeException || cause instanceof PrincipalException || cause instanceof RequiredLayoutPrototypeException;
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeService(LayoutPrototypeService layoutPrototypeService) {
        this._layoutPrototypeService = layoutPrototypeService;
    }
}

