/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.test.util;

import com.liferay.layout.test.util.LayoutFriendlyURLRandomizerBumper;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class LayoutTestUtil {
    private static final Log _log = LogFactoryUtil.getLog(LayoutTestUtil.class);

    public static LayoutPrototype addLayoutPrototype(String name) throws Exception {
        return LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)TestPropsValues.getUserId(), (long)TestPropsValues.getCompanyId(), (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)name).build(), (Map)null, (boolean)true, (ServiceContext)ServiceContextTestUtil.getServiceContext());
    }

    public static LayoutSetPrototype addLayoutSetPrototype(String name) throws Exception {
        return LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)TestPropsValues.getUserId(), (long)TestPropsValues.getCompanyId(), (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)name).build(), (Map)null, (boolean)true, (boolean)true, (ServiceContext)ServiceContextTestUtil.getServiceContext());
    }

    public static String addPortletToLayout(Layout layout, String portletId) throws Exception {
        Map<String, String[]> preferenceMap = null;
        return LayoutTestUtil.addPortletToLayout(layout, portletId, preferenceMap);
    }

    public static String addPortletToLayout(Layout layout, String portletId, Map<String, String[]> preferenceMap) throws Exception {
        long userId = TestPropsValues.getUserId();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        List columns = layoutTemplate.getColumns();
        String columnId = (String)columns.get(0);
        return LayoutTestUtil.addPortletToLayout(userId, layout, portletId, columnId, preferenceMap);
    }

    public static String addPortletToLayout(long userId, Layout layout, String portletId, String columnId, Map<String, String[]> preferenceMap) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        String newPortletId = layoutTypePortlet.addPortletId(userId, portletId, columnId, -1);
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        if (preferenceMap == null) {
            return newPortletId;
        }
        PortletPreferences portletPreferences = LayoutTestUtil.getPortletPreferences(layout, newPortletId);
        for (Map.Entry<String, String[]> entry : preferenceMap.entrySet()) {
            portletPreferences.setValues(entry.getKey(), entry.getValue());
        }
        portletPreferences.store();
        return newPortletId;
    }

    public static Layout addTypeContentLayout(Group group) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)false, (long)0L, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"", (String)"", (String)"content", (boolean)false, (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentLayout(Group group, boolean privateLayout, boolean system) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)privateLayout, (long)0L, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"", (String)"", (String)"content", (boolean)false, (boolean)system, (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentLayout(Group group, boolean privateLayout, boolean system, long masterLayoutPlid) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)privateLayout, (long)0L, (long)0L, (long)0L, (Map)HashMapBuilder.put((Object)LocaleUtil.US, (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).build(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), (String)"content", (String)"", (boolean)false, (boolean)system, Collections.emptyMap(), (long)masterLayoutPlid, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)group.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentLayout(Group group, long parentPlid) throws Exception {
        Layout layout = LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)false, (long)0L, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"", (String)"", (String)"content", (boolean)false, (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId()));
        return LayoutLocalServiceUtil.updateParentLayoutId((long)layout.getPlid(), (long)parentPlid);
    }

    public static Layout addTypeContentLayout(Group group, Map<Locale, String> nameMap) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)false, (long)0L, (long)0L, (long)0L, nameMap, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), (String)"content", (String)"", (boolean)false, (boolean)false, Collections.emptyMap(), (long)0L, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)group.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentLayout(Group group, String name) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)false, (long)0L, (String)name, (String)"", (String)"", (String)"content", (boolean)false, (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentLayout(Group group, String name, String title) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)group.getGroupId(), (boolean)false, (long)0L, (String)name, (String)title, (String)"", (String)"content", (boolean)false, (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentLayout(long userId, Group group) throws Exception {
        return LayoutLocalServiceUtil.addLayout((long)userId, (long)group.getGroupId(), (boolean)false, (long)0L, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)"", (String)"", (String)"content", (boolean)false, (String)"", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout addTypeContentPublishedLayout(Group group, String name, int status) throws Exception {
        Layout layout = LayoutTestUtil.addTypeContentLayout(group, name);
        Layout draftLayout = LayoutLocalServiceUtil.fetchDraftLayout((long)layout.getPlid());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)TestPropsValues.getGroupId(), (long)TestPropsValues.getUserId());
        serviceContext.setAttribute("published", (Serializable)Boolean.TRUE);
        if (draftLayout != null) {
            LayoutLocalServiceUtil.updateStatus((long)draftLayout.getUserId(), (long)draftLayout.getPlid(), (int)status, (ServiceContext)serviceContext);
        }
        return LayoutLocalServiceUtil.updateStatus((long)layout.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
    }

    public static Layout addTypeLinkToLayoutLayout(long groupId, long linkedToLayoutId) throws Exception {
        Layout layout = LayoutTestUtil.addTypePortletLayout(groupId, false);
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("linkToLayoutId", String.valueOf(linkedToLayoutId));
        layout.setType("link_to_layout");
        return LayoutLocalServiceUtil.updateLayout((Layout)layout);
    }

    public static Layout addTypeLinkToURLLayout(long groupId, String url) throws Exception {
        Layout layout = LayoutTestUtil.addTypePortletLayout(groupId, false);
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("url", url);
        layout.setType("url");
        return LayoutLocalServiceUtil.updateLayout((Layout)layout);
    }

    public static Layout addTypePortletLayout(Group group) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(group.getGroupId());
    }

    public static Layout addTypePortletLayout(Group group, boolean privateLayout) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(group.getGroupId(), privateLayout);
    }

    public static Layout addTypePortletLayout(Group group, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(group.getGroupId(), privateLayout, layoutPrototype, linkEnabled);
    }

    public static Layout addTypePortletLayout(Group group, long parentLayoutPlid) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(group.getGroupId(), parentLayoutPlid);
    }

    public static Layout addTypePortletLayout(long groupId) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, false);
    }

    public static Layout addTypePortletLayout(long groupId, boolean privateLayout) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, privateLayout, null, false);
    }

    public static Layout addTypePortletLayout(long groupId, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{LayoutFriendlyURLRandomizerBumper.INSTANCE, NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE}), privateLayout, layoutPrototype, linkEnabled);
    }

    public static Layout addTypePortletLayout(long groupId, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> friendlyURLMap) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, privateLayout, nameMap, friendlyURLMap, false);
    }

    public static Layout addTypePortletLayout(long groupId, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> friendlyURLMap, boolean hidden) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, privateLayout, nameMap, nameMap, new HashMap<Locale, String>(), new HashMap<Locale, String>(), new HashMap<Locale, String>(), "", friendlyURLMap, hidden);
    }

    public static Layout addTypePortletLayout(long groupId, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String typeSettings, Map<Locale, String> friendlyURLMap, boolean hidden) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        return LayoutLocalServiceUtil.addLayout((long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, (String)"portlet", (String)typeSettings, (boolean)hidden, friendlyURLMap, (ServiceContext)serviceContext);
    }

    public static Layout addTypePortletLayout(long groupId, long parentLayoutPlid) throws Exception {
        Layout layout = LayoutTestUtil.addTypePortletLayout(groupId, false);
        LayoutLocalServiceUtil.updateParentLayoutId((long)layout.getPlid(), (long)parentLayoutPlid);
        return LayoutLocalServiceUtil.fetchLayout((long)layout.getPlid());
    }

    public static Layout addTypePortletLayout(long groupId, String typeSettings) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, false, RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), typeSettings, new HashMap<Locale, String>(), false);
    }

    public static Layout addTypePortletLayout(long groupId, String name, boolean privateLayout) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, name, privateLayout, null, false);
    }

    public static Layout addTypePortletLayout(long groupId, String name, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled) throws Exception {
        return LayoutTestUtil.addTypePortletLayout(groupId, name, privateLayout, layoutPrototype, linkEnabled, false);
    }

    public static Layout addTypePortletLayout(long groupId, String name, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled, boolean hidden) throws Exception {
        String friendlyURL = "/" + FriendlyURLNormalizerUtil.normalize((String)name);
        try {
            return LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)friendlyURL);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchLayoutException);
            }
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            User user = UserTestUtil.getAdminUser((long)group.getCompanyId());
            String description = "This is a test page.";
            ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext();
            if (layoutPrototype != null) {
                serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)Boolean.valueOf(linkEnabled));
                serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            }
            return LayoutLocalServiceUtil.addLayout((long)user.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, (String)name, null, (String)description, (String)"portlet", (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
        }
    }

    public static Layout addTypePortletLayout(long groupId, String name, long parentLayoutPlid) throws Exception {
        Layout layout = LayoutTestUtil.addTypePortletLayout(groupId, name, false);
        LayoutLocalServiceUtil.updateParentLayoutId((long)layout.getPlid(), (long)parentLayoutPlid);
        return LayoutLocalServiceUtil.fetchLayout((long)layout.getPlid());
    }

    public static String getLayoutTemplateId(Layout layout) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.getLayoutTemplateId();
    }

    public static PortletPreferences getPortletPreferences(Layout layout, String portletId) throws Exception {
        return PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, null);
    }

    public static PortletPreferences getPortletPreferences(long plid, String portletId) throws Exception {
        return LayoutTestUtil.getPortletPreferences(LayoutLocalServiceUtil.getLayout((long)plid), portletId);
    }

    public static List<Portlet> getPortlets(Layout layout) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.getPortlets();
    }

    public static boolean isLayoutColumnCustomizable(Layout layout, String columnId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.isColumnCustomizable(columnId);
    }

    public static Layout updateFriendlyURL(Layout layout, Map<Locale, String> friendlyURLMap) throws Exception {
        return LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (long)layout.getParentLayoutId(), (Map)layout.getNameMap(), (Map)layout.getTitleMap(), (Map)layout.getDescriptionMap(), (Map)layout.getKeywordsMap(), (Map)layout.getRobotsMap(), (String)layout.getType(), (boolean)layout.isHidden(), friendlyURLMap, (boolean)layout.getIconImage(), null, (long)layout.getStyleBookEntryId(), (long)layout.getFaviconFileEntryId(), (long)layout.getMasterLayoutPlid(), (ServiceContext)ServiceContextTestUtil.getServiceContext((long)layout.getGroupId(), (long)TestPropsValues.getUserId()));
    }

    public static Layout updateLayoutColumnCustomizable(Layout layout, String columnId, boolean customizable) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setTypeSettingsProperty(CustomizedPages.namespaceColumnId((String)columnId), String.valueOf(customizable));
        layoutTypePortlet.setUpdatePermission(customizable);
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }

    public static Layout updateLayoutPortletPreference(Layout layout, String portletId, String portletPreferenceName, String portletPreferenceValue) throws Exception {
        PortletPreferences layoutPortletPreferences = LayoutTestUtil.getPortletPreferences(layout, portletId);
        layoutPortletPreferences.setValue(portletPreferenceName, portletPreferenceValue);
        layoutPortletPreferences.store();
        return LayoutLocalServiceUtil.getLayout((long)layout.getPlid());
    }

    public static Layout updateLayoutPortletPreferences(Layout layout, String portletId, Map<String, String> portletPreferences) throws Exception {
        PortletPreferences layoutPortletPreferences = LayoutTestUtil.getPortletPreferences(layout, portletId);
        for (Map.Entry<String, String> entry : portletPreferences.entrySet()) {
            layoutPortletPreferences.setValue(entry.getKey(), entry.getValue());
        }
        layoutPortletPreferences.store();
        return LayoutLocalServiceUtil.getLayout((long)layout.getPlid());
    }

    public static Layout updateLayoutTemplateId(Layout layout, String layoutTemplateId) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        User user = UserTestUtil.getAdminUser((long)layout.getCompanyId());
        layoutTypePortlet.setLayoutTemplateId(user.getUserId(), layoutTemplateId);
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }
}

