/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.layout.uad.anonymizer;

import com.liferay.layout.uad.constants.LayoutUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutBranchLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the layout branch UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link LayoutBranchUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseLayoutBranchUADAnonymizer
	extends DynamicQueryUADAnonymizer<LayoutBranch> {

	@Override
	public void autoAnonymize(
			LayoutBranch layoutBranch, long userId, User anonymousUser)
		throws PortalException {

		if (layoutBranch.getUserId() == userId) {
			layoutBranch.setUserId(anonymousUser.getUserId());
			layoutBranch.setUserName(anonymousUser.getFullName());
		}

		layoutBranchLocalService.updateLayoutBranch(layoutBranch);
	}

	@Override
	public void delete(LayoutBranch layoutBranch) throws PortalException {
		layoutBranchLocalService.deleteLayoutBranch(layoutBranch);
	}

	@Override
	public Class<LayoutBranch> getTypeClass() {
		return LayoutBranch.class;
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return layoutBranchLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return LayoutUADConstants.USER_ID_FIELD_NAMES_LAYOUT_BRANCH;
	}

	@Reference
	protected LayoutBranchLocalService layoutBranchLocalService;

}