/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.web.portlet;

import com.liferay.mail.reader.attachment.AttachmentHandler;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.service.AttachmentLocalService;
import com.liferay.mail.reader.web.util.MailManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=mail-portlet", "com.liferay.portlet.display-category=category.collaboration", "com.liferay.portlet.footer-portlet-javascript=/js/main.js", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/mail.png", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Mail", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_mail_reader_web_portlet_MailPortlet", "javax.portlet.portlet-info.keywords=Mail", "javax.portlet.portlet-info.short-title=Mail", "javax.portlet.portlet-info.title=Mail", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class MailPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(MailPortlet.class);
    private static AttachmentLocalService _attachmentLocalService;
    @Reference
    private Portal _portal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String mvcPath = resourceRequest.getParameter("mvcPath");
        if (mvcPath.equals("/attachment.jsp")) {
            HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
            long attachmentId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"attachmentId");
            AttachmentHandler attachmentHandler = null;
            try {
                MailManager mailManager = MailManager.getInstance(request);
                Attachment attachment = _attachmentLocalService.getAttachment(attachmentId);
                attachmentHandler = mailManager.getAttachment(attachmentId);
                if (attachmentHandler == null) return;
                String contentType = MimeTypesUtil.getContentType((String)attachment.getFileName());
                PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)attachment.getFileName(), (InputStream)attachmentHandler.getInputStream(), (String)contentType);
                return;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return;
            }
            finally {
                attachmentHandler.cleanUp();
            }
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    @Reference(unbind="-")
    protected void setAttachmentLocalService(AttachmentLocalService attachmentLocalService) {
        _attachmentLocalService = attachmentLocalService;
    }
}

