/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.web.portlet.action;

import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.service.AccountLocalService;
import com.liferay.mail.reader.web.util.MailManager;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"key=login.events.post"}, service={LifecycleAction.class})
public class LoginPostAction
extends Action {
    @Reference
    private AccountLocalService _accountLocalService;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            this.initiateSynchronization(request);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void initiateSynchronization(HttpServletRequest request) throws PortalException {
        long userId = this._portal.getUserId(request);
        if (userId <= 0L) {
            return;
        }
        List accounts = this._accountLocalService.getAccounts(userId);
        if (accounts.isEmpty()) {
            return;
        }
        MailManager mailManager = MailManager.getInstance(request);
        for (Account account : accounts) {
            mailManager.synchronizeAccount(account.getAccountId());
        }
    }
}

