'use strict';

Liferay.Loader.define("map-google-maps@2.0.4/js/GoogleMapsSearch.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-dom', 'map-common/js/validators.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.GoogleMapsSearch = undefined;

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
		return typeof obj;
	} : function (obj) {
		return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	};

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _validators = require('map-common/js/validators.es');

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * GoogleMapsSearch
  * @review
  */
	var GoogleMapsSearch = function (_State) {
		_inherits(GoogleMapsSearch, _State);

		/**
   * Creates a new search handler using Google Map's API
   * @param  {Array} args List of arguments to be passed to State
   * @review
   */
		function GoogleMapsSearch() {
			var _ref;

			_classCallCheck(this, GoogleMapsSearch);

			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = GoogleMapsSearch.__proto__ || Object.getPrototypeOf(GoogleMapsSearch)).call.apply(_ref, [this].concat(args)));

			var inputNode = (0, _metalDom.toElement)(_this.inputNode);
			_this._handlePlaceChanged = _this._handlePlaceChanged.bind(_this);

			_this._autocomplete = new google.maps.places.Autocomplete(inputNode);
			_this._bindUI();
			return _this;
		}

		/**
   * Removes the listeners that have been added to the search input.
   * @review
   */

		_createClass(GoogleMapsSearch, [{
			key: 'destructor',
			value: function destructor() {
				this._eventHandlers.forEach(function (item) {
					google.maps.event.removeListener(item);
				});
			}

			/**
    * Adds listeners for the created map object.
    * It listens for a custom 'place_changed' event and executes
    * GoogleMapsSearch._handlePlaceChanged.
    * @protected
    * @review
    */

		}, {
			key: '_bindUI',
			value: function _bindUI() {
				this._eventHandlers = [google.maps.event.addListener(this._autocomplete, 'place_changed', this._handlePlaceChanged)];
			}

			/**
    * Gets the new place that has been processed by Google Maps and emits a
    * 'search' event with the location information and the address.
    * @protected
    * @review
    */

		}, {
			key: '_handlePlaceChanged',
			value: function _handlePlaceChanged() {
				var place = this._autocomplete.getPlace();

				if (place && (typeof place === 'undefined' ? 'undefined' : _typeof(place)) === 'object' && place.geometry) {
					var location = place.geometry.location;

					this.emit('search', {
						position: {
							address: place.formatted_address,
							location: {
								lat: location.lat(),
								lng: location.lng()
							}
						}
					});
				}
			}
		}]);

		return GoogleMapsSearch;
	}(_metalState2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	GoogleMapsSearch.STATE = {
		/**
   * Input element that will be used for searching addresses.
   * @review
   * @type {HTMLInputElement}
   */
		inputNode: _metalState.Config.validator(_validators.isInputNode).value(null)
	};

	exports.default = GoogleMapsSearch;
	exports.GoogleMapsSearch = GoogleMapsSearch;
	//# sourceMappingURL=GoogleMapsSearch.es.js.map
});
//# sourceMappingURL=GoogleMapsSearch.es.js.map