/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.media.object.apio.internal.architect.form;

import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.form.Form;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;

public class MediaObjectCreatorForm {
    private BinaryFile _binaryFile;
    private String _changelog;
    private String _description;
    private List<String> _keywords;
    private String _name;
    private String _title;

    public static Form<MediaObjectCreatorForm> buildForm(Form.Builder<MediaObjectCreatorForm> formBuilder) {
        return formBuilder.title(__ -> "The media object creator form").description(__ -> "This form can be used to create a media object").constructor(MediaObjectCreatorForm::new).addOptionalString("changeLog", MediaObjectCreatorForm::setChangelog).addOptionalString("description", MediaObjectCreatorForm::setDescription).addOptionalString("headline", MediaObjectCreatorForm::setTitle).addOptionalStringList("keywords", MediaObjectCreatorForm::setKeywords).addRequiredFile("binaryFile", MediaObjectCreatorForm::setBinaryFile).addRequiredString("name", MediaObjectCreatorForm::setName).build();
    }

    public BinaryFile getBinaryFile() {
        return this._binaryFile;
    }

    public String getChangelog() {
        return this._changelog;
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public ServiceContext getServiceContext(long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        if (ListUtil.isNotEmpty(this._keywords)) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray(this._keywords));
        }
        serviceContext.setScopeGroupId(groupId);
        return serviceContext;
    }

    public String getTitle() {
        return this._title;
    }

    public void setBinaryFile(BinaryFile binaryFile) {
        this._binaryFile = binaryFile;
    }

    public void setChangelog(String changelog) {
        this._changelog = changelog;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setKeywords(List<String> keywords) {
        this._keywords = keywords;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

